/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData;
import com.stripe.android.stripe3ds2.transactions.UiType;
import com.stripe.android.stripe3ds2.views.ChallengeZoneSelectView;
import com.stripe.android.stripe3ds2.views.ChallengeZoneTextView;
import com.stripe.android.stripe3ds2.views.ChallengeZoneWebView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeEntryViewFactory;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "createChallengeEntryTextView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneTextView;", "challengeResponseData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeResponseData;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "createChallengeEntrySelectView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView;", "createChallengeEntryWebView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneWebView;", "3ds2sdk_release"})
public final class ChallengeEntryViewFactory {
    @NotNull
    private final Context context;

    public ChallengeEntryViewFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final ChallengeZoneTextView createChallengeEntryTextView(@NotNull ChallengeResponseData challengeResponseData, @NotNull UiCustomization uiCustomization) {
        ChallengeZoneTextView challengeZoneTextView;
        Intrinsics.checkNotNullParameter((Object)challengeResponseData, (String)"challengeResponseData");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        ChallengeZoneTextView it = challengeZoneTextView = new ChallengeZoneTextView(this.context, null, 0, 6, null);
        boolean bl = false;
        it.setTextEntryLabel(challengeResponseData.getChallengeInfoLabel());
        it.setTextBoxCustomization(uiCustomization.getTextBoxCustomization());
        return challengeZoneTextView;
    }

    @NotNull
    public final ChallengeZoneSelectView createChallengeEntrySelectView(@NotNull ChallengeResponseData challengeResponseData, @NotNull UiCustomization uiCustomization) {
        ChallengeZoneSelectView challengeZoneSelectView;
        Intrinsics.checkNotNullParameter((Object)challengeResponseData, (String)"challengeResponseData");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        boolean isSingleSelectMode = challengeResponseData.getUiType() == UiType.SingleSelect;
        ChallengeZoneSelectView it = challengeZoneSelectView = new ChallengeZoneSelectView(this.context, null, 0, isSingleSelectMode, 6, null);
        boolean bl = false;
        it.setTextEntryLabel(challengeResponseData.getChallengeInfoLabel(), uiCustomization.getLabelCustomization());
        it.setChallengeSelectOptions(challengeResponseData.getChallengeSelectOptions(), uiCustomization.getButtonCustomization(UiCustomization.ButtonType.SELECT));
        return challengeZoneSelectView;
    }

    @NotNull
    public final ChallengeZoneWebView createChallengeEntryWebView(@NotNull ChallengeResponseData challengeResponseData) {
        ChallengeZoneWebView challengeZoneWebView;
        Intrinsics.checkNotNullParameter((Object)challengeResponseData, (String)"challengeResponseData");
        ChallengeZoneWebView it = challengeZoneWebView = new ChallengeZoneWebView(this.context, null, 0, 6, null);
        boolean bl = false;
        it.loadHtml(challengeResponseData.getAcsHtml());
        return challengeZoneWebView;
    }
}

