package com.stripe.android.stripe3ds2.transaction

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

// NOTE: Copied from reference app spec

/**
 * An error message that is generated by the 3DS SDK to be returned to the ACS.
 * The ProtocolErrorEvent class shall represent an error message of this type.
 * The 3DS SDK sends the error code and details from this error message as part of the notification
 * to the 3DS Requestor App.
 *
 * Note: This error message is not a run-time error that is encountered by the 3DS SDK.
 * For information about run-time errors, refer to Class com.ults.samplesdk.RuntimeErrorEvent.
 *
 * For more information about error messages, refer to Section A.5.5, "Error Code, Error
 * Description, and Error Details" and Table B.10, "Error Message Data Elements" in the EMV 3DS
 * Protocol Specification.
 */
@Parcelize
data class ProtocolErrorEvent(
    /**
     * The SDK Transaction ID.
     */
    val sdkTransactionId: SdkTransactionId?,

    /**
     * The error message.
     */
    val errorMessage: ErrorMessage
) : Parcelable
