/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.widget.ProgressBar;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.appcompat.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0007J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0007J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010H\u0007J\u001a\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "", "()V", "DEFAULT_DARKEN_FACTOR", "", "applyProgressBarColor", "", "progressBar", "Landroid/widget/ProgressBar;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "buildStyledText", "Landroid/text/SpannableString;", "context", "Landroid/content/Context;", "text", "", "customization", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "colorIntToHex", "color", "", "darken", "factor", "getThemeAccentColor", "getThemeAccentColor$3ds2sdk_release", "(Landroid/content/Context;)Ljava/lang/Integer;", "getThemeColor", "colorAttrResId", "getThemeColor$3ds2sdk_release", "(Landroid/content/Context;I)Ljava/lang/Integer;", "requireValidColor", "hexColor", "requireValidDimension", "dimension", "requireValidFontSize", "fontSize", "requireValidString", "string", "setStatusBarColor", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "statusBarColor", "3ds2sdk_release"})
public final class CustomizeUtils {
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();

    @JvmStatic
    public static final void applyProgressBarColor(@NotNull ProgressBar progressBar, @NotNull UiCustomization uiCustomization) {
        UiCustomization uiCustomization2 = uiCustomization;
        Intrinsics.checkParameterIsNotNull((Object)progressBar, (String)"progressBar");
        Intrinsics.checkParameterIsNotNull((Object)uiCustomization2, (String)"uiCustomization");
        if (uiCustomization2.getAccentColor() != null) {
            int n2 = Color.parseColor((String)uiCustomization.getAccentColor());
            if (Build.VERSION.SDK_INT >= 21) {
                progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n2));
            } else {
                ProgressBar progressBar2 = progressBar;
                Drawable drawable2 = progressBar2.getIndeterminateDrawable().mutate();
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"progressBar.indeterminateDrawable.mutate()");
                drawable2.setColorFilter(n2, PorterDuff.Mode.SRC_IN);
                progressBar2.setIndeterminateDrawable(drawable2);
            }
        }
    }

    @JvmStatic
    public static final void setStatusBarColor(@NotNull AppCompatActivity appCompatActivity, @ColorInt int n2) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = appCompatActivity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            window.setStatusBarColor(n2);
        }
    }

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int n2) {
        int n3 = n2;
        n2 = Color.alpha((int)n3);
        int n4 = Color.blue((int)n3);
        int n5 = Color.green((int)n3);
        int n6 = Color.red((int)n3);
        StringBuilder stringBuilder = new StringBuilder().append("#");
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Object[] objectArray = new Object[]{n2};
        String string2 = String.format(locale, "%02X", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        Locale locale2 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ENGLISH");
        Object[] objectArray2 = new Object[]{n6};
        String string3 = String.format(locale2, "%02X", Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        Locale locale3 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ENGLISH");
        Object[] objectArray3 = new Object[]{n5};
        String string4 = String.format(locale3, "%02X", Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string4);
        Locale locale4 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.ENGLISH");
        Object[] objectArray4 = new Object[]{n4};
        String string5 = String.format(locale4, "%02X", Arrays.copyOf(objectArray4, objectArray4.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        return stringBuilder4.append(string5).toString();
    }

    @JvmStatic
    @NotNull
    public static final SpannableString buildStyledText(@NotNull Context object, @NotNull String object2, @NotNull Customization customization) {
        SpannableString spannableString;
        Customization customization2 = customization;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)object2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)customization2, (String)"customization");
        SpannableString spannableString2 = spannableString;
        spannableString = new SpannableString((CharSequence)object2);
        object2 = customization2.getTextColor();
        if (object2 != null) {
            spannableString2.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)object2)), 0, spannableString2.length(), 0);
        }
        if (!(((Number)(object2 = Integer.valueOf(customization.getTextFontSize()))).intValue() > 0)) {
            object2 = null;
        }
        if (object2 != null) {
            float f2 = ((Number)object2).intValue();
            Resources resources = object.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            object2 = resources.getDisplayMetrics();
            int n2 = (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)object2);
            spannableString2.setSpan((Object)new AbsoluteSizeSpan(n2), 0, spannableString2.length(), 0);
        }
        if ((object = customization.getTextFontName()) != null) {
            spannableString2.setSpan((Object)new TypefaceSpan((String)object), 0, spannableString2.length(), 0);
        }
        return spannableString2;
    }

    @JvmStatic
    @ColorInt
    public static final int darken(@ColorInt int n2) {
        return INSTANCE.darken(n2, 0.8f);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String string2) throws InvalidInputException {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"hexColor");
        try {
            Color.parseColor((String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidInputException(new RuntimeException("Unable to parse color: " + string2));
        }
        return string3;
    }

    @JvmStatic
    public static final int requireValidFontSize(int n2) throws InvalidInputException {
        if (n2 > 0) {
            return n2;
        }
        throw new InvalidInputException(new RuntimeException("Font size must be greater than 0"));
    }

    @JvmStatic
    public static final int requireValidDimension(int n2) throws InvalidInputException {
        if (n2 >= 0) {
            return n2;
        }
        throw new InvalidInputException(new RuntimeException("Dimension must be greater or equal to 0"));
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String string2) throws InvalidInputException {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"string");
        if (!StringsKt.isBlank((CharSequence)string3)) {
            return string2;
        }
        throw new InvalidInputException(new RuntimeException("String must not be null or empty"));
    }

    @Nullable
    public final Integer getThemeAccentColor$3ds2sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int n2 = Build.VERSION.SDK_INT >= 21 ? 16843829 : R.attr.colorAccent;
        return this.getThemeColor$3ds2sdk_release(context, n2);
    }

    @Nullable
    public final Integer getThemeColor$3ds2sdk_release(@NotNull Context context, @AttrRes int n2) {
        TypedValue typedValue;
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        CustomizeUtils customizeUtils = typedValue;
        typedValue = new TypedValue();
        if (context2.getTheme().resolveAttribute(n2, (TypedValue)customizeUtils, true)) {
            n2 = ((TypedValue)customizeUtils).resourceId;
            return n2 != 0 ? Integer.valueOf(ContextCompat.getColor((Context)context, (int)n2)) : Integer.valueOf(((TypedValue)customizeUtils).data);
        }
        return null;
    }

    @ColorInt
    public final int darken(@ColorInt int n2, float f2) {
        int n3 = Color.alpha((int)n2);
        int n4 = (int)((float)Color.red((int)n2) * f2);
        int n5 = n2;
        int n6 = (int)((float)Color.green((int)n5) * f2);
        n2 = (int)((float)Color.blue((int)n5) * f2);
        return Color.argb((int)n3, (int)Math.min(Math.max(n4, 0), 255), (int)Math.min(Math.max(n6, 0), 255), (int)Math.min(Math.max(n2, 0), 255));
    }
}

