/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.content.ContextCompat;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeLabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeTextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kotlin.jvm.internal.Intrinsics;

public final class StripeUiCustomization
implements UiCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeUiCustomization> CREATOR = new Parcelable.Creator<StripeUiCustomization>(){

        public Object[] newArray(int n2) {
            return new StripeUiCustomization[n2];
        }

        public Object createFromParcel(Parcel parcel) {
            return new StripeUiCustomization(parcel, null);
        }
    };
    @Nullable
    public ToolbarCustomization a;
    @Nullable
    public LabelCustomization b;
    @Nullable
    public TextBoxCustomization c;
    @NonNull
    public final Map<UiCustomization.ButtonType, ButtonCustomization> d;
    @NonNull
    public final Map<String, ButtonCustomization> e;
    @Nullable
    public String f;

    public StripeUiCustomization() {
        this.d = new EnumMap<UiCustomization.ButtonType, ButtonCustomization>(UiCustomization.ButtonType.class);
        this.e = new HashMap<String, ButtonCustomization>();
    }

    @NonNull
    public static StripeUiCustomization createWithAppTheme(@NonNull Activity activity) {
        return new StripeUiCustomization(activity);
    }

    public StripeUiCustomization(@NonNull Activity object) {
        this();
        StripeButtonCustomization stripeButtonCustomization;
        StripeButtonCustomization stripeButtonCustomization2;
        Object object2;
        TypedValue typedValue;
        int n2 = R.attr.actionBarTheme;
        TypedValue typedValue2 = typedValue;
        typedValue = new TypedValue();
        if (object.getTheme().resolveAttribute(n2, typedValue2, true)) {
            ContextThemeWrapper contextThemeWrapper;
            object2 = contextThemeWrapper;
            contextThemeWrapper = new ContextThemeWrapper((Context)object, typedValue2.resourceId);
        } else {
            object2 = object;
        }
        int n3 = Build.VERSION.SDK_INT >= 21 ? 16843827 : R.attr.colorPrimary;
        String string2 = this.a((Context)object, n3);
        int n4 = Build.VERSION.SDK_INT >= 21 ? 16843828 : R.attr.colorPrimaryDark;
        Activity activity = object2;
        object2 = this.a((Context)object, n4);
        String string3 = this.a((Context)activity, 16842806);
        String string4 = this.a((Context)object, 16842904);
        int n5 = Build.VERSION.SDK_INT >= 21 ? 16843829 : R.attr.colorAccent;
        Activity activity2 = object;
        object = this.a((Context)object, n5);
        Object object3 = this.a((Context)activity2, 16842906);
        StripeUiCustomization stripeUiCustomization = this;
        stripeUiCustomization.a = new StripeToolbarCustomization();
        stripeUiCustomization.b = new StripeLabelCustomization();
        stripeUiCustomization.c = new StripeTextBoxCustomization();
        if (object3 != null) {
            this.c.setHintTextColor((String)object3);
        }
        object3 = stripeButtonCustomization2;
        stripeButtonCustomization2 = new StripeButtonCustomization();
        StripeButtonCustomization stripeButtonCustomization3 = stripeButtonCustomization;
        stripeButtonCustomization = new StripeButtonCustomization();
        if (string3 != null) {
            this.a.setTextColor(string3);
            object3.setTextColor(string3);
        }
        if (string2 != null) {
            this.a.setBackgroundColor(string2);
        }
        if (object2 != null) {
            this.a.setStatusBarColor((String)object2);
        }
        if (string4 != null) {
            StripeUiCustomization stripeUiCustomization2 = this;
            stripeUiCustomization2.b.setTextColor(string4);
            stripeUiCustomization2.b.setHeadingTextColor(string4);
            stripeButtonCustomization3.setTextColor(string4);
            this.c.setTextColor(string4);
        }
        if (object != null) {
            StripeUiCustomization stripeUiCustomization3 = this;
            stripeUiCustomization3.setAccentColor((String)object);
            StripeButtonCustomization stripeButtonCustomization4 = new StripeButtonCustomization();
            stripeButtonCustomization4.setTextColor((String)object);
            stripeUiCustomization3.setButtonCustomization((ButtonCustomization)stripeButtonCustomization4, UiCustomization.ButtonType.RESEND);
            stripeButtonCustomization3.setBackgroundColor((String)object);
        }
        this.setButtonCustomization((ButtonCustomization)object3, UiCustomization.ButtonType.CANCEL);
        this.setButtonCustomization((ButtonCustomization)stripeButtonCustomization3, UiCustomization.ButtonType.NEXT);
        this.setButtonCustomization((ButtonCustomization)stripeButtonCustomization3, UiCustomization.ButtonType.CONTINUE);
        this.setButtonCustomization((ButtonCustomization)stripeButtonCustomization3, UiCustomization.ButtonType.SUBMIT);
        this.setButtonCustomization((ButtonCustomization)stripeButtonCustomization3, UiCustomization.ButtonType.SELECT);
    }

    public /* synthetic */ StripeUiCustomization(Parcel parcel, a object) {
        StripeUiCustomization stripeUiCustomization = this;
        this.f = parcel.readString();
        this.a = (ToolbarCustomization)parcel.readParcelable(StripeToolbarCustomization.class.getClassLoader());
        this.b = (LabelCustomization)parcel.readParcelable(StripeLabelCustomization.class.getClassLoader());
        stripeUiCustomization.c = (TextBoxCustomization)parcel.readParcelable(StripeTextBoxCustomization.class.getClassLoader());
        stripeUiCustomization.d = new HashMap<UiCustomization.ButtonType, ButtonCustomization>();
        object = parcel.readBundle(StripeUiCustomization.class.getClassLoader());
        if (object != null) {
            for (Object object2 : object.keySet()) {
                ButtonCustomization buttonCustomization = (ButtonCustomization)object.getParcelable((String)object2);
                if (buttonCustomization == null) continue;
                this.d.put(UiCustomization.ButtonType.valueOf((String)object2), buttonCustomization);
            }
        }
        this.e = new HashMap<String, ButtonCustomization>();
        if ((parcel = parcel.readBundle(StripeUiCustomization.class.getClassLoader())) != null) {
            for (Object object3 : parcel.keySet()) {
                Object object2;
                object2 = (ButtonCustomization)parcel.getParcelable((String)object3);
                if (object2 == null) continue;
                this.e.put((String)object3, (ButtonCustomization)object2);
            }
        }
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        this.d.put(buttonType, buttonCustomization);
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull String string2) throws InvalidInputException {
        this.e.put(string2, buttonCustomization);
    }

    @Override
    public void setToolbarCustomization(@NonNull ToolbarCustomization toolbarCustomization) throws InvalidInputException {
        this.a = toolbarCustomization;
    }

    @Override
    public void setLabelCustomization(@NonNull LabelCustomization labelCustomization) throws InvalidInputException {
        this.b = labelCustomization;
    }

    @Override
    public void setTextBoxCustomization(@NonNull TextBoxCustomization textBoxCustomization) throws InvalidInputException {
        this.c = textBoxCustomization;
    }

    @Override
    public void setAccentColor(@NonNull String string2) {
        this.f = CustomizeUtils.requireValidColor(string2);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        return this.d.get((Object)buttonType);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull String string2) throws InvalidInputException {
        return this.e.get(string2);
    }

    @Override
    @Nullable
    public ToolbarCustomization getToolbarCustomization() {
        return this.a;
    }

    @Override
    @Nullable
    public LabelCustomization getLabelCustomization() {
        return this.b;
    }

    @Override
    @Nullable
    public TextBoxCustomization getTextBoxCustomization() {
        return this.c;
    }

    @Override
    @Nullable
    public String getAccentColor() {
        return this.f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (this == object) return true;
        if (!(object instanceof StripeUiCustomization)) return false;
        object = (StripeUiCustomization)object;
        if (!Intrinsics.areEqual((Object)this.a, (Object)((StripeUiCustomization)object).a)) return false;
        if (!Intrinsics.areEqual((Object)this.f, (Object)((StripeUiCustomization)object).f)) return false;
        if (!Intrinsics.areEqual((Object)this.b, (Object)((StripeUiCustomization)object).b)) return false;
        if (!Intrinsics.areEqual((Object)this.c, (Object)((StripeUiCustomization)object).c)) return false;
        if (!Intrinsics.areEqual(this.d, ((StripeUiCustomization)object).d)) return false;
        if (!Intrinsics.areEqual(this.e, ((StripeUiCustomization)object).e)) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.a;
        objectArray2[1] = this.f;
        objectArray2[2] = this.b;
        objectArray2[3] = this.c;
        objectArray2[4] = this.d;
        objectArray[5] = this.e;
        Intrinsics.checkParameterIsNotNull((Object)objectArray, (String)"values");
        return Objects.hash(Arrays.copyOf(objectArray, objectArray.length));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n2) {
        Bundle bundle;
        Bundle bundle2;
        StripeUiCustomization stripeUiCustomization2;
        parcel.writeString(stripeUiCustomization2.f);
        parcel.writeParcelable((Parcelable)((StripeToolbarCustomization)stripeUiCustomization2.a), 0);
        parcel.writeParcelable((Parcelable)((StripeLabelCustomization)stripeUiCustomization2.b), 0);
        parcel.writeParcelable((Parcelable)((StripeTextBoxCustomization)stripeUiCustomization2.c), 0);
        Bundle bundle3 = bundle2;
        bundle2 = new Bundle();
        for (Map.Entry<UiCustomization.ButtonType, ButtonCustomization> entry : stripeUiCustomization2.d.entrySet()) {
            bundle3.putParcelable(entry.getKey().name(), (Parcelable)((StripeButtonCustomization)entry.getValue()));
        }
        StripeUiCustomization stripeUiCustomization = stripeUiCustomization2;
        parcel.writeBundle(bundle3);
        stripeUiCustomization2 = bundle;
        bundle = new Bundle();
        for (Map.Entry entry : stripeUiCustomization.e.entrySet()) {
            stripeUiCustomization2.putParcelable((String)entry.getKey(), (StripeButtonCustomization)entry.getValue());
        }
        parcel.writeBundle((Bundle)stripeUiCustomization2);
    }

    @Nullable
    public final String a(@NonNull Context context, @AttrRes int n2) {
        TypedValue typedValue;
        StripeUiCustomization stripeUiCustomization = typedValue;
        typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(n2, (TypedValue)stripeUiCustomization, true)) {
            n2 = ((TypedValue)stripeUiCustomization).resourceId;
            return CustomizeUtils.colorIntToHex(n2 != 0 ? ContextCompat.getColor((Context)context, (int)n2) : ((TypedValue)stripeUiCustomization).data);
        }
        return null;
    }
}

