/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.repositories;

import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.ElementsSessionParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.IntentConfigurationKtxKt;
import com.stripe.android.paymentsheet.PaymentSheet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0004H\u0082\b\u00a2\u0006\u0002\u0010\u0006\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\tH\u0002\u001a.\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"getResultOrElse", "Lkotlin/Result;", "T", "transform", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toElementSessionParam", "", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "toElementsSessionParams", "Lcom/stripe/android/model/ElementsSessionParams;", "Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;", "customer", "externalPaymentMethods", "", "defaultPaymentMethodId", "toStripeIntent", "Lcom/stripe/android/model/StripeIntent;", "Lcom/stripe/android/model/ElementsSessionParams$DeferredIntentType;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "withoutWeChatPay", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nElementsSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsSessionRepository.kt\ncom/stripe/android/paymentsheet/repositories/ElementsSessionRepositoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n766#2:196\n857#2,2:197\n1#3:199\n*S KotlinDebug\n*F\n+ 1 ElementsSessionRepository.kt\ncom/stripe/android/paymentsheet/repositories/ElementsSessionRepositoryKt\n*L\n105#1:196\n105#1:197,2\n*E\n"})
public final class ElementsSessionRepositoryKt {
    /*
     * WARNING - void declaration
     */
    private static final StripeIntent withoutWeChatPay(StripeIntent $this$withoutWeChatPay) {
        StripeIntent stripeIntent;
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$withoutWeChatPay.getPaymentMethodTypes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)PaymentMethod.Type.WeChatPay.code))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)"card");
        } else {
            collection = collection2;
        }
        List filteredPaymentMethodTypes = (List)collection;
        collection2 = $this$withoutWeChatPay;
        if (collection2 instanceof PaymentIntent) {
            stripeIntent = (StripeIntent)PaymentIntent.copy$default((PaymentIntent)((PaymentIntent)$this$withoutWeChatPay), null, (List)filteredPaymentMethodTypes, null, (long)0L, null, null, null, null, null, (long)0L, null, null, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, (int)0xFFFFFD, null);
        } else if (collection2 instanceof SetupIntent) {
            stripeIntent = (StripeIntent)SetupIntent.copy$default((SetupIntent)((SetupIntent)$this$withoutWeChatPay), null, null, (long)0L, null, null, null, (boolean)false, null, null, (List)filteredPaymentMethodTypes, null, null, null, null, null, null, null, (int)130559, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stripeIntent;
    }

    @NotNull
    public static final ElementsSessionParams toElementsSessionParams(@NotNull PaymentSheet.InitializationMode $this$toElementsSessionParams, @Nullable PaymentSheet.CustomerConfiguration customer2, @NotNull List<String> externalPaymentMethods, @Nullable String defaultPaymentMethodId) {
        ElementsSessionParams elementsSessionParams;
        Intrinsics.checkNotNullParameter((Object)$this$toElementsSessionParams, (String)"<this>");
        Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
        PaymentSheet.CustomerConfiguration customerConfiguration = customer2;
        String customerSessionClientSecret = customerConfiguration != null ? ElementsSessionRepositoryKt.toElementSessionParam(customerConfiguration) : null;
        PaymentSheet.InitializationMode initializationMode = $this$toElementsSessionParams;
        if (initializationMode instanceof PaymentSheet.InitializationMode.PaymentIntent) {
            String string2 = ((PaymentSheet.InitializationMode.PaymentIntent)$this$toElementsSessionParams).getClientSecret();
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.PaymentIntentType(string2, null, customerSessionClientSecret, defaultPaymentMethodId, externalPaymentMethods, 2, null);
        } else if (initializationMode instanceof PaymentSheet.InitializationMode.SetupIntent) {
            String string3 = ((PaymentSheet.InitializationMode.SetupIntent)$this$toElementsSessionParams).getClientSecret();
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.SetupIntentType(string3, null, customerSessionClientSecret, defaultPaymentMethodId, externalPaymentMethods, 2, null);
        } else if (initializationMode instanceof PaymentSheet.InitializationMode.DeferredIntent) {
            DeferredIntentParams deferredIntentParams = IntentConfigurationKtxKt.toDeferredIntentParams(((PaymentSheet.InitializationMode.DeferredIntent)$this$toElementsSessionParams).getIntentConfiguration());
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.DeferredIntentType(null, deferredIntentParams, externalPaymentMethods, defaultPaymentMethodId, customerSessionClientSecret, 1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return elementsSessionParams;
    }

    private static final String toElementSessionParam(PaymentSheet.CustomerConfiguration $this$toElementSessionParam) {
        String string2;
        PaymentSheet.CustomerAccessType customerAccessType = $this$toElementSessionParam.getAccessType$paymentsheet_release();
        if (customerAccessType instanceof PaymentSheet.CustomerAccessType.CustomerSession) {
            string2 = ((PaymentSheet.CustomerAccessType.CustomerSession)$this$toElementSessionParam.getAccessType$paymentsheet_release()).getCustomerSessionClientSecret();
        } else if (customerAccessType instanceof PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey) {
            string2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final StripeIntent toStripeIntent(ElementsSessionParams.DeferredIntentType $this$toStripeIntent, ApiRequest.Options options) {
        StripeIntent stripeIntent;
        DeferredIntentParams deferredIntentParams = $this$toStripeIntent.getDeferredIntentParams();
        long now = Calendar.getInstance().getTimeInMillis();
        DeferredIntentParams.Mode deferredIntentMode = deferredIntentParams.getMode();
        if (deferredIntentMode instanceof DeferredIntentParams.Mode.Payment) {
            stripeIntent = (StripeIntent)new PaymentIntent(deferredIntentParams.getPaymentMethodConfigurationId(), deferredIntentParams.getPaymentMethodTypes(), Long.valueOf(((DeferredIntentParams.Mode.Payment)deferredIntentMode).getAmount()), 0L, null, null, $this$toStripeIntent.getClientSecret(), null, null, now, deferredIntentParams.getMode().getCurrency(), null, options.getApiKeyIsLiveMode(), null, null, null, null, null, null, null, CollectionsKt.emptyList(), null, null, null, 15722680, null);
        } else if (deferredIntentMode instanceof DeferredIntentParams.Mode.Setup) {
            String string2 = deferredIntentParams.getPaymentMethodConfigurationId();
            String string3 = $this$toStripeIntent.getClientSecret();
            boolean bl = options.getApiKeyIsLiveMode();
            List list = CollectionsKt.emptyList();
            List list2 = deferredIntentParams.getPaymentMethodTypes();
            List list3 = CollectionsKt.emptyList();
            stripeIntent = (StripeIntent)new SetupIntent(string2, null, now, null, string3, null, bl, null, null, list2, null, null, null, list3, list, null, null, 69760, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stripeIntent;
    }

    private static final <T> Object getResultOrElse(Object $this$getResultOrElse, Function1<? super Throwable, ? extends Result<? extends T>> transform) {
        boolean $i$f$getResultOrElse = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$getResultOrElse);
        return throwable != null ? ((Result)transform.invoke((Object)throwable)).unbox-impl() : $this$getResultOrElse;
    }

    public static final /* synthetic */ StripeIntent access$toStripeIntent(ElementsSessionParams.DeferredIntentType $receiver, ApiRequest.Options options) {
        return ElementsSessionRepositoryKt.toStripeIntent($receiver, options);
    }

    public static final /* synthetic */ StripeIntent access$withoutWeChatPay(StripeIntent $receiver) {
        return ElementsSessionRepositoryKt.withoutWeChatPay($receiver);
    }
}

