/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.res.ResourcesCompat;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.model.PaymentOption;
import com.stripe.android.paymentsheet.model.PaymentOptionFactory;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.ui.PaymentMethodsUiExtensionKt;
import com.stripe.android.uicore.image.StripeImageLoader;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0081@\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "", "resources", "Landroid/content/res/Resources;", "imageLoader", "Lcom/stripe/android/uicore/image/StripeImageLoader;", "context", "Landroid/content/Context;", "(Landroid/content/res/Resources;Lcom/stripe/android/uicore/image/StripeImageLoader;Landroid/content/Context;)V", "create", "Lcom/stripe/android/paymentsheet/model/PaymentOption;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "getSavedIcon", "", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$Saved;", "getSavedLabel", "Lcom/stripe/android/core/strings/ResolvableString;", "isDarkTheme", "", "loadPaymentOption", "Landroid/graphics/drawable/Drawable;", "paymentOption", "loadPaymentOption$paymentsheet_release", "(Lcom/stripe/android/paymentsheet/model/PaymentOption;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class PaymentOptionFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Resources resources;
    @NotNull
    private final StripeImageLoader imageLoader;
    @NotNull
    private final Context context;
    public static final int $stable = 8;
    @NotNull
    private static final ShapeDrawable emptyDrawable = new ShapeDrawable();

    @Inject
    public PaymentOptionFactory(@NotNull Resources resources, @NotNull StripeImageLoader imageLoader, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.resources = resources;
        this.imageLoader = imageLoader;
        this.context = context;
    }

    private final boolean isDarkTheme() {
        Configuration configuration = this.resources.getConfiguration();
        return configuration != null ? (configuration.uiMode & 0x30) == 32 : false;
    }

    @VisibleForTesting
    @Nullable
    public final Object loadPaymentOption$paymentsheet_release(@NotNull PaymentOption paymentOption, @NotNull Continuation<? super Drawable> $completion) {
        String lightThemeIconUrl = paymentOption.getLightThemeIconUrl$paymentsheet_release();
        String darkThemeIconUrl = paymentOption.getDarkThemeIconUrl$paymentsheet_release();
        if (this.isDarkTheme() && darkThemeIconUrl != null) {
            return PaymentOptionFactory.loadPaymentOption$loadIcon(this, paymentOption, darkThemeIconUrl, $completion);
        }
        if (lightThemeIconUrl != null) {
            return PaymentOptionFactory.loadPaymentOption$loadIcon(this, paymentOption, lightThemeIconUrl, $completion);
        }
        return PaymentOptionFactory.loadPaymentOption$loadResource(this, paymentOption);
    }

    @NotNull
    public final PaymentOption create(@NotNull PaymentSelection selection2) {
        PaymentOption paymentOption;
        Intrinsics.checkNotNullParameter((Object)selection2, (String)"selection");
        PaymentSelection paymentSelection = selection2;
        if (Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            int n = R.drawable.stripe_google_pay_mark;
            String string2 = this.resources.getString(R.string.stripe_google_pay);
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            Intrinsics.checkNotNull((Object)string2);
            paymentOption = new PaymentOption(n, string2, null, null, (Function2)kFunction, null, null, 96, null);
        } else if (Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.Link.INSTANCE)) {
            int n = R.drawable.stripe_ic_paymentsheet_link;
            String string3 = this.resources.getString(R.string.stripe_link);
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            Intrinsics.checkNotNull((Object)string3);
            paymentOption = new PaymentOption(n, string3, null, null, (Function2)kFunction, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.Saved) {
            int n = this.getSavedIcon((PaymentSelection.Saved)selection2);
            ResolvableString resolvableString = this.getSavedLabel((PaymentSelection.Saved)selection2);
            String string4 = resolvableString != null ? resolvableString.resolve(this.context) : null;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string5, null, null, (Function2)kFunction, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.New.Card) {
            int n = PaymentMethodsUiExtensionKt.getCardBrandIcon(((PaymentSelection.New.Card)selection2).getBrand());
            ResolvableString resolvableString = PaymentMethodsUiExtensionKt.createCardLabel(((PaymentSelection.New.Card)selection2).getLast4());
            String string6 = resolvableString != null ? resolvableString.resolve(this.context) : null;
            if (string6 == null) {
                string6 = "";
            }
            String string7 = string6;
            resolvableString = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string7, null, null, (Function2)resolvableString, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.New.LinkInline) {
            int n = ((PaymentSelection.New.LinkInline)selection2).getIconResource();
            String string8 = ((PaymentSelection.New.LinkInline)selection2).getLabel();
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string8, null, null, (Function2)kFunction, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.New.GenericPaymentMethod) {
            int n = ((PaymentSelection.New.GenericPaymentMethod)selection2).getIconResource();
            String string9 = ((PaymentSelection.New.GenericPaymentMethod)selection2).getLightThemeIconUrl();
            String string10 = ((PaymentSelection.New.GenericPaymentMethod)selection2).getDarkThemeIconUrl();
            String string11 = ((PaymentSelection.New.GenericPaymentMethod)selection2).getLabel().resolve(this.context);
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string11, string9, string10, (Function2)kFunction, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.New.USBankAccount) {
            int n = ((PaymentSelection.New.USBankAccount)selection2).getIconResource();
            String string12 = ((PaymentSelection.New.USBankAccount)selection2).getLabelResource();
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string12, null, null, (Function2)kFunction, null, null, 96, null);
        } else if (paymentSelection instanceof PaymentSelection.ExternalPaymentMethod) {
            int n = ((PaymentSelection.ExternalPaymentMethod)selection2).getIconResource();
            String string13 = ((PaymentSelection.ExternalPaymentMethod)selection2).getLightThemeIconUrl();
            String string14 = ((PaymentSelection.ExternalPaymentMethod)selection2).getDarkThemeIconUrl();
            String string15 = ((PaymentSelection.ExternalPaymentMethod)selection2).getLabel().resolve(this.context);
            KFunction kFunction = (KFunction)new Function2<PaymentOption, Continuation<? super Drawable>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull PaymentOption p0, @NotNull Continuation<? super Drawable> $completion) {
                    return ((PaymentOptionFactory)this.receiver).loadPaymentOption$paymentsheet_release(p0, $completion);
                }
            };
            paymentOption = new PaymentOption(n, string15, string13, string14, (Function2)kFunction, null, null, 96, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paymentOption;
    }

    private final ResolvableString getSavedLabel(PaymentSelection.Saved selection2) {
        ResolvableString resolvableString = PaymentMethodsUiExtensionKt.getLabel(selection2.getPaymentMethod());
        if (resolvableString == null) {
            PaymentOptionFactory $this$getSavedLabel_u24lambda_u242 = this;
            boolean bl = false;
            PaymentSelection.Saved.WalletType walletType = selection2.getWalletType();
            switch (walletType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
                case 1: {
                    resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_link);
                    break;
                }
                case 2: {
                    resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_google_pay);
                    break;
                }
                default: {
                    resolvableString = null;
                }
            }
        }
        return resolvableString;
    }

    /*
     * WARNING - void declaration
     */
    private final int getSavedIcon(PaymentSelection.Saved selection2) {
        int n;
        int resourceId = PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon$default(selection2.getPaymentMethod(), false, 1, null);
        if (resourceId == R.drawable.stripe_ic_paymentsheet_card_unknown) {
            PaymentSelection.Saved.WalletType walletType = selection2.getWalletType();
            switch (walletType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
                case 1: {
                    n = R.drawable.stripe_ic_paymentsheet_link;
                    break;
                }
                case 2: {
                    n = R.drawable.stripe_google_pay_mark;
                    break;
                }
                default: {
                    n = resourceId;
                    break;
                }
            }
        } else {
            void var2_2;
            n = var2_2;
        }
        return n;
    }

    private static final Drawable loadPaymentOption$loadResource(PaymentOptionFactory this$0, PaymentOption $paymentOption) {
        Object object;
        Object object2 = this$0;
        try {
            PaymentOptionFactory $this$loadPaymentOption_u24loadResource_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)ResourcesCompat.getDrawable((Resources)$this$loadPaymentOption_u24loadResource_u24lambda_u240.resources, (int)$paymentOption.getDrawableResourceId(), null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Drawable drawable2 = (Drawable)(Result.isFailure-impl((Object)object2) ? null : object2);
        return drawable2 == null ? (Drawable)emptyDrawable : drawable2;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object loadPaymentOption$loadIcon(PaymentOptionFactory var0, PaymentOption var1_1, String var2_2, Continuation<? super Drawable> var3_3) {
        if (!(var3_3 instanceof loadPaymentOption.loadIcon.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PaymentOptionFactory.access$loadPaymentOption$loadIcon(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this$0;
                $continuation.L$1 = $paymentOption;
                $continuation.label = 1;
                v0 = this$0.imageLoader.load-gIAlu-s((String)url, (Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                $paymentOption = (PaymentOption)$continuation.L$1;
                this$0 = (PaymentOptionFactory)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl24:
                // 2 sources

                v1 = (Bitmap)(Result.isFailure-impl((Object)(var4_7 = v0)) != false ? null : var4_7);
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-PaymentOptionFactory$loadPaymentOption$loadIcon$2 = false;
                    v2 = (Drawable)new BitmapDrawable(this$0.resources, it);
                } else {
                    v2 = PaymentOptionFactory.loadPaymentOption$loadResource(this$0, $paymentOption);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$loadPaymentOption$loadIcon(PaymentOptionFactory this$0, PaymentOption $paymentOption, String url, Continuation $completion) {
        return PaymentOptionFactory.loadPaymentOption$loadIcon(this$0, $paymentOption, url, (Continuation<? super Drawable>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory$Companion;", "", "()V", "emptyDrawable", "Landroid/graphics/drawable/ShapeDrawable;", "getEmptyDrawable$paymentsheet_release$annotations", "getEmptyDrawable$paymentsheet_release", "()Landroid/graphics/drawable/ShapeDrawable;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShapeDrawable getEmptyDrawable$paymentsheet_release() {
            return emptyDrawable;
        }

        @VisibleForTesting
        public static /* synthetic */ void getEmptyDrawable$paymentsheet_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentSelection.Saved.WalletType.values().length];
            try {
                nArray[PaymentSelection.Saved.WalletType.Link.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentSelection.Saved.WalletType.GooglePay.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

