/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.addresselement;

import androidx.compose.foundation.ScrollKt;
import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.BoxKt;
import androidx.compose.foundation.layout.BoxScope;
import androidx.compose.foundation.layout.BoxScopeInstance;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.ColumnScopeInstance;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.ComposablesKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalMap;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SkippableUpdater;
import androidx.compose.runtime.Updater;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.LayoutKt;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.node.ComposeUiNode;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a5\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0001\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a8\u0006\u0011"}, d2={"ScrollableColumn", "", "modifier", "Landroidx/compose/ui/Modifier;", "content", "Lkotlin/Function1;", "Landroidx/compose/foundation/layout/ColumnScope;", "Landroidx/compose/runtime/Composable;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/ui/Modifier;Lkotlin/jvm/functions/Function3;Landroidx/compose/runtime/Composer;II)V", "editDistance", "", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "otherAddress", "levenshtein", "", "other", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nAddressUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressUtils.kt\ncom/stripe/android/paymentsheet/addresselement/AddressUtilsKt\n+ 2 Box.kt\nandroidx/compose/foundation/layout/BoxKt\n+ 3 Layout.kt\nandroidx/compose/ui/layout/LayoutKt\n+ 4 Composables.kt\nandroidx/compose/runtime/ComposablesKt\n+ 5 Composer.kt\nandroidx/compose/runtime/Updater\n+ 6 Column.kt\nandroidx/compose/foundation/layout/ColumnKt\n*L\n1#1,72:1\n66#2,6:73\n72#2:107\n76#2:152\n78#3,11:79\n78#3,11:114\n91#3:146\n91#3:151\n456#4,8:90\n464#4,3:104\n456#4,8:125\n464#4,3:139\n467#4,3:143\n467#4,3:148\n4144#5,6:98\n4144#5,6:133\n72#6,6:108\n78#6:142\n82#6:147\n*S KotlinDebug\n*F\n+ 1 AddressUtils.kt\ncom/stripe/android/paymentsheet/addresselement/AddressUtilsKt\n*L\n63#1:73,6\n63#1:107\n63#1:152\n63#1:79,11\n66#1:114,11\n66#1:146\n63#1:151\n63#1:90,8\n63#1:104,3\n66#1:125,8\n66#1:139,3\n66#1:143,3\n63#1:148,3\n63#1:98,6\n66#1:133,6\n66#1:108,6\n66#1:142\n66#1:147\n*E\n"})
public final class AddressUtilsKt {
    public static final int levenshtein(@NotNull CharSequence $this$levenshtein, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$levenshtein, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)$this$levenshtein, (Object)other)) {
            return 0;
        }
        if ($this$levenshtein.length() == 0) {
            return other.length();
        }
        if (other.length() == 0) {
            return $this$levenshtein.length();
        }
        int thisLength = $this$levenshtein.length() + 1;
        int otherLength = other.length() + 1;
        int n = 0;
        Integer[] integerArray = new Integer[thisLength];
        while (n < thisLength) {
            int n2 = n++;
            integerArray[n2] = n2;
        }
        Integer[] cost = integerArray;
        int n3 = 0;
        Integer[] integerArray2 = new Integer[thisLength];
        while (n3 < thisLength) {
            int n4 = n3++;
            integerArray2[n4] = 0;
        }
        Integer[] newCost = integerArray2;
        for (int i = 1; i < otherLength; ++i) {
            newCost[0] = i;
            for (int j = 1; j < thisLength; ++j) {
                int match = $this$levenshtein.charAt(j - 1) == other.charAt(i - 1) ? 0 : 1;
                int costReplace = cost[j - 1] + match;
                int costInsert = cost[j] + 1;
                int costDelete = newCost[j - 1] + 1;
                newCost[j] = Math.min(Math.min(costInsert, costDelete), costReplace);
            }
            Integer[] swap = cost;
            cost = newCost;
            newCost = swap;
        }
        return cost[thisLength - 1];
    }

    public static final int editDistance(@NotNull AddressDetails $this$editDistance, @Nullable AddressDetails otherAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$editDistance, (String)"<this>");
        int editDistance = 0;
        AddressDetails addressDetails = otherAddress;
        PaymentSheet.Address comparedAddress = addressDetails != null ? addressDetails.getAddress() : null;
        Object object = $this$editDistance.getAddress();
        if (object == null || (object = ((PaymentSheet.Address)object).getCity()) == null) {
            object = "";
        }
        CharSequence charSequence = (CharSequence)object;
        Object object2 = comparedAddress;
        if (object2 == null || (object2 = ((PaymentSheet.Address)object2).getCity()) == null) {
            object2 = "";
        }
        editDistance += AddressUtilsKt.levenshtein(charSequence, (CharSequence)object2);
        Object object3 = $this$editDistance.getAddress();
        if (object3 == null || (object3 = ((PaymentSheet.Address)object3).getCountry()) == null) {
            object3 = "";
        }
        CharSequence charSequence2 = (CharSequence)object3;
        Object object4 = comparedAddress;
        if (object4 == null || (object4 = ((PaymentSheet.Address)object4).getCountry()) == null) {
            object4 = "";
        }
        editDistance += AddressUtilsKt.levenshtein(charSequence2, (CharSequence)object4);
        Object object5 = $this$editDistance.getAddress();
        if (object5 == null || (object5 = ((PaymentSheet.Address)object5).getLine1()) == null) {
            object5 = "";
        }
        CharSequence charSequence3 = (CharSequence)object5;
        Object object6 = comparedAddress;
        if (object6 == null || (object6 = ((PaymentSheet.Address)object6).getLine1()) == null) {
            object6 = "";
        }
        editDistance += AddressUtilsKt.levenshtein(charSequence3, (CharSequence)object6);
        Object object7 = $this$editDistance.getAddress();
        if (object7 == null || (object7 = ((PaymentSheet.Address)object7).getLine2()) == null) {
            object7 = "";
        }
        CharSequence charSequence4 = (CharSequence)object7;
        Object object8 = comparedAddress;
        if (object8 == null || (object8 = ((PaymentSheet.Address)object8).getLine2()) == null) {
            object8 = "";
        }
        editDistance += AddressUtilsKt.levenshtein(charSequence4, (CharSequence)object8);
        Object object9 = $this$editDistance.getAddress();
        if (object9 == null || (object9 = ((PaymentSheet.Address)object9).getPostalCode()) == null) {
            object9 = "";
        }
        CharSequence charSequence5 = (CharSequence)object9;
        Object object10 = comparedAddress;
        if (object10 == null || (object10 = ((PaymentSheet.Address)object10).getPostalCode()) == null) {
            object10 = "";
        }
        editDistance += AddressUtilsKt.levenshtein(charSequence5, (CharSequence)object10);
        Object object11 = $this$editDistance.getAddress();
        if (object11 == null || (object11 = ((PaymentSheet.Address)object11).getState()) == null) {
            object11 = "";
        }
        CharSequence charSequence6 = (CharSequence)object11;
        Object object12 = comparedAddress;
        if (object12 == null || (object12 = ((PaymentSheet.Address)object12).getState()) == null) {
            object12 = "";
        }
        return editDistance += AddressUtilsKt.levenshtein(charSequence6, (CharSequence)object12);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public static final void ScrollableColumn(@Nullable Modifier modifier2, @NotNull Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit> content, @Nullable Composer $composer, int $changed, int n) {
        block19: {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            $composer = $composer.startRestartGroup(249772746);
            int $dirty = $changed;
            if ((n & 1) != 0) {
                $dirty |= 6;
            } else if (($changed & 0xE) == 0) {
                $dirty |= $composer.changed((Object)modifier2) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x70) == 0) {
                $dirty |= $composer.changedInstance(content) ? 32 : 16;
            }
            if (($dirty & 0x5B) != 18 || !$composer.getSkipping()) {
                void $changed$iv$iv$iv;
                void skippableUpdate$iv$iv$iv;
                void $changed$iv$iv;
                void $changed$iv;
                void $composer2;
                void $changed$iv$iv$iv2;
                void skippableUpdate$iv$iv$iv2;
                void $changed$iv$iv2;
                void modifier$iv;
                void $changed$iv2;
                if ((n & 1) != 0) {
                    modifier2 = (Modifier)Modifier.Companion;
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)249772746, (int)$dirty, (int)-1, (String)"com.stripe.android.paymentsheet.addresselement.ScrollableColumn (AddressUtils.kt:61)");
                }
                Modifier modifier3 = ScrollKt.verticalScroll$default((Modifier)((Modifier)Modifier.Companion), (ScrollState)ScrollKt.rememberScrollState((int)0, (Composer)$composer, (int)0, (int)1), (boolean)false, null, (boolean)false, (int)14, null);
                boolean bl = false;
                boolean $i$f$Box = false;
                $composer.startReplaceableGroup(733328855);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Box)P(2,1,3)69@3214L67,70@3286L130:Box.kt#2w3rfo");
                Alignment contentAlignment$iv = Alignment.Companion.getTopStart();
                boolean propagateMinConstraints$iv = false;
                MeasurePolicy measurePolicy$iv = BoxKt.rememberBoxMeasurePolicy((Alignment)contentAlignment$iv, (boolean)propagateMinConstraints$iv, (Composer)$composer, (int)(0xE & $changed$iv2 >> 3 | 0x70 & $changed$iv2 >> 3));
                int n2 = 0x70 & $changed$iv2 << 3;
                boolean $i$f$Layout = false;
                $composer.startReplaceableGroup(-1323940314);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Layout)P(!1,2)77@3132L23,79@3222L420:Layout.kt#80mrfh");
                int compositeKeyHash$iv$iv = ComposablesKt.getCurrentCompositeKeyHash((Composer)$composer, (int)0);
                CompositionLocalMap localMap$iv$iv = $composer.getCurrentCompositionLocalMap();
                Function0 function0 = ComposeUiNode.Companion.getConstructor();
                Function3 function3 = LayoutKt.modifierMaterializerOf((Modifier)modifier$iv);
                int n3 = 6 | 0x1C00 & $changed$iv$iv2 << 9;
                boolean $i$f$ReusableComposeNode = false;
                if (!($composer.getApplier() instanceof Applier)) {
                    ComposablesKt.invalidApplier();
                }
                $composer.startReusableNode();
                if ($composer.getInserting()) {
                    void factory$iv$iv$iv;
                    $composer.createNode((Function0)factory$iv$iv$iv);
                } else {
                    $composer.useNode();
                }
                Composer $this$Layout_u24lambda_u240$iv$iv = Updater.constructor-impl((Composer)$composer);
                boolean bl2 = false;
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)measurePolicy$iv, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)localMap$iv$iv, (Function2)ComposeUiNode.Companion.getSetResolvedCompositionLocals());
                Function2 block$iv$iv$iv = ComposeUiNode.Companion.getSetCompositeKeyHash();
                boolean bl3 = false;
                Composer $this$set_impl_u24lambda_u240$iv$iv$iv = $this$Layout_u24lambda_u240$iv$iv;
                boolean bl4 = false;
                if ($this$set_impl_u24lambda_u240$iv$iv$iv.getInserting() || !Intrinsics.areEqual((Object)$this$set_impl_u24lambda_u240$iv$iv$iv.rememberedValue(), (Object)compositeKeyHash$iv$iv)) {
                    $this$set_impl_u24lambda_u240$iv$iv$iv.updateRememberedValue((Object)compositeKeyHash$iv$iv);
                    $this$Layout_u24lambda_u240$iv$iv.apply((Object)compositeKeyHash$iv$iv, block$iv$iv$iv);
                }
                skippableUpdate$iv$iv$iv2.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer)), (Object)$composer, (Object)(0x70 & $changed$iv$iv$iv2 >> 3));
                $composer.startReplaceableGroup(2058660585);
                int n4 = 0xE & $changed$iv$iv$iv2 >> 9;
                Composer $composer$iv = $composer;
                boolean bl5 = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)-1253629358, (String)"C71@3331L9:Box.kt#2w3rfo");
                int n5 = 6 | 0x70 & $changed$iv2 >> 6;
                Composer composer = $composer$iv;
                BoxScope $this$ScrollableColumn_u24lambda_u240 = (BoxScope)BoxScopeInstance.INSTANCE;
                boolean bl6 = false;
                int n6 = 0xE & $dirty | 0x1C00 & $dirty << 6;
                boolean $i$f$Column = false;
                $composer2.startReplaceableGroup(-483455358);
                ComposerKt.sourceInformation((Composer)$composer2, (String)"CC(Column)P(2,3,1)75@3779L61,76@3845L133:Column.kt#2w3rfo");
                Arrangement.Vertical verticalArrangement$iv = Arrangement.INSTANCE.getTop();
                Alignment.Horizontal horizontalAlignment$iv = Alignment.Companion.getStart();
                MeasurePolicy measurePolicy$iv2 = ColumnKt.columnMeasurePolicy((Arrangement.Vertical)verticalArrangement$iv, (Alignment.Horizontal)horizontalAlignment$iv, (Composer)$composer2, (int)(0xE & $changed$iv >> 3 | 0x70 & $changed$iv >> 3));
                int n7 = 0x70 & $changed$iv << 3;
                boolean $i$f$Layout2 = false;
                $composer2.startReplaceableGroup(-1323940314);
                ComposerKt.sourceInformation((Composer)$composer2, (String)"CC(Layout)P(!1,2)77@3132L23,79@3222L420:Layout.kt#80mrfh");
                int compositeKeyHash$iv$iv2 = ComposablesKt.getCurrentCompositeKeyHash((Composer)$composer2, (int)0);
                CompositionLocalMap localMap$iv$iv2 = $composer2.getCurrentCompositionLocalMap();
                Function0 function02 = ComposeUiNode.Companion.getConstructor();
                Function3 function32 = LayoutKt.modifierMaterializerOf((Modifier)modifier2);
                int n8 = 6 | 0x1C00 & $changed$iv$iv << 9;
                boolean $i$f$ReusableComposeNode2 = false;
                if (!($composer2.getApplier() instanceof Applier)) {
                    ComposablesKt.invalidApplier();
                }
                $composer2.startReusableNode();
                if ($composer2.getInserting()) {
                    void factory$iv$iv$iv;
                    $composer2.createNode((Function0)factory$iv$iv$iv);
                } else {
                    $composer2.useNode();
                }
                Composer $this$Layout_u24lambda_u240$iv$iv2 = Updater.constructor-impl((Composer)$composer2);
                $i$a$-ReusableComposeNode-LayoutKt$Layout$1$iv$iv = false;
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv2, (Object)measurePolicy$iv2, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv2, (Object)localMap$iv$iv2, (Function2)ComposeUiNode.Companion.getSetResolvedCompositionLocals());
                Function2 block$iv$iv$iv2 = ComposeUiNode.Companion.getSetCompositeKeyHash();
                $i$f$set-impl = false;
                Composer $this$set_impl_u24lambda_u240$iv$iv$iv2 = $this$Layout_u24lambda_u240$iv$iv2;
                $i$a$-with-Updater$set$1$iv$iv$iv = false;
                if ($this$set_impl_u24lambda_u240$iv$iv$iv2.getInserting() || !Intrinsics.areEqual((Object)$this$set_impl_u24lambda_u240$iv$iv$iv2.rememberedValue(), (Object)compositeKeyHash$iv$iv2)) {
                    $this$set_impl_u24lambda_u240$iv$iv$iv2.updateRememberedValue((Object)compositeKeyHash$iv$iv2);
                    $this$Layout_u24lambda_u240$iv$iv2.apply((Object)compositeKeyHash$iv$iv2, block$iv$iv$iv2);
                }
                skippableUpdate$iv$iv$iv.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer2)), (Object)$composer2, (Object)(0x70 & $changed$iv$iv$iv >> 3));
                $composer2.startReplaceableGroup(2058660585);
                int n9 = 0xE & $changed$iv$iv$iv >> 9;
                void $composer$iv2 = $composer2;
                boolean bl7 = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv2, (int)276693570, (String)"C77@3893L9:Column.kt#2w3rfo");
                content.invoke((Object)ColumnScopeInstance.INSTANCE, (Object)$composer$iv2, (Object)(6 | 0x70 & $changed$iv >> 6));
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv2);
                $composer2.endReplaceableGroup();
                $composer2.endNode();
                $composer2.endReplaceableGroup();
                $composer2.endReplaceableGroup();
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                $composer.endReplaceableGroup();
                $composer.endNode();
                $composer.endReplaceableGroup();
                $composer.endReplaceableGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block19;
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(modifier2, content, $changed, n){
                final /* synthetic */ Modifier $modifier;
                final /* synthetic */ Function3<ColumnScope, Composer, Integer, Unit> $content;
                final /* synthetic */ int $$changed;
                final /* synthetic */ int $$default;
                {
                    this.$modifier = $modifier;
                    this.$content = $content;
                    this.$$changed = $$changed;
                    this.$$default = $$default;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    AddressUtilsKt.ScrollableColumn(this.$modifier, this.$content, $composer, RecomposeScopeImplKt.updateChangedFlags((int)(this.$$changed | 1)), this.$$default);
                }
            });
        }
    }
}

