/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.ExternalPaymentMethodConfirmHandler;
import com.stripe.android.paymentsheet.ExternalPaymentMethodInterceptor;
import com.stripe.android.paymentsheet.ExternalPaymentMethodResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0015J\b\u0010\f\u001a\u00020\u0006H\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/ExternalPaymentMethodProxyActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "hasConfirmStarted", "", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "Landroid/content/Intent;", "onResume", "onSaveInstanceState", "outState", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nExternalPaymentMethodProxyActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalPaymentMethodProxyActivity.kt\ncom/stripe/android/paymentsheet/ExternalPaymentMethodProxyActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class ExternalPaymentMethodProxyActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasConfirmStarted;
    public static final int $stable = 8;
    @NotNull
    public static final String EXTRA_EXTERNAL_PAYMENT_METHOD_TYPE = "external_payment_method_type";
    @NotNull
    public static final String EXTRA_BILLING_DETAILS = "external_payment_method_billing_details";
    @NotNull
    public static final String HAS_CONFIRM_STARTED_KEY = "has_confirm_started";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block3: {
            super.onCreate(savedInstanceState);
            Bundle bundle = savedInstanceState;
            if (bundle != null) {
                boolean it = bundle.getBoolean(HAS_CONFIRM_STARTED_KEY);
                boolean bl = false;
                this.hasConfirmStarted = it;
            }
            String type = this.getIntent().getStringExtra(EXTRA_EXTERNAL_PAYMENT_METHOD_TYPE);
            PaymentMethod.BillingDetails billingDetails = (PaymentMethod.BillingDetails)this.getIntent().getParcelableExtra(EXTRA_BILLING_DETAILS);
            if (type == null || this.hasConfirmStarted) break block3;
            this.hasConfirmStarted = true;
            ExternalPaymentMethodConfirmHandler externalPaymentMethodConfirmHandler = ExternalPaymentMethodInterceptor.INSTANCE.getExternalPaymentMethodConfirmHandler();
            if (externalPaymentMethodConfirmHandler != null) {
                PaymentMethod.BillingDetails billingDetails2 = billingDetails;
                if (billingDetails2 == null) {
                    billingDetails2 = new PaymentMethod.BillingDetails(null, null, null, null, 15, null);
                }
                externalPaymentMethodConfirmHandler.confirmExternalPaymentMethod(type, billingDetails2);
            }
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected void onNewIntent(@Nullable Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        block6: {
            super.onResume();
            String type = this.getIntent().getStringExtra(EXTRA_EXTERNAL_PAYMENT_METHOD_TYPE);
            ExternalPaymentMethodResult externalPaymentMethodResult = (ExternalPaymentMethodResult)this.getIntent().getParcelableExtra("external_payment_method_result");
            if (type == null && externalPaymentMethodResult == null) {
                this.finish();
                return;
            }
            ExternalPaymentMethodResult externalPaymentMethodResult2 = externalPaymentMethodResult;
            if (externalPaymentMethodResult2 == null) break block6;
            ExternalPaymentMethodResult it = externalPaymentMethodResult2;
            boolean bl = false;
            ExternalPaymentMethodResult externalPaymentMethodResult3 = it;
            if (externalPaymentMethodResult3 instanceof ExternalPaymentMethodResult.Completed) {
                this.setResult(-1);
            } else if (externalPaymentMethodResult3 instanceof ExternalPaymentMethodResult.Canceled) {
                this.setResult(0);
            } else if (externalPaymentMethodResult3 instanceof ExternalPaymentMethodResult.Failed) {
                Intent intent = new Intent().putExtra("external_payment_method_error_message", ((ExternalPaymentMethodResult.Failed)it).getDisplayMessage());
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
                Intent data = intent;
                this.setResult(1, data);
            }
            this.finish();
        }
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putBoolean(HAS_CONFIRM_STARTED_KEY, this.hasConfirmStarted);
        super.onSaveInstanceState(outState);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/paymentsheet/ExternalPaymentMethodProxyActivity$Companion;", "", "()V", "EXTRA_BILLING_DETAILS", "", "EXTRA_EXTERNAL_PAYMENT_METHOD_TYPE", "HAS_CONFIRM_STARTED_KEY", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

