/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.CustomerStateHolder;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\rR\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "selection", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "(Landroidx/lifecycle/SavedStateHandle;Lkotlinx/coroutines/flow/StateFlow;)V", "customer", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "getCustomer", "()Lkotlinx/coroutines/flow/StateFlow;", "mostRecentlySelectedSavedPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "getMostRecentlySelectedSavedPaymentMethod", "paymentMethods", "", "getPaymentMethods", "setCustomerState", "", "customerState", "updateMostRecentlySelectedSavedPaymentMethod", "paymentMethod", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class CustomerStateHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final StateFlow<PaymentSelection> selection;
    @NotNull
    private final StateFlow<CustomerState> customer;
    @NotNull
    private final StateFlow<List<PaymentMethod>> paymentMethods;
    @NotNull
    private final StateFlow<PaymentMethod> mostRecentlySelectedSavedPaymentMethod;
    public static final int $stable = 8;
    @NotNull
    public static final String SAVED_CUSTOMER = "customer_info";
    @NotNull
    private static final String SAVED_PM_SELECTION = "saved_selection";

    public CustomerStateHolder(@NotNull SavedStateHandle savedStateHandle, @NotNull StateFlow<? extends PaymentSelection> selection2) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        this.savedStateHandle = savedStateHandle;
        this.selection = selection2;
        this.customer = this.savedStateHandle.getStateFlow(SAVED_CUSTOMER, null);
        this.paymentMethods = StateFlowsKt.mapAsStateFlow(this.customer, (Function1)paymentMethods.1.INSTANCE);
        Object object = this.selection.getValue();
        PaymentSelection.Saved saved = object instanceof PaymentSelection.Saved ? (PaymentSelection.Saved)object : null;
        this.mostRecentlySelectedSavedPaymentMethod = this.savedStateHandle.getStateFlow(SAVED_PM_SELECTION, saved != null ? saved.getPaymentMethod() : null);
    }

    @NotNull
    public final StateFlow<CustomerState> getCustomer() {
        return this.customer;
    }

    @NotNull
    public final StateFlow<List<PaymentMethod>> getPaymentMethods() {
        return this.paymentMethods;
    }

    @NotNull
    public final StateFlow<PaymentMethod> getMostRecentlySelectedSavedPaymentMethod() {
        return this.mostRecentlySelectedSavedPaymentMethod;
    }

    public final void setCustomerState(@Nullable CustomerState customerState) {
        this.savedStateHandle.set(SAVED_CUSTOMER, (Object)customerState);
    }

    public final void updateMostRecentlySelectedSavedPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        this.savedStateHandle.set(SAVED_PM_SELECTION, (Object)paymentMethod);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/CustomerStateHolder$Companion;", "", "()V", "SAVED_CUSTOMER", "", "SAVED_PM_SELECTION", "create", "Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "viewModel", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomerStateHolder create(@NotNull BaseSheetViewModel viewModel2) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
            return new CustomerStateHolder(viewModel2.getSavedStateHandle(), viewModel2.getSelection$paymentsheet_release());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

