/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod.definitions;

import androidx.compose.ui.unit.Dp;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.link.ui.inline.LinkSignupMode;
import com.stripe.android.lpmfoundations.FormHeaderInformation;
import com.stripe.android.lpmfoundations.luxe.SaveForFutureUseHelperKt;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.CardDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.CardDefinitionKt;
import com.stripe.android.lpmfoundations.paymentmethod.link.LinkFormElement;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import com.stripe.android.ui.core.elements.CardDetailsSectionElement;
import com.stripe.android.ui.core.elements.MandateTextElement;
import com.stripe.android.ui.core.elements.SaveForFutureUseElement;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory;", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Simple;", "()V", "createCardMandateElement", "Lcom/stripe/android/ui/core/elements/MandateTextElement;", "merchantName", "", "signupMode", "Lcom/stripe/android/link/ui/inline/LinkSignupMode;", "canChangeSaveForFutureUse", "", "createFormElements", "", "Lcom/stripe/android/uicore/elements/FormElement;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "arguments", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Arguments;", "createFormHeaderInformation", "Lcom/stripe/android/lpmfoundations/FormHeaderInformation;", "customerHasSavedPaymentMethods", "createSupportedPaymentMethod", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "saveForFutureUsageIsChangeable", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nCardDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardDefinition.kt\ncom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,233:1\n154#2:234\n154#2:235\n154#2:236\n154#2:237\n*S KotlinDebug\n*F\n+ 1 CardDefinition.kt\ncom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory\n*L\n142#1:234\n143#1:235\n144#1:236\n145#1:237\n*E\n"})
final class CardUiDefinitionFactory
implements UiDefinitionFactory.Simple {
    @NotNull
    public static final CardUiDefinitionFactory INSTANCE = new CardUiDefinitionFactory();

    private CardUiDefinitionFactory() {
    }

    @Override
    @NotNull
    public SupportedPaymentMethod createSupportedPaymentMethod() {
        return new SupportedPaymentMethod(CardDefinition.INSTANCE, null, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, true, null, 34, null);
    }

    @Override
    @NotNull
    public FormHeaderInformation createFormHeaderInformation(boolean customerHasSavedPaymentMethods) {
        int displayName = customerHasSavedPaymentMethods ? R.string.stripe_paymentsheet_add_new_card : R.string.stripe_paymentsheet_add_card;
        return FormHeaderInformation.copy$default(this.createSupportedPaymentMethod().asFormHeaderInformation(), ResolvableStringUtilsKt.getResolvableString((int)displayName), false, 0, null, null, false, 60, null);
    }

    @Override
    @NotNull
    public List<FormElement> createFormElements(@NotNull PaymentMethodMetadata metadata2, @NotNull UiDefinitionFactory.Arguments arguments) {
        LinkSignupMode signupMode;
        LinkSignupMode linkSignupMode;
        boolean canChangeSaveForFutureUsage;
        List list;
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = metadata2.getBillingDetailsCollectionConfiguration();
        List $this$createFormElements_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        FormElement contactInformationElement = CardDefinitionKt.access$contactInformationElement(arguments.getInitialValues(), billingDetailsCollectionConfiguration.getCollectsEmail$paymentsheet_release(), billingDetailsCollectionConfiguration.getCollectsPhone$paymentsheet_release());
        if (contactInformationElement != null) {
            $this$createFormElements_u24lambda_u240.add(contactInformationElement);
        }
        CardAccountRangeRepository.Factory factory = arguments.getCardAccountRangeRepositoryFactory();
        Map<IdentifierSpec, String> map2 = arguments.getInitialValues();
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.Generic("card_details");
        boolean bl2 = billingDetailsCollectionConfiguration.getCollectsName$paymentsheet_release();
        CardBrandChoiceEligibility cardBrandChoiceEligibility = arguments.getCbcEligibility();
        $this$createFormElements_u24lambda_u240.add(new CardDetailsSectionElement(factory, map2, bl2, cardBrandChoiceEligibility, identifierSpec, null, 32, null));
        if (billingDetailsCollectionConfiguration.getAddress() != PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode.Never) {
            $this$createFormElements_u24lambda_u240.add(CardDefinitionKt.access$cardBillingElement(CardDefinitionKt.toInternal(billingDetailsCollectionConfiguration.getAddress()), arguments.getInitialValues(), arguments.getShippingValues()));
        }
        if (canChangeSaveForFutureUsage = INSTANCE.saveForFutureUsageIsChangeable(metadata2)) {
            $this$createFormElements_u24lambda_u240.add(new SaveForFutureUseElement(arguments.getSaveForFutureUseInitialValue(), arguments.getMerchantName()));
        }
        if (metadata2.getLinkInlineConfiguration() != null && arguments.getLinkConfigurationCoordinator() != null) {
            $this$createFormElements_u24lambda_u240.add(new LinkFormElement(metadata2.getLinkInlineConfiguration(), arguments.getLinkConfigurationCoordinator(), arguments.getOnLinkInlineSignupStateChanged()));
            linkSignupMode = metadata2.getLinkInlineConfiguration().getSignupMode();
        } else {
            linkSignupMode = signupMode = null;
        }
        if (metadata2.hasIntentToSetup()) {
            $this$createFormElements_u24lambda_u240.add(INSTANCE.createCardMandateElement(metadata2.getMerchantName(), signupMode, canChangeSaveForFutureUsage));
        }
        return CollectionsKt.build((List)list);
    }

    private final MandateTextElement createCardMandateElement(String merchantName, LinkSignupMode signupMode, boolean canChangeSaveForFutureUse) {
        float f;
        boolean $i$f$getDp;
        int $this$dp$iv;
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.Generic("card_mandate");
        int n = R.string.stripe_paymentsheet_card_mandate;
        if (signupMode == LinkSignupMode.AlongsideSaveForFutureUse) {
            $this$dp$iv = 0;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else if (signupMode == LinkSignupMode.InsteadOfSaveForFutureUse) {
            $this$dp$iv = 4;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else if (canChangeSaveForFutureUse) {
            $this$dp$iv = 6;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else {
            $this$dp$iv = 2;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        }
        float f2 = f;
        List list = CollectionsKt.listOf((Object)merchantName);
        return new MandateTextElement(identifierSpec, n, list, f2, null, 16, null);
    }

    private final boolean saveForFutureUsageIsChangeable(PaymentMethodMetadata metadata2) {
        String string2 = PaymentMethod.Type.Card.code;
        StripeIntent stripeIntent = metadata2.getStripeIntent();
        PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = metadata2.getPaymentMethodSaveConsentBehavior();
        boolean bl = metadata2.getHasCustomerConfiguration();
        return SaveForFutureUseHelperKt.isSaveForFutureUseValueChangeable(string2, paymentMethodSaveConsentBehavior, stripeIntent, bl);
    }

    @Override
    public boolean canBeDisplayedInUi(@NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.canBeDisplayedInUi(this, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public SupportedPaymentMethod supportedPaymentMethod(@NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.supportedPaymentMethod(this, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public FormHeaderInformation formHeaderInformation(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, boolean customerHasSavedPaymentMethods) {
        return UiDefinitionFactory.Simple.DefaultImpls.formHeaderInformation(this, definition, metadata2, sharedDataSpecs, customerHasSavedPaymentMethods);
    }

    @Override
    @Nullable
    public List<FormElement> formElements(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull UiDefinitionFactory.Arguments arguments) {
        return UiDefinitionFactory.Simple.DefaultImpls.formElements(this, definition, metadata2, sharedDataSpecs, arguments);
    }
}

