/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.luxe;

import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"isSaveForFutureUseValueChangeable", "", "code", "", "Lcom/stripe/android/model/PaymentMethodCode;", "paymentMethodSaveConsentBehavior", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "intent", "Lcom/stripe/android/model/StripeIntent;", "hasCustomerConfiguration", "paymentsheet_release"})
public final class SaveForFutureUseHelperKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSaveForFutureUseValueChangeable(@NotNull String code, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @NotNull StripeIntent intent, boolean hasCustomerConfiguration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior2 = paymentMethodSaveConsentBehavior;
        if (paymentMethodSaveConsentBehavior2 instanceof PaymentMethodSaveConsentBehavior.Disabled) {
            return false;
        }
        if (paymentMethodSaveConsentBehavior2 instanceof PaymentMethodSaveConsentBehavior.Enabled) {
            bl = hasCustomerConfiguration;
            return bl;
        } else {
            if (!(paymentMethodSaveConsentBehavior2 instanceof PaymentMethodSaveConsentBehavior.Legacy)) throw new NoWhenBranchMatchedException();
            StripeIntent stripeIntent = intent;
            if (stripeIntent instanceof PaymentIntent) {
                boolean isSetupFutureUsageSet = ((PaymentIntent)intent).isSetupFutureUsageSet(code);
                if (isSetupFutureUsageSet) {
                    return false;
                }
                bl = hasCustomerConfiguration;
                return bl;
            } else {
                if (!(stripeIntent instanceof SetupIntent)) throw new NoWhenBranchMatchedException();
                return false;
            }
        }
    }
}

