/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.ui.core.elements.CardDetailsTextFieldConfig;
import com.stripe.android.ui.core.elements.CardNumberVisualTransformation;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016R\u001c\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\rX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lcom/stripe/android/ui/core/elements/CardNumberConfig;", "Lcom/stripe/android/ui/core/elements/CardDetailsTextFieldConfig;", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "label", "", "getLabel", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "brand", "Lcom/stripe/android/model/CardBrand;", "number", "numberAllowedDigits", "filter", "userTyped", "payments-ui-core_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCardNumberConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberConfig.kt\ncom/stripe/android/ui/core/elements/CardNumberConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,50:1\n429#2:51\n502#2,5:52\n*S KotlinDebug\n*F\n+ 1 CardNumberConfig.kt\ncom/stripe/android/ui/core/elements/CardNumberConfig\n*L\n44#1:51\n44#1:52,5\n*E\n"})
public final class CardNumberConfig
implements CardDetailsTextFieldConfig {
    private final int capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
    @NotNull
    private final String debugLabel;
    private final int label = R.string.stripe_acc_label_card_number;
    private final int keyboard = KeyboardType.Companion.getNumberPassword-PjHm6EE();
    @NotNull
    private final VisualTransformation visualTransformation = new CardNumberVisualTransformation(' ');
    public static final int $stable;

    public CardNumberConfig() {
        this.debugLabel = "Card number";
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @NotNull
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull CardBrand brand, @NotNull String number, int numberAllowedDigits) {
        boolean isDigitLimit;
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        boolean luhnValid = CardUtils.INSTANCE.isValidLuhnNumber(number);
        boolean bl = isDigitLimit = brand.getMaxLengthForCardNumber(number) != -1;
        return StringsKt.isBlank((CharSequence)number) ? (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE : (brand == CardBrand.Unknown ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, true, 2, null) : (isDigitLimit && number.length() < numberAllowedDigits ? (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_invalid_card_number) : (!luhnValid ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, true, 2, null) : (isDigitLimit && number.length() == numberAllowedDigits ? (TextFieldState)TextFieldStateConstants.Valid.Full.INSTANCE : (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, false, 6, null)))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filter$iv = userTyped;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }
}

