/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import androidx.annotation.RestrictTo;
import com.stripe.android.CardUtils;
import com.stripe.android.cards.Bin;
import com.stripe.android.model.CardBrand;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/cards/CardNumber;", "", "()V", "Companion", "Unvalidated", "Validated", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "Lcom/stripe/android/cards/CardNumber$Validated;", "payments-model_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class CardNumber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MIN_PAN_LENGTH = 14;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MAX_PAN_LENGTH = 19;
    public static final int DEFAULT_PAN_LENGTH = 16;
    @NotNull
    private static final Set<Integer> DEFAULT_SPACE_POSITIONS;
    @NotNull
    private static final Map<Integer, Set<Integer>> SPACE_POSITIONS;

    private CardNumber() {
    }

    public /* synthetic */ CardNumber(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Object[] objectArray = new Integer[]{4, 9, 14};
        DEFAULT_SPACE_POSITIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[4];
        Object[] objectArray2 = new Integer[]{4, 11};
        objectArray[0] = TuplesKt.to((Object)14, (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new Integer[]{4, 11};
        objectArray[1] = TuplesKt.to((Object)15, (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new Integer[]{4, 9, 14};
        objectArray[2] = TuplesKt.to((Object)16, (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new Integer[]{4, 9, 14, 19};
        objectArray[3] = TuplesKt.to((Object)19, (Object)SetsKt.setOf((Object[])objectArray2));
        SPACE_POSITIONS = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/cards/CardNumber$Companion;", "", "()V", "DEFAULT_PAN_LENGTH", "", "DEFAULT_SPACE_POSITIONS", "", "MAX_PAN_LENGTH", "MIN_PAN_LENGTH", "SPACE_POSITIONS", "", "getSpacePositions", "panLength", "payments-model_release"})
    public static final class Companion {
        private Companion() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final Set<Integer> getSpacePositions(int panLength) {
            Set set = (Set)SPACE_POSITIONS.get(panLength);
            if (set == null) {
                set = DEFAULT_SPACE_POSITIONS;
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0012\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u000eH\u0007J\t\u0010\u001c\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000eH\u0007J\b\u0010\u001e\u001a\u00020\nH\u0007J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u000eH\u0007R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/stripe/android/cards/CardNumber$Unvalidated;", "Lcom/stripe/android/cards/CardNumber;", "denormalized", "", "(Ljava/lang/String;)V", "bin", "Lcom/stripe/android/cards/Bin;", "getBin", "()Lcom/stripe/android/cards/Bin;", "isMaxLength", "", "()Z", "isValidLuhn", "length", "", "getLength", "()I", "normalized", "getNormalized", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "formatNumber", "panLength", "getFormatted", "hashCode", "isPartialEntry", "isPossibleCardBrand", "toString", "validate", "Lcom/stripe/android/cards/CardNumber$Validated;", "Companion", "payments-model_release"})
    @SourceDebugExtension(value={"SMAP\nCardNumber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumber.kt\ncom/stripe/android/cards/CardNumber$Unvalidated\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n483#2,11:132\n1864#3,3:143\n1627#4,6:146\n5261#4,7:152\n*S KotlinDebug\n*F\n+ 1 CardNumber.kt\ncom/stripe/android/cards/CardNumber$Unvalidated\n*L\n16#1:132,11\n61#1:143,3\n74#1:146,6\n82#1:152,7\n*E\n"})
    public static final class Unvalidated
    extends CardNumber {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final String denormalized;
        @NotNull
        private final String normalized;
        private final int length;
        private final boolean isMaxLength;
        @Nullable
        private final Bin bin;
        private final boolean isValidLuhn;
        @NotNull
        private static final Set<Character> REJECT_CHARS;

        /*
         * WARNING - void declaration
         */
        public Unvalidated(@NotNull String denormalized) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Intrinsics.checkNotNullParameter((Object)denormalized, (String)"denormalized");
            super(null);
            String string = this.denormalized = denormalized;
            Unvalidated unvalidated = this;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl = false;
                if (REJECT_CHARS.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            unvalidated.normalized = string2;
            this.length = this.normalized.length();
            this.isMaxLength = this.length == 19;
            this.bin = Bin.Companion.create(this.normalized);
            this.isValidLuhn = CardUtils.INSTANCE.isValidLuhnNumber(this.normalized);
        }

        @NotNull
        public final String getNormalized() {
            return this.normalized;
        }

        public final int getLength() {
            return this.length;
        }

        public final boolean isMaxLength() {
            return this.isMaxLength;
        }

        @Nullable
        public final Bin getBin() {
            return this.bin;
        }

        public final boolean isValidLuhn() {
            return this.isValidLuhn;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @Nullable
        public final Validated validate(int panLength) {
            return panLength >= 14 && this.normalized.length() == panLength && this.isValidLuhn ? new Validated(this.normalized) : null;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String getFormatted(int panLength) {
            return this.formatNumber(panLength);
        }

        public static /* synthetic */ String getFormatted$default(Unvalidated unvalidated, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            return unvalidated.getFormatted(n);
        }

        /*
         * WARNING - void declaration
         */
        private final String formatNumber(int panLength) {
            void $this$takeWhile$iv;
            int n;
            String[] $this$indexOfFirst$iv;
            String[] $this$forEachIndexed$iv;
            int lastUsedIndex;
            String[] groups;
            String spacelessCardNumber;
            block5: {
                Set<Integer> spacePositions = Companion.getSpacePositions(panLength);
                spacelessCardNumber = StringsKt.take((String)this.normalized, (int)panLength);
                groups = new String[spacePositions.size() + 1];
                int length = spacelessCardNumber.length();
                lastUsedIndex = 0;
                $this$forEachIndexed$iv = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)spacePositions));
                boolean $i$f$forEachIndexed232 = false;
                int index$iv = 0;
                for (Object t : $this$forEachIndexed$iv) {
                    void spacePosition;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n3 = ((Number)t).intValue();
                    int idx = n2;
                    boolean bl = false;
                    void adjustedSpacePosition = spacePosition - idx;
                    if (length <= adjustedSpacePosition) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)spacelessCardNumber.substring(lastUsedIndex, (int)adjustedSpacePosition), (String)"substring(...)");
                    lastUsedIndex = adjustedSpacePosition;
                }
                String[] $i$f$forEachIndexed232 = groups;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                    void it = $this$indexOfFirst$iv[index$iv2];
                    boolean bl = false;
                    if (!(it == null)) continue;
                    n = index$iv2;
                    break block5;
                }
                n = -1;
            }
            $this$indexOfFirst$iv = Integer.valueOf(n);
            int it = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl = false;
            String[] stringArray = $this$forEachIndexed$iv = it != -1 ? $this$indexOfFirst$iv : null;
            if ($this$forEachIndexed$iv != null) {
                it = ((Number)$this$forEachIndexed$iv).intValue();
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)spacelessCardNumber.substring(lastUsedIndex), (String)"substring(...)");
            }
            $this$forEachIndexed$iv = groups;
            boolean $i$f$takeWhile = false;
            ArrayList<void> list$iv = new ArrayList<void>();
            int n4 = ((void)$this$takeWhile$iv).length;
            for (int i = 0; i < n4; ++i) {
                void item$iv;
                void it2 = item$iv = $this$takeWhile$iv[i];
                boolean bl3 = false;
                if (!(it2 != null)) break;
                list$iv.add(item$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isPartialEntry(int panLength) {
            return this.normalized.length() != panLength && !StringsKt.isBlank((CharSequence)this.normalized);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isPossibleCardBrand() {
            return !StringsKt.isBlank((CharSequence)this.normalized) && CollectionsKt.first(CardBrand.Companion.getCardBrands(this.normalized)) != CardBrand.Unknown;
        }

        private final String component1() {
            return this.denormalized;
        }

        @NotNull
        public final Unvalidated copy(@NotNull String denormalized) {
            Intrinsics.checkNotNullParameter((Object)denormalized, (String)"denormalized");
            return new Unvalidated(denormalized);
        }

        public static /* synthetic */ Unvalidated copy$default(Unvalidated unvalidated, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = unvalidated.denormalized;
            }
            return unvalidated.copy(string);
        }

        @NotNull
        public String toString() {
            return "Unvalidated(denormalized=" + this.denormalized + ")";
        }

        public int hashCode() {
            return this.denormalized.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unvalidated)) {
                return false;
            }
            Unvalidated unvalidated = (Unvalidated)other;
            return Intrinsics.areEqual((Object)this.denormalized, (Object)unvalidated.denormalized);
        }

        static {
            Object[] objectArray = new Character[]{Character.valueOf('-'), Character.valueOf(' ')};
            REJECT_CHARS = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/cards/CardNumber$Unvalidated$Companion;", "", "()V", "REJECT_CHARS", "", "", "payments-model_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/cards/CardNumber$Validated;", "Lcom/stripe/android/cards/CardNumber;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "payments-model_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Validated
    extends CardNumber {
        @NotNull
        private final String value;

        public Validated(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final Validated copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Validated(value);
        }

        public static /* synthetic */ Validated copy$default(Validated validated, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = validated.value;
            }
            return validated.copy(string);
        }

        @NotNull
        public String toString() {
            return "Validated(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Validated)) {
                return false;
            }
            Validated validated = (Validated)other;
            return Intrinsics.areEqual((Object)this.value, (Object)validated.value);
        }
    }
}

