/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.stripe.android.R;
import com.stripe.android.view.StripeColorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0019J$\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u001b\u001a\u00020\t2\b\b\u0001\u0010\u001c\u001a\u00020\tH\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/ThemeConfig;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "colorUtils", "Lcom/stripe/android/view/StripeColorUtils;", "selectedColorInt", "", "unselectedColorInt", "unselectedTextColorInt", "selectedTextAlphaColorInt", "unselectedTextAlphaColorInt", "textColorValues", "", "getTextColorValues$payments_core_release", "()[I", "getTintColor", "isSelected", "", "getTintColor$payments_core_release", "getTextColor", "getTextColor$payments_core_release", "getTextAlphaColor", "getTextAlphaColor$payments_core_release", "determineColor", "defaultColor", "colorIfTransparent", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class ThemeConfig {
    @NotNull
    private final StripeColorUtils colorUtils;
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedColorInt;
    @ColorInt
    private final int unselectedTextColorInt;
    @ColorInt
    private final int selectedTextAlphaColorInt;
    @ColorInt
    private final int unselectedTextAlphaColorInt;
    @NotNull
    private final int[] textColorValues;
    public static final int $stable = 8;

    public ThemeConfig(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.colorUtils = new StripeColorUtils(context);
        this.selectedColorInt = this.determineColor(context, this.colorUtils.getColorAccent(), R.color.stripe_accent_color_default);
        this.unselectedColorInt = this.determineColor(context, this.colorUtils.getColorControlNormal(), R.color.stripe_control_normal_color_default);
        this.unselectedTextColorInt = this.determineColor(context, this.colorUtils.getTextColorSecondary(), R.color.stripe_color_text_secondary_default);
        this.selectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.selectedColorInt, (int)context.getResources().getInteger(R.integer.stripe_light_text_alpha_hex));
        this.unselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.unselectedTextColorInt, (int)context.getResources().getInteger(R.integer.stripe_light_text_alpha_hex));
        int[] nArray = new int[]{this.selectedColorInt, this.selectedTextAlphaColorInt, this.unselectedTextColorInt, this.unselectedTextAlphaColorInt};
        this.textColorValues = nArray;
    }

    @NotNull
    public final int[] getTextColorValues$payments_core_release() {
        return this.textColorValues;
    }

    @ColorInt
    public final int getTintColor$payments_core_release(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedColorInt;
    }

    @ColorInt
    public final int getTextColor$payments_core_release(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedTextColorInt;
    }

    @ColorInt
    public final int getTextAlphaColor$payments_core_release(boolean isSelected) {
        return isSelected ? this.selectedTextAlphaColorInt : this.unselectedTextAlphaColorInt;
    }

    @ColorInt
    private final int determineColor(Context context, @ColorInt int defaultColor, @ColorRes int colorIfTransparent) {
        return StripeColorUtils.Companion.isColorTransparent(defaultColor) ? ContextCompat.getColor((Context)context, (int)colorIfTransparent) : defaultColor;
    }
}

