/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0007H\u0002J&\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/StripeColorUtils;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "colorAccent", "", "getColorAccent", "()I", "colorControlNormal", "getColorControlNormal", "textColorPrimary", "getTextColorPrimary", "textColorSecondary", "getTextColorSecondary", "colorPrimary", "getColorPrimary", "getTypedValue", "Landroid/util/TypedValue;", "idRes", "getTintedIconWithAttribute", "Landroid/graphics/drawable/Drawable;", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "attributeResource", "iconResourceId", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class StripeColorUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final int colorAccent;
    private final int colorControlNormal;
    private final int textColorPrimary;
    private final int textColorSecondary;
    private final int colorPrimary;
    public static final int $stable = 8;

    public StripeColorUtils(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.colorAccent = this.getTypedValue((int)16843829).data;
        this.colorControlNormal = this.getTypedValue((int)16843817).data;
        this.textColorPrimary = this.getTypedValue((int)16842806).data;
        this.textColorSecondary = this.getTypedValue((int)16842808).data;
        this.colorPrimary = this.getTypedValue((int)16843827).data;
    }

    public final int getColorAccent() {
        return this.colorAccent;
    }

    public final int getColorControlNormal() {
        return this.colorControlNormal;
    }

    public final int getTextColorPrimary() {
        return this.textColorPrimary;
    }

    public final int getTextColorSecondary() {
        return this.textColorSecondary;
    }

    public final int getColorPrimary() {
        return this.colorPrimary;
    }

    private final TypedValue getTypedValue(@AttrRes int idRes) {
        TypedValue typedValue;
        TypedValue it = typedValue = new TypedValue();
        boolean bl = false;
        this.context.getTheme().resolveAttribute(idRes, it, true);
        return typedValue;
    }

    @NotNull
    public final Drawable getTintedIconWithAttribute(@NotNull Resources.Theme theme, @AttrRes int attributeResource, @DrawableRes int iconResourceId) {
        Drawable icon;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attributeResource, typedValue, true);
        int color2 = typedValue.data;
        Drawable drawable2 = icon = ContextCompat.getDrawable((Context)this.context, (int)iconResourceId);
        Intrinsics.checkNotNull((Object)drawable2);
        Drawable drawable3 = DrawableCompat.wrap((Drawable)drawable2);
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"wrap(...)");
        Drawable compatIcon = drawable3;
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)color2);
        return compatIcon;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/StripeColorUtils$Companion;", "", "<init>", "()V", "isColorTransparent", "", "color", "", "isColorDark", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isColorTransparent(@ColorInt int color2) {
            return Color.alpha((int)color2) < 16;
        }

        public final boolean isColorDark(@ColorInt int color2) {
            double luminescence = 0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2);
            double luminescencePercentage = luminescence / (double)255;
            return luminescencePercentage <= 0.5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

