/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewStub;
import android.widget.ProgressBar;
import androidx.appcompat.R;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.progressindicator.LinearProgressIndicator;
import com.stripe.android.R;
import com.stripe.android.databinding.StripeActivityBinding;
import com.stripe.android.view.AlertDisplayer;
import com.stripe.android.view.StripeColorUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010/\u001a\u00020%H$J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u0015H\u0014J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204H\u0004R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\t\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\t\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lcom/stripe/android/view/StripeActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "viewBinding", "Lcom/stripe/android/databinding/StripeActivityBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/StripeActivityBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "progressBar", "Landroid/widget/ProgressBar;", "getProgressBar$payments_core_release", "()Landroid/widget/ProgressBar;", "progressBar$delegate", "viewStub", "Landroid/view/ViewStub;", "getViewStub$payments_core_release", "()Landroid/view/ViewStub;", "viewStub$delegate", "value", "", "isProgressBarVisible", "()Z", "setProgressBarVisible", "(Z)V", "alertDisplayer", "Lcom/stripe/android/view/AlertDisplayer;", "getAlertDisplayer", "()Lcom/stripe/android/view/AlertDisplayer;", "alertDisplayer$delegate", "stripeColorUtils", "Lcom/stripe/android/view/StripeColorUtils;", "getStripeColorUtils", "()Lcom/stripe/android/view/StripeColorUtils;", "stripeColorUtils$delegate", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPrepareOptionsMenu", "onActionSave", "onProgressBarVisibilityChanged", "visible", "showError", "error", "", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStripeActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeActivity.kt\ncom/stripe/android/view/StripeActivity\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,96:1\n256#2,2:97\n*S KotlinDebug\n*F\n+ 1 StripeActivity.kt\ncom/stripe/android/view/StripeActivity\n*L\n32#1:97,2\n*E\n"})
public abstract class StripeActivity
extends AppCompatActivity {
    @NotNull
    private final Lazy viewBinding$delegate = LazyKt.lazy(() -> StripeActivity.viewBinding_delegate$lambda$0(this));
    @NotNull
    private final Lazy progressBar$delegate = LazyKt.lazy(() -> StripeActivity.progressBar_delegate$lambda$1(this));
    @NotNull
    private final Lazy viewStub$delegate = LazyKt.lazy(() -> StripeActivity.viewStub_delegate$lambda$2(this));
    private boolean isProgressBarVisible;
    @NotNull
    private final Lazy alertDisplayer$delegate = LazyKt.lazy(() -> StripeActivity.alertDisplayer_delegate$lambda$3(this));
    @NotNull
    private final Lazy stripeColorUtils$delegate = LazyKt.lazy(() -> StripeActivity.stripeColorUtils_delegate$lambda$4(this));
    public static final int $stable = 8;

    private final StripeActivityBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        return (StripeActivityBinding)lazy.getValue();
    }

    @NotNull
    public final ProgressBar getProgressBar$payments_core_release() {
        Lazy lazy = this.progressBar$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ProgressBar)object;
    }

    @NotNull
    public final ViewStub getViewStub$payments_core_release() {
        Lazy lazy = this.viewStub$delegate;
        return (ViewStub)lazy.getValue();
    }

    protected final boolean isProgressBarVisible() {
        return this.isProgressBarVisible;
    }

    protected final void setProgressBarVisible(boolean value) {
        View $this$isVisible$iv = (View)this.getProgressBar$payments_core_release();
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value ? 0 : 8);
        this.invalidateOptionsMenu();
        this.onProgressBarVisibilityChanged(value);
        this.isProgressBarVisible = value;
    }

    private final AlertDisplayer getAlertDisplayer() {
        Lazy lazy = this.alertDisplayer$delegate;
        return (AlertDisplayer)lazy.getValue();
    }

    private final StripeColorUtils getStripeColorUtils() {
        Lazy lazy = this.stripeColorUtils$delegate;
        return (StripeColorUtils)lazy.getValue();
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block0: {
            super.onCreate(savedInstanceState);
            this.setContentView((View)this.getViewBinding().getRoot());
            this.setSupportActionBar(this.getViewBinding().toolbar);
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar == null) break block0;
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.stripe_add_payment_method, menu2);
        menu2.findItem(R.id.action_save).setEnabled(!this.isProgressBarVisible);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getItemId() == R.id.action_save) {
            this.onActionSave();
            bl = true;
        } else {
            void var2_2;
            boolean handled = super.onOptionsItemSelected(item);
            if (!handled) {
                this.getOnBackPressedDispatcher().onBackPressed();
            }
            bl = var2_2;
        }
        return bl;
    }

    public boolean onPrepareOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        StripeColorUtils stripeColorUtils = this.getStripeColorUtils();
        Resources.Theme theme = this.getTheme();
        Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"getTheme(...)");
        Drawable tintedIcon = stripeColorUtils.getTintedIconWithAttribute(theme, R.attr.titleTextColor, R.drawable.stripe_ic_checkmark);
        saveItem.setIcon(tintedIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    protected abstract void onActionSave();

    protected void onProgressBarVisibilityChanged(boolean visible) {
    }

    protected final void showError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.getAlertDisplayer().show(error);
    }

    private static final StripeActivityBinding viewBinding_delegate$lambda$0(StripeActivity this$0) {
        StripeActivityBinding stripeActivityBinding = StripeActivityBinding.inflate(this$0.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)stripeActivityBinding, (String)"inflate(...)");
        return stripeActivityBinding;
    }

    private static final LinearProgressIndicator progressBar_delegate$lambda$1(StripeActivity this$0) {
        return this$0.getViewBinding().progressBar;
    }

    private static final ViewStub viewStub_delegate$lambda$2(StripeActivity this$0) {
        ViewStub viewStub = this$0.getViewBinding().viewStub;
        Intrinsics.checkNotNullExpressionValue((Object)viewStub, (String)"viewStub");
        return viewStub;
    }

    private static final AlertDisplayer.DefaultAlertDisplayer alertDisplayer_delegate$lambda$3(StripeActivity this$0) {
        return new AlertDisplayer.DefaultAlertDisplayer((Activity)this$0);
    }

    private static final StripeColorUtils stripeColorUtils_delegate$lambda$4(StripeActivity this$0) {
        return new StripeColorUtils((Context)this$0);
    }
}

