/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.injection;

import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideUIContextFactory;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.ApiRequest_Options_Factory;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.core.authentication.PaymentNextActionHandlerRegistry;
import com.stripe.android.payments.core.injection.PaymentLauncherModule;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideDefaultReturnUrlFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideIsInstantAppFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvidePaymentNextActionHandlerRegistryFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelFactoryComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import dagger.Lazy;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.util.Map;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerPaymentLauncherViewModelFactoryComponent {
    private DaggerPaymentLauncherViewModelFactoryComponent() {
    }

    public static PaymentLauncherViewModelFactoryComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements PaymentLauncherViewModelFactoryComponent.Builder {
        private Context context;
        private Boolean enableLogging;
        private Function0<String> publishableKeyProvider;
        private Function0<String> stripeAccountIdProvider;
        private Set<String> productUsage;
        private Boolean includePaymentSheetNextHandlers;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder enableLogging(boolean enableLogging) {
            this.enableLogging = (Boolean)Preconditions.checkNotNull((Object)enableLogging);
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder stripeAccountIdProvider(Function0<String> stripeAccountIdProvider) {
            this.stripeAccountIdProvider = (Function0)Preconditions.checkNotNull(stripeAccountIdProvider);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public Builder includePaymentSheetNextHandlers(boolean includePaymentSheetNextHandlers) {
            this.includePaymentSheetNextHandlers = (Boolean)Preconditions.checkNotNull((Object)includePaymentSheetNextHandlers);
            return this;
        }

        @Override
        public PaymentLauncherViewModelFactoryComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.enableLogging, Boolean.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.stripeAccountIdProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            Preconditions.checkBuilderRequirement((Object)this.includePaymentSheetNextHandlers, Boolean.class);
            return new PaymentLauncherViewModelFactoryComponentImpl(new PaymentLauncherModule(), new CoroutineContextModule(), new CoreCommonModule(), this.context, this.enableLogging, this.publishableKeyProvider, this.stripeAccountIdProvider, this.productUsage, this.includePaymentSheetNextHandlers);
        }
    }

    private static final class PaymentLauncherViewModelFactoryComponentImpl
    implements PaymentLauncherViewModelFactoryComponent {
        private final Context context;
        private final Function0<String> publishableKeyProvider;
        private final Set<String> productUsage;
        private final PaymentLauncherModule paymentLauncherModule;
        private final PaymentLauncherViewModelFactoryComponentImpl paymentLauncherViewModelFactoryComponentImpl = this;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<Boolean> enableLoggingProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<Context> contextProvider;
        private Provider<CoroutineContext> provideUIContextProvider;
        private Provider<Map<String, String>> provideThreeDs1IntentReturnUrlMapProvider;
        private Provider<Function0<String>> publishableKeyProvider2;
        private Provider<Set<String>> productUsageProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<Boolean> provideIsInstantAppProvider;
        private Provider<Boolean> includePaymentSheetNextHandlersProvider;
        private Provider<PaymentNextActionHandlerRegistry> providePaymentNextActionHandlerRegistryProvider;
        private Provider<DefaultReturnUrl> provideDefaultReturnUrlProvider;
        private Provider<Function0<String>> stripeAccountIdProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<PaymentIntentFlowResultProcessor> paymentIntentFlowResultProcessorProvider;
        private Provider<SetupIntentFlowResultProcessor> setupIntentFlowResultProcessorProvider;

        private PaymentLauncherViewModelFactoryComponentImpl(PaymentLauncherModule paymentLauncherModuleParam, CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam, Boolean includePaymentSheetNextHandlersParam) {
            this.context = contextParam;
            this.publishableKeyProvider = publishableKeyProviderParam;
            this.productUsage = productUsageParam;
            this.paymentLauncherModule = paymentLauncherModuleParam;
            this.initialize(paymentLauncherModuleParam, coroutineContextModuleParam, coreCommonModuleParam, contextParam, enableLoggingParam, publishableKeyProviderParam, stripeAccountIdProviderParam, productUsageParam, includePaymentSheetNextHandlersParam);
        }

        private PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory() {
            return new PaymentAnalyticsRequestFactory(this.context, this.publishableKeyProvider, this.productUsage);
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private StripeApiRepository stripeApiRepository() {
            return new StripeApiRepository(this.context, this.publishableKeyProvider, (CoroutineContext)this.provideWorkContextProvider.get(), this.productUsage, this.paymentAnalyticsRequestFactory(), (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
        }

        private boolean namedBoolean() {
            return this.paymentLauncherModule.provideIsInstantApp(this.context);
        }

        private void initialize(PaymentLauncherModule paymentLauncherModuleParam, CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam, Boolean includePaymentSheetNextHandlersParam) {
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.enableLoggingProvider = InstanceFactory.create((Object)enableLoggingParam);
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, this.enableLoggingProvider));
            this.contextProvider = InstanceFactory.create((Object)contextParam);
            this.provideUIContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideUIContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.provideThreeDs1IntentReturnUrlMapProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory.create(paymentLauncherModuleParam));
            this.publishableKeyProvider2 = InstanceFactory.create(publishableKeyProviderParam);
            this.productUsageProvider = InstanceFactory.create(productUsageParam);
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.productUsageProvider);
            this.provideIsInstantAppProvider = PaymentLauncherModule_ProvideIsInstantAppFactory.create(paymentLauncherModuleParam, this.contextProvider);
            this.includePaymentSheetNextHandlersProvider = InstanceFactory.create((Object)includePaymentSheetNextHandlersParam);
            this.providePaymentNextActionHandlerRegistryProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvidePaymentNextActionHandlerRegistryFactory.create(paymentLauncherModuleParam, this.contextProvider, this.enableLoggingProvider, this.provideWorkContextProvider, this.provideUIContextProvider, this.provideThreeDs1IntentReturnUrlMapProvider, this.paymentAnalyticsRequestFactoryProvider, this.publishableKeyProvider2, this.productUsageProvider, this.provideIsInstantAppProvider, this.includePaymentSheetNextHandlersProvider));
            this.provideDefaultReturnUrlProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideDefaultReturnUrlFactory.create(paymentLauncherModuleParam, this.contextProvider));
            this.stripeAccountIdProvider = InstanceFactory.create(stripeAccountIdProviderParam);
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.provideWorkContextProvider, this.productUsageProvider, this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.paymentIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)PaymentIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.stripeApiRepositoryProvider, this.provideLoggerProvider, this.provideWorkContextProvider));
            this.setupIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)SetupIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.stripeApiRepositoryProvider, this.provideLoggerProvider, this.provideWorkContextProvider));
        }

        @Override
        public PaymentLauncherViewModelSubcomponent.Builder getViewModelSubcomponentBuilder() {
            return new PaymentLauncherViewModelSubcomponentBuilder(this.paymentLauncherViewModelFactoryComponentImpl);
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentImpl
    implements PaymentLauncherViewModelSubcomponent {
        private final Boolean isPaymentIntent;
        private final SavedStateHandle savedStateHandle;
        private final PaymentLauncherViewModelFactoryComponentImpl paymentLauncherViewModelFactoryComponentImpl;
        private final PaymentLauncherViewModelSubcomponentImpl paymentLauncherViewModelSubcomponentImpl = this;
        private Provider<ApiRequest.Options> optionsProvider;

        private PaymentLauncherViewModelSubcomponentImpl(PaymentLauncherViewModelFactoryComponentImpl paymentLauncherViewModelFactoryComponentImpl, Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam) {
            this.paymentLauncherViewModelFactoryComponentImpl = paymentLauncherViewModelFactoryComponentImpl;
            this.isPaymentIntent = isPaymentIntentParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(isPaymentIntentParam, savedStateHandleParam);
        }

        private void initialize(Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam) {
            this.optionsProvider = ApiRequest_Options_Factory.create(this.paymentLauncherViewModelFactoryComponentImpl.publishableKeyProvider2, this.paymentLauncherViewModelFactoryComponentImpl.stripeAccountIdProvider);
        }

        @Override
        public PaymentLauncherViewModel getViewModel() {
            return new PaymentLauncherViewModel(this.isPaymentIntent, this.paymentLauncherViewModelFactoryComponentImpl.stripeApiRepository(), (PaymentNextActionHandlerRegistry)this.paymentLauncherViewModelFactoryComponentImpl.providePaymentNextActionHandlerRegistryProvider.get(), (DefaultReturnUrl)this.paymentLauncherViewModelFactoryComponentImpl.provideDefaultReturnUrlProvider.get(), (javax.inject.Provider<ApiRequest.Options>)this.optionsProvider, (Map)this.paymentLauncherViewModelFactoryComponentImpl.provideThreeDs1IntentReturnUrlMapProvider.get(), (Lazy<PaymentIntentFlowResultProcessor>)DoubleCheck.lazy(this.paymentLauncherViewModelFactoryComponentImpl.paymentIntentFlowResultProcessorProvider), (Lazy<SetupIntentFlowResultProcessor>)DoubleCheck.lazy(this.paymentLauncherViewModelFactoryComponentImpl.setupIntentFlowResultProcessorProvider), (AnalyticsRequestExecutor)this.paymentLauncherViewModelFactoryComponentImpl.defaultAnalyticsRequestExecutor(), this.paymentLauncherViewModelFactoryComponentImpl.paymentAnalyticsRequestFactory(), (CoroutineContext)this.paymentLauncherViewModelFactoryComponentImpl.provideUIContextProvider.get(), this.savedStateHandle, this.paymentLauncherViewModelFactoryComponentImpl.namedBoolean());
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentBuilder
    implements PaymentLauncherViewModelSubcomponent.Builder {
        private final PaymentLauncherViewModelFactoryComponentImpl paymentLauncherViewModelFactoryComponentImpl;
        private Boolean isPaymentIntent;
        private SavedStateHandle savedStateHandle;

        private PaymentLauncherViewModelSubcomponentBuilder(PaymentLauncherViewModelFactoryComponentImpl paymentLauncherViewModelFactoryComponentImpl) {
            this.paymentLauncherViewModelFactoryComponentImpl = paymentLauncherViewModelFactoryComponentImpl;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder isPaymentIntent(boolean isPaymentIntent) {
            this.isPaymentIntent = (Boolean)Preconditions.checkNotNull((Object)isPaymentIntent);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.isPaymentIntent, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            return new PaymentLauncherViewModelSubcomponentImpl(this.paymentLauncherViewModelFactoryComponentImpl, this.isPaymentIntent, this.savedStateHandle);
        }
    }
}

