/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication.threeds2;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionActivity;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "<init>", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class Stripe3ds2TransactionContract
extends ActivityResultContract<Args, PaymentFlowResult.Unvalidated> {
    public static final int $stable;

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent intent = new Intent(context, Stripe3ds2TransactionActivity.class).putExtras(input.toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtras(...)");
        return intent;
    }

    @NotNull
    public PaymentFlowResult.Unvalidated parseResult(int resultCode, @Nullable Intent intent) {
        return PaymentFlowResult.Unvalidated.Companion.fromIntent(intent);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 E2\u00020\u0001:\u0001EBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010-\u001a\u00020.J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\u000bH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\u0010\u00105\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010#J\t\u00106\u001a\u00020\u0011H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u00c6\u0003Jp\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u00c6\u0001\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u000fJ\u0013\u0010;\u001a\u00020\r2\b\u0010<\u001a\u0004\u0018\u00010=H\u00d6\u0003J\t\u0010>\u001a\u00020\u000fH\u00d6\u0001J\t\u0010?\u001a\u00020\u0011H\u00d6\u0001J\u0016\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006F"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "Landroid/os/Parcelable;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "config", "Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "enableLogging", "", "statusBarColor", "", "publishableKey", "", "productUsage", "", "<init>", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;Lcom/stripe/android/core/networking/ApiRequest$Options;ZLjava/lang/Integer;Ljava/lang/String;Ljava/util/Set;)V", "getSdkTransactionId", "()Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "getConfig", "()Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;", "getStripeIntent", "()Lcom/stripe/android/model/StripeIntent;", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "getRequestOptions", "()Lcom/stripe/android/core/networking/ApiRequest$Options;", "getEnableLogging", "()Z", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPublishableKey", "()Ljava/lang/String;", "getProductUsage", "()Ljava/util/Set;", "fingerprint", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "getFingerprint", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "toBundle", "Landroid/os/Bundle;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;Lcom/stripe/android/core/networking/ApiRequest$Options;ZLjava/lang/Integer;Ljava/lang/String;Ljava/util/Set;)Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "describeContents", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Args
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SdkTransactionId sdkTransactionId;
        @NotNull
        private final PaymentAuthConfig.Stripe3ds2Config config;
        @NotNull
        private final StripeIntent stripeIntent;
        @NotNull
        private final StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData;
        @NotNull
        private final ApiRequest.Options requestOptions;
        private final boolean enableLogging;
        @Nullable
        private final Integer statusBarColor;
        @NotNull
        private final String publishableKey;
        @NotNull
        private final Set<String> productUsage;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;
        public static final int $stable;
        @NotNull
        private static final String EXTRA_ARGS = "extra_args";

        public Args(@NotNull SdkTransactionId sdkTransactionId, @NotNull PaymentAuthConfig.Stripe3ds2Config config2, @NotNull StripeIntent stripeIntent, @NotNull StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData, @NotNull ApiRequest.Options requestOptions, boolean enableLogging, @Nullable Integer statusBarColor, @NotNull String publishableKey, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            this.sdkTransactionId = sdkTransactionId;
            this.config = config2;
            this.stripeIntent = stripeIntent;
            this.nextActionData = nextActionData;
            this.requestOptions = requestOptions;
            this.enableLogging = enableLogging;
            this.statusBarColor = statusBarColor;
            this.publishableKey = publishableKey;
            this.productUsage = productUsage;
        }

        @NotNull
        public final SdkTransactionId getSdkTransactionId() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final PaymentAuthConfig.Stripe3ds2Config getConfig() {
            return this.config;
        }

        @NotNull
        public final StripeIntent getStripeIntent() {
            return this.stripeIntent;
        }

        @NotNull
        public final StripeIntent.NextActionData.SdkData.Use3DS2 getNextActionData() {
            return this.nextActionData;
        }

        @NotNull
        public final ApiRequest.Options getRequestOptions() {
            return this.requestOptions;
        }

        public final boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        @NotNull
        public final String getPublishableKey() {
            return this.publishableKey;
        }

        @NotNull
        public final Set<String> getProductUsage() {
            return this.productUsage;
        }

        @NotNull
        public final Stripe3ds2Fingerprint getFingerprint() {
            return new Stripe3ds2Fingerprint(this.nextActionData);
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable((Parcelable)this.sdkTransactionId, flags);
            this.config.writeToParcel(dest, flags);
            dest.writeParcelable((Parcelable)this.stripeIntent, flags);
            this.nextActionData.writeToParcel(dest, flags);
            dest.writeParcelable((Parcelable)this.requestOptions, flags);
            dest.writeInt(this.enableLogging ? 1 : 0);
            Object object = this.statusBarColor;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeInt(((Integer)object).intValue());
            }
            dest.writeString(this.publishableKey);
            object = this.productUsage;
            dest.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                dest.writeString((String)iterator.next());
            }
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final SdkTransactionId component1() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final PaymentAuthConfig.Stripe3ds2Config component2() {
            return this.config;
        }

        @NotNull
        public final StripeIntent component3() {
            return this.stripeIntent;
        }

        @NotNull
        public final StripeIntent.NextActionData.SdkData.Use3DS2 component4() {
            return this.nextActionData;
        }

        @NotNull
        public final ApiRequest.Options component5() {
            return this.requestOptions;
        }

        public final boolean component6() {
            return this.enableLogging;
        }

        @Nullable
        public final Integer component7() {
            return this.statusBarColor;
        }

        @NotNull
        public final String component8() {
            return this.publishableKey;
        }

        @NotNull
        public final Set<String> component9() {
            return this.productUsage;
        }

        @NotNull
        public final Args copy(@NotNull SdkTransactionId sdkTransactionId, @NotNull PaymentAuthConfig.Stripe3ds2Config config2, @NotNull StripeIntent stripeIntent, @NotNull StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData, @NotNull ApiRequest.Options requestOptions, boolean enableLogging, @Nullable Integer statusBarColor, @NotNull String publishableKey, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            return new Args(sdkTransactionId, config2, stripeIntent, nextActionData, requestOptions, enableLogging, statusBarColor, publishableKey, productUsage);
        }

        public static /* synthetic */ Args copy$default(Args args, SdkTransactionId sdkTransactionId, PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config, StripeIntent stripeIntent, StripeIntent.NextActionData.SdkData.Use3DS2 use3DS2, ApiRequest.Options options, boolean bl, Integer n, String string2, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                sdkTransactionId = args.sdkTransactionId;
            }
            if ((n2 & 2) != 0) {
                stripe3ds2Config = args.config;
            }
            if ((n2 & 4) != 0) {
                stripeIntent = args.stripeIntent;
            }
            if ((n2 & 8) != 0) {
                use3DS2 = args.nextActionData;
            }
            if ((n2 & 0x10) != 0) {
                options = args.requestOptions;
            }
            if ((n2 & 0x20) != 0) {
                bl = args.enableLogging;
            }
            if ((n2 & 0x40) != 0) {
                n = args.statusBarColor;
            }
            if ((n2 & 0x80) != 0) {
                string2 = args.publishableKey;
            }
            if ((n2 & 0x100) != 0) {
                set = args.productUsage;
            }
            return args.copy(sdkTransactionId, stripe3ds2Config, stripeIntent, use3DS2, options, bl, n, string2, set);
        }

        @NotNull
        public String toString() {
            return "Args(sdkTransactionId=" + this.sdkTransactionId + ", config=" + this.config + ", stripeIntent=" + this.stripeIntent + ", nextActionData=" + this.nextActionData + ", requestOptions=" + this.requestOptions + ", enableLogging=" + this.enableLogging + ", statusBarColor=" + this.statusBarColor + ", publishableKey=" + this.publishableKey + ", productUsage=" + this.productUsage + ")";
        }

        public int hashCode() {
            int result = this.sdkTransactionId.hashCode();
            result = result * 31 + this.config.hashCode();
            result = result * 31 + this.stripeIntent.hashCode();
            result = result * 31 + this.nextActionData.hashCode();
            result = result * 31 + this.requestOptions.hashCode();
            result = result * 31 + Boolean.hashCode(this.enableLogging);
            result = result * 31 + (this.statusBarColor == null ? 0 : ((Object)this.statusBarColor).hashCode());
            result = result * 31 + this.publishableKey.hashCode();
            result = result * 31 + ((Object)this.productUsage).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.sdkTransactionId, (Object)args.sdkTransactionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)args.config)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeIntent, (Object)args.stripeIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nextActionData, (Object)args.nextActionData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestOptions, (Object)args.requestOptions)) {
                return false;
            }
            if (this.enableLogging != args.enableLogging) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statusBarColor, (Object)args.statusBarColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)args.publishableKey)) {
                return false;
            }
            return Intrinsics.areEqual(this.productUsage, args.productUsage);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                public final Args createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
                    String string2 = parcel.readString();
                    Integer n2 = parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt());
                    boolean bl = parcel.readInt() != 0;
                    ApiRequest.Options options = (ApiRequest.Options)parcel.readParcelable(Args.class.getClassLoader());
                    StripeIntent.NextActionData.SdkData.Use3DS2 use3DS2 = (StripeIntent.NextActionData.SdkData.Use3DS2)StripeIntent.NextActionData.SdkData.Use3DS2.CREATOR.createFromParcel(parcel);
                    StripeIntent stripeIntent = (StripeIntent)parcel.readParcelable(Args.class.getClassLoader());
                    PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config = (PaymentAuthConfig.Stripe3ds2Config)PaymentAuthConfig.Stripe3ds2Config.CREATOR.createFromParcel(parcel);
                    SdkTransactionId sdkTransactionId = (SdkTransactionId)parcel.readParcelable(Args.class.getClassLoader());
                    for (int i = 0; i != n; ++i) {
                        linkedHashSet.add(parcel.readString());
                    }
                    Set set = linkedHashSet;
                    String string3 = string2;
                    Integer n3 = n2;
                    boolean bl2 = bl;
                    ApiRequest.Options options2 = options;
                    StripeIntent.NextActionData.SdkData.Use3DS2 use3DS22 = use3DS2;
                    StripeIntent stripeIntent2 = stripeIntent;
                    PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config2 = stripe3ds2Config;
                    SdkTransactionId sdkTransactionId2 = sdkTransactionId;
                    return new Args(sdkTransactionId2, stripe3ds2Config2, stripeIntent2, use3DS22, options2, bl2, n3, string3, set);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args$Companion;", "", "<init>", "()V", "EXTRA_ARGS", "", "fromIntent", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "intent", "Landroid/content/Intent;", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Args fromIntent(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra(Args.EXTRA_ARGS);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

