/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.core.authentication.NoOpIntentNextActionHandler;
import com.stripe.android.payments.core.authentication.PaymentNextActionHandler;
import com.stripe.android.payments.core.authentication.WebIntentNextActionHandler;
import com.stripe.android.view.AuthActivityStarterHost;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/payments/core/authentication/VoucherNextActionHandler;", "Lcom/stripe/android/payments/core/authentication/PaymentNextActionHandler;", "Lcom/stripe/android/model/StripeIntent;", "webIntentAuthenticator", "Lcom/stripe/android/payments/core/authentication/WebIntentNextActionHandler;", "noOpIntentAuthenticator", "Lcom/stripe/android/payments/core/authentication/NoOpIntentNextActionHandler;", "context", "Landroid/content/Context;", "<init>", "(Lcom/stripe/android/payments/core/authentication/WebIntentNextActionHandler;Lcom/stripe/android/payments/core/authentication/NoOpIntentNextActionHandler;Landroid/content/Context;)V", "performNextActionOnResumed", "", "host", "Lcom/stripe/android/view/AuthActivityStarterHost;", "actionable", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/core/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class VoucherNextActionHandler
extends PaymentNextActionHandler<StripeIntent> {
    @NotNull
    private final WebIntentNextActionHandler webIntentAuthenticator;
    @NotNull
    private final NoOpIntentNextActionHandler noOpIntentAuthenticator;
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    @Inject
    public VoucherNextActionHandler(@NotNull WebIntentNextActionHandler webIntentAuthenticator, @NotNull NoOpIntentNextActionHandler noOpIntentAuthenticator, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)webIntentAuthenticator, (String)"webIntentAuthenticator");
        Intrinsics.checkNotNullParameter((Object)noOpIntentAuthenticator, (String)"noOpIntentAuthenticator");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.webIntentAuthenticator = webIntentAuthenticator;
        this.noOpIntentAuthenticator = noOpIntentAuthenticator;
        this.context = context;
    }

    @Override
    @Nullable
    protected Object performNextActionOnResumed(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent actionable, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        StripeIntent.NextActionData nextActionData = actionable.getNextActionData();
        Intrinsics.checkNotNull((Object)nextActionData, (String)"null cannot be cast to non-null type com.stripe.android.model.StripeIntent.NextActionData.DisplayVoucherDetails");
        StripeIntent.NextActionData.DisplayVoucherDetails detailsData = (StripeIntent.NextActionData.DisplayVoucherDetails)((Object)nextActionData);
        if (detailsData.getHostedVoucherUrl() == null) {
            ErrorReporter errorReporter = ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, this.context, null, 2, null);
            ErrorReporter.ErrorEvent errorEvent = ErrorReporter.UnexpectedErrorEvent.MISSING_HOSTED_VOUCHER_URL;
            Object object = actionable.getNextActionType();
            if (object == null || (object = object.getCode()) == null) {
                object = "";
            }
            ErrorReporter.DefaultImpls.report$default(errorReporter, errorEvent, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"next_action_type", (Object)object)), 2, null);
            Object object2 = this.noOpIntentAuthenticator.performNextAction(host, actionable, requestOptions, $completion);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            return Unit.INSTANCE;
        }
        Object object = this.webIntentAuthenticator.performNextAction(host, actionable, requestOptions, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

