/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.bankaccount.di;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountComponent;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidePublishableKeyFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesAppContextFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesEnableLoggingFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesProductUsageFactory;
import com.stripe.android.payments.bankaccount.domain.AttachFinancialConnectionsSession;
import com.stripe.android.payments.bankaccount.domain.CreateFinancialConnectionsSession;
import com.stripe.android.payments.bankaccount.domain.RetrieveStripeIntent;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountContract;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewEffect;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewModel;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.flow.MutableSharedFlow;

@DaggerGenerated
public final class DaggerCollectBankAccountComponent {
    private DaggerCollectBankAccountComponent() {
    }

    public static CollectBankAccountComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CollectBankAccountComponent.Builder {
        private Application application;
        private MutableSharedFlow<CollectBankAccountViewEffect> viewEffect;
        private SavedStateHandle savedStateHandle;
        private CollectBankAccountContract.Args configuration;

        private Builder() {
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder viewEffect(MutableSharedFlow<CollectBankAccountViewEffect> application) {
            this.viewEffect = (MutableSharedFlow)Preconditions.checkNotNull(application);
            return this;
        }

        @Override
        public Builder savedStateHandle(SavedStateHandle savedStateHandle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)savedStateHandle);
            return this;
        }

        @Override
        public Builder configuration(CollectBankAccountContract.Args configuration) {
            this.configuration = (CollectBankAccountContract.Args)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public CollectBankAccountComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement(this.viewEffect, MutableSharedFlow.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement((Object)this.configuration, CollectBankAccountContract.Args.class);
            return new CollectBankAccountComponentImpl(new CoroutineContextModule(), new CoreCommonModule(), this.application, this.viewEffect, this.savedStateHandle, this.configuration);
        }
    }

    private static final class CollectBankAccountComponentImpl
    implements CollectBankAccountComponent {
        private final CollectBankAccountContract.Args configuration;
        private final MutableSharedFlow<CollectBankAccountViewEffect> viewEffect;
        private final Application application;
        private final SavedStateHandle savedStateHandle;
        private final CollectBankAccountComponentImpl collectBankAccountComponentImpl = this;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<Logger> provideLoggerProvider;

        private CollectBankAccountComponentImpl(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Application applicationParam, MutableSharedFlow<CollectBankAccountViewEffect> viewEffectParam, SavedStateHandle savedStateHandleParam, CollectBankAccountContract.Args configurationParam) {
            this.configuration = configurationParam;
            this.viewEffect = viewEffectParam;
            this.application = applicationParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(coroutineContextModuleParam, coreCommonModuleParam, applicationParam, viewEffectParam, savedStateHandleParam, configurationParam);
        }

        private Context context() {
            return CollectBankAccountModule_ProvidesAppContextFactory.providesAppContext(this.application);
        }

        private Function0<String> namedFunction0OfString() {
            return CollectBankAccountModule_ProvidePublishableKeyFactory.providePublishableKey(this.configuration);
        }

        private PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory() {
            return new PaymentAnalyticsRequestFactory(this.context(), this.namedFunction0OfString(), CollectBankAccountModule_ProvidesProductUsageFactory.providesProductUsage());
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private StripeApiRepository stripeApiRepository() {
            return new StripeApiRepository(this.context(), this.namedFunction0OfString(), (CoroutineContext)this.provideWorkContextProvider.get(), CollectBankAccountModule_ProvidesProductUsageFactory.providesProductUsage(), this.paymentAnalyticsRequestFactory(), (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
        }

        private CreateFinancialConnectionsSession createFinancialConnectionsSession() {
            return new CreateFinancialConnectionsSession(this.stripeApiRepository());
        }

        private AttachFinancialConnectionsSession attachFinancialConnectionsSession() {
            return new AttachFinancialConnectionsSession(this.stripeApiRepository());
        }

        private RetrieveStripeIntent retrieveStripeIntent() {
            return new RetrieveStripeIntent(this.stripeApiRepository());
        }

        private void initialize(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Application applicationParam, MutableSharedFlow<CollectBankAccountViewEffect> viewEffectParam, SavedStateHandle savedStateHandleParam, CollectBankAccountContract.Args configurationParam) {
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, (Provider)CollectBankAccountModule_ProvidesEnableLoggingFactory.create()));
        }

        @Override
        public CollectBankAccountViewModel getViewModel() {
            return new CollectBankAccountViewModel(this.configuration, this.viewEffect, this.createFinancialConnectionsSession(), this.attachFinancialConnectionsSession(), this.retrieveStripeIntent(), this.savedStateHandle, (Logger)this.provideLoggerProvider.get());
        }

        @Override
        public void inject(CollectBankAccountViewModel.Factory factory) {
        }
    }
}

