/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.payments.StripeBrowserLauncherViewModel;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "viewModel", "Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "getViewModel", "()Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "launchBrowser", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "finishWithSuccess", "finishWithFailure", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStripeBrowserLauncherActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeBrowserLauncherActivity.kt\ncom/stripe/android/payments/StripeBrowserLauncherActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,88:1\n75#2,13:89\n*S KotlinDebug\n*F\n+ 1 StripeBrowserLauncherActivity.kt\ncom/stripe/android/payments/StripeBrowserLauncherActivity\n*L\n27#1:89,13\n*E\n"})
public final class StripeBrowserLauncherActivity
extends AppCompatActivity {
    @NotNull
    private final Lazy viewModel$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public StripeBrowserLauncherActivity() {
        void $this$viewModels_u24default$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = StripeBrowserLauncherActivity::viewModel_delegate$lambda$0;
        Function0 extrasProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 function0 = factoryProducer$iv;
        if (function0 == null) {
            function0 = (Function0)new Function0<ViewModelProvider.Factory>((ComponentActivity)$this$viewModels_u24default$iv){
                final /* synthetic */ ComponentActivity $this_viewModels;
                {
                    this.$this_viewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_viewModels.getDefaultViewModelProviderFactory();
                }
            };
        }
        Function0 factoryPromise$iv = function0;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(StripeBrowserLauncherViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, (ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
    }

    private final StripeBrowserLauncherViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (StripeBrowserLauncherViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        PaymentBrowserAuthContract.Args args = PaymentBrowserAuthContract.Companion.parseArgs$payments_core_release(intent);
        if (args == null) {
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.BROWSER_LAUNCHER_NULL_ARGS, null, null, 6, null);
            return;
        }
        if (this.getViewModel().getHasLaunched()) {
            this.finishWithSuccess(args);
        } else {
            this.launchBrowser(args);
        }
    }

    private final void launchBrowser(PaymentBrowserAuthContract.Args args) {
        ActivityResultContracts.StartActivityForResult contract = new ActivityResultContracts.StartActivityForResult();
        ActivityResultLauncher launcher = this.registerForActivityResult((ActivityResultContract)contract, arg_0 -> StripeBrowserLauncherActivity.launchBrowser$lambda$1(this, args, arg_0));
        Intent intent = this.getViewModel().createLaunchIntent(args);
        try {
            launcher.launch((Object)intent);
            this.getViewModel().setHasLaunched(true);
        }
        catch (ActivityNotFoundException e) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.BROWSER_LAUNCHER_ACTIVITY_NOT_FOUND, StripeException.Companion.create((Throwable)e), null, 4, null);
            this.finishWithFailure(args);
        }
    }

    private final void finishWithSuccess(PaymentBrowserAuthContract.Args args) {
        this.setResult(-1, this.getViewModel().getResultIntent(args));
        this.finish();
    }

    private final void finishWithFailure(PaymentBrowserAuthContract.Args args) {
        this.setResult(-1, this.getViewModel().getFailureIntent(args));
        this.finish();
    }

    private static final ViewModelProvider.Factory viewModel_delegate$lambda$0() {
        return new StripeBrowserLauncherViewModel.Factory();
    }

    private static final void launchBrowser$lambda$1(StripeBrowserLauncherActivity this$0, PaymentBrowserAuthContract.Args $args, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.finishWithSuccess($args);
    }
}

