/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.WalletJsonParser;
import com.stripe.android.model.wallets.Wallet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\f\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "BillingDetails", "CardJsonParser", "IdealJsonParser", "FpxJsonParser", "NetbankingJsonParser", "USBankAccountJsonParser", "SepaDebitJsonParser", "AuBecsDebitJsonParser", "BacsDebitJsonParser", "SofortJsonParser", "UpiJsonParser", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
public final class PaymentMethodJsonParser
implements ModelJsonParser<PaymentMethod> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String FIELD_ID = "id";
    @NotNull
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    @NotNull
    private static final String FIELD_CREATED = "created";
    @NotNull
    private static final String FIELD_CUSTOMER = "customer";
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @NotNull
    private static final String FIELD_ALLOW_REDISPLAY = "allow_redisplay";
    @NotNull
    private static final String FIELD_TYPE = "type";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PaymentMethod parse(@NotNull JSONObject json) {
        PaymentMethod.AllowRedisplay allowRedisplay;
        Iterable iterable;
        PaymentMethod.BillingDetails billingDetails;
        String it;
        PaymentMethod.Builder builder;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String code = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE);
        PaymentMethod.Type type = PaymentMethod.Type.Companion.fromCode(code);
        PaymentMethod.Builder builder2 = new PaymentMethod.Builder().setId(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID)).setType(type).setCode(code).setCreated(StripeJsonUtils.INSTANCE.optLong(json, FIELD_CREATED));
        JSONObject jSONObject = json.optJSONObject(FIELD_BILLING_DETAILS);
        if (jSONObject != null) {
            JSONObject jSONObject2 = jSONObject;
            builder = builder2;
            boolean bl = false;
            billingDetails = new BillingDetails().parse((JSONObject)it);
            builder2 = builder;
        } else {
            billingDetails = null;
        }
        PaymentMethod.Builder builder3 = builder2.setBillingDetails(billingDetails);
        String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ALLOW_REDISPLAY);
        if (string2 != null) {
            Object v5;
            block38: {
                it = string2;
                builder = builder3;
                boolean bl = false;
                iterable = (Iterable)PaymentMethod.AllowRedisplay.getEntries();
                for (Object t : iterable) {
                    void allowRedisplayRawValue;
                    PaymentMethod.AllowRedisplay entry = (PaymentMethod.AllowRedisplay)((Object)t);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)allowRedisplayRawValue, (Object)entry.getValue())) continue;
                    v5 = t;
                    break block38;
                }
                v5 = null;
            }
            allowRedisplay = v5;
            builder3 = builder;
        } else {
            allowRedisplay = null;
        }
        PaymentMethod.Builder builder4 = builder3.setAllowRedisplay(allowRedisplay).setCustomerId(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CUSTOMER)).setLiveMode(json.optBoolean(FIELD_LIVEMODE));
        PaymentMethod.Type type2 = type;
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                PaymentMethod.Card card;
                JSONObject it2;
                PaymentMethod.Builder builder5 = builder4;
                JSONObject jSONObject3 = json.optJSONObject(type.code);
                if (jSONObject3 != null) {
                    iterable = jSONObject3;
                    builder = builder5;
                    boolean bl = false;
                    card = new CardJsonParser().parse(it2);
                    builder5 = builder;
                } else {
                    card = null;
                }
                Object object = builder5.setCard(card);
                break;
            }
            case 2: {
                Object object = builder4.setCardPresent(PaymentMethod.CardPresent.Companion.getEMPTY$payments_core_release());
                break;
            }
            case 3: {
                PaymentMethod.Ideal ideal;
                JSONObject it2;
                PaymentMethod.Builder builder6 = builder4;
                JSONObject jSONObject4 = json.optJSONObject(type.code);
                if (jSONObject4 != null) {
                    it2 = jSONObject4;
                    builder = builder6;
                    boolean bl = false;
                    ideal = new IdealJsonParser().parse(it2);
                    builder6 = builder;
                } else {
                    ideal = null;
                }
                Object object = builder6.setIdeal(ideal);
                break;
            }
            case 4: {
                PaymentMethod.Fpx fpx;
                JSONObject it2;
                PaymentMethod.Builder builder7 = builder4;
                JSONObject jSONObject5 = json.optJSONObject(type.code);
                if (jSONObject5 != null) {
                    it2 = jSONObject5;
                    builder = builder7;
                    boolean bl = false;
                    fpx = new FpxJsonParser().parse(it2);
                    builder7 = builder;
                } else {
                    fpx = null;
                }
                Object object = builder7.setFpx(fpx);
                break;
            }
            case 5: {
                PaymentMethod.SepaDebit sepaDebit;
                JSONObject it2;
                PaymentMethod.Builder builder8 = builder4;
                JSONObject jSONObject6 = json.optJSONObject(type.code);
                if (jSONObject6 != null) {
                    it2 = jSONObject6;
                    builder = builder8;
                    boolean bl = false;
                    sepaDebit = new SepaDebitJsonParser().parse(it2);
                    builder8 = builder;
                } else {
                    sepaDebit = null;
                }
                Object object = builder8.setSepaDebit(sepaDebit);
                break;
            }
            case 6: {
                PaymentMethod.AuBecsDebit auBecsDebit;
                JSONObject it2;
                PaymentMethod.Builder builder9 = builder4;
                JSONObject jSONObject7 = json.optJSONObject(type.code);
                if (jSONObject7 != null) {
                    it2 = jSONObject7;
                    builder = builder9;
                    boolean bl = false;
                    auBecsDebit = new AuBecsDebitJsonParser().parse(it2);
                    builder9 = builder;
                } else {
                    auBecsDebit = null;
                }
                Object object = builder9.setAuBecsDebit(auBecsDebit);
                break;
            }
            case 7: {
                PaymentMethod.BacsDebit bacsDebit;
                JSONObject it2;
                PaymentMethod.Builder builder10 = builder4;
                JSONObject jSONObject8 = json.optJSONObject(type.code);
                if (jSONObject8 != null) {
                    it2 = jSONObject8;
                    builder = builder10;
                    boolean bl = false;
                    bacsDebit = new BacsDebitJsonParser().parse(it2);
                    builder10 = builder;
                } else {
                    bacsDebit = null;
                }
                Object object = builder10.setBacsDebit(bacsDebit);
                break;
            }
            case 8: {
                PaymentMethod.Sofort sofort;
                JSONObject it2;
                PaymentMethod.Builder builder11 = builder4;
                JSONObject jSONObject9 = json.optJSONObject(type.code);
                if (jSONObject9 != null) {
                    it2 = jSONObject9;
                    builder = builder11;
                    boolean bl = false;
                    sofort = new SofortJsonParser().parse(it2);
                    builder11 = builder;
                } else {
                    sofort = null;
                }
                Object object = builder11.setSofort(sofort);
                break;
            }
            case 9: {
                PaymentMethod.Upi upi;
                JSONObject it2;
                PaymentMethod.Builder builder12 = builder4;
                JSONObject jSONObject10 = json.optJSONObject(type.code);
                if (jSONObject10 != null) {
                    it2 = jSONObject10;
                    builder = builder12;
                    boolean bl = false;
                    upi = new UpiJsonParser().parse(it2);
                    builder12 = builder;
                } else {
                    upi = null;
                }
                Object object = builder12.setUpi(upi);
                break;
            }
            case 10: {
                PaymentMethod.Netbanking netbanking;
                JSONObject it2;
                PaymentMethod.Builder builder13 = builder4;
                JSONObject jSONObject11 = json.optJSONObject(type.code);
                if (jSONObject11 != null) {
                    it2 = jSONObject11;
                    builder = builder13;
                    boolean bl = false;
                    netbanking = new NetbankingJsonParser().parse(it2);
                    builder13 = builder;
                } else {
                    netbanking = null;
                }
                Object object = builder13.setNetbanking(netbanking);
                break;
            }
            case 11: {
                PaymentMethod.USBankAccount uSBankAccount;
                JSONObject it2;
                PaymentMethod.Builder builder14 = builder4;
                JSONObject jSONObject12 = json.optJSONObject(type.code);
                if (jSONObject12 != null) {
                    it2 = jSONObject12;
                    builder = builder14;
                    boolean bl = false;
                    uSBankAccount = new USBankAccountJsonParser().parse(it2);
                    builder14 = builder;
                } else {
                    uSBankAccount = null;
                }
                Object object = builder14.setUSBankAccount(uSBankAccount);
                break;
            }
            default: {
                Object object = Unit.INSTANCE;
            }
        }
        return builder4.build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$AuBecsDebit;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class AuBecsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.AuBecsDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_BSB_NUMBER = "bsb_number";
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @NotNull
        private static final String FIELD_LAST4 = "last4";

        @NotNull
        public PaymentMethod.AuBecsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.AuBecsDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BSB_NUMBER), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser$Companion;", "", "<init>", "()V", "FIELD_BSB_NUMBER", "", "FIELD_FINGERPRINT", "FIELD_LAST4", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BacsDebit;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class BacsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.BacsDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @NotNull
        private static final String FIELD_SORT_CODE = "sort_code";

        @NotNull
        public PaymentMethod.BacsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.BacsDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_SORT_CODE));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser$Companion;", "", "<init>", "()V", "FIELD_FINGERPRINT", "", "FIELD_LAST4", "FIELD_SORT_CODE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class BillingDetails
    implements ModelJsonParser<PaymentMethod.BillingDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @NotNull
        private static final String FIELD_EMAIL = "email";
        @NotNull
        private static final String FIELD_NAME = "name";
        @NotNull
        private static final String FIELD_PHONE = "phone";

        @NotNull
        public PaymentMethod.BillingDetails parse(@NotNull JSONObject json) {
            Address address;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl = false;
                address = new AddressJsonParser().parse(it);
            } else {
                address = null;
            }
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PHONE);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL);
            Address address2 = address;
            return new PaymentMethod.BillingDetails(address2, string4, string3, string2);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails$Companion;", "", "<init>", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\b\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "ChecksJsonParser", "ThreeDSecureUsageJsonParser", "NetworksJsonParser", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class CardJsonParser
    implements ModelJsonParser<PaymentMethod.Card> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_BRAND = "brand";
        @NotNull
        private static final String FIELD_CHECKS = "checks";
        @NotNull
        private static final String FIELD_COUNTRY = "country";
        @NotNull
        private static final String FIELD_EXP_MONTH = "exp_month";
        @NotNull
        private static final String FIELD_EXP_YEAR = "exp_year";
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @NotNull
        private static final String FIELD_FUNDING = "funding";
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @NotNull
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        @NotNull
        private static final String FIELD_WALLET = "wallet";
        @NotNull
        private static final String FIELD_DISPLAY_BRAND = "display_brand";
        @NotNull
        private static final String FIELD_NETWORKS = "networks";

        @NotNull
        public PaymentMethod.Card parse(@NotNull JSONObject json) {
            PaymentMethod.Card.Networks networks;
            Wallet wallet;
            Wallet wallet2;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage2;
            PaymentMethod.Card.Checks checks;
            String string2;
            Integer n;
            Integer n2;
            String string3;
            String string4;
            String string5;
            PaymentMethod.Card.Checks checks2;
            JSONObject it;
            CardBrand cardBrand;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            CardBrand cardBrand2 = CardBrand.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BRAND));
            JSONObject jSONObject = json.optJSONObject(FIELD_CHECKS);
            if (jSONObject != null) {
                JSONObject jSONObject2 = jSONObject;
                cardBrand = cardBrand2;
                boolean bl = false;
                checks2 = new ChecksJsonParser().parse(it);
                cardBrand2 = cardBrand;
            } else {
                checks2 = null;
            }
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY);
            Integer n3 = StripeJsonUtils.INSTANCE.optInteger(json, FIELD_EXP_MONTH);
            Integer n4 = StripeJsonUtils.INSTANCE.optInteger(json, FIELD_EXP_YEAR);
            String string7 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT);
            String string8 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FUNDING);
            String string9 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4);
            JSONObject jSONObject3 = json.optJSONObject(FIELD_THREE_D_SECURE_USAGE);
            if (jSONObject3 != null) {
                it = jSONObject3;
                string5 = string9;
                string4 = string8;
                string3 = string7;
                n2 = n4;
                n = n3;
                string2 = string6;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                threeDSecureUsage2 = new ThreeDSecureUsageJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string6 = string2;
                n3 = n;
                n4 = n2;
                string7 = string3;
                string8 = string4;
                string9 = string5;
                threeDSecureUsage = threeDSecureUsage2;
            } else {
                threeDSecureUsage = null;
            }
            JSONObject jSONObject4 = json.optJSONObject(FIELD_WALLET);
            if (jSONObject4 != null) {
                it = jSONObject4;
                threeDSecureUsage2 = threeDSecureUsage;
                string5 = string9;
                string4 = string8;
                string3 = string7;
                n2 = n4;
                n = n3;
                string2 = string6;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                wallet2 = new WalletJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string6 = string2;
                n3 = n;
                n4 = n2;
                string7 = string3;
                string8 = string4;
                string9 = string5;
                threeDSecureUsage = threeDSecureUsage2;
                wallet = wallet2;
            } else {
                wallet = null;
            }
            JSONObject jSONObject5 = json.optJSONObject(FIELD_NETWORKS);
            if (jSONObject5 != null) {
                it = jSONObject5;
                wallet2 = wallet;
                threeDSecureUsage2 = threeDSecureUsage;
                string5 = string9;
                string4 = string8;
                string3 = string7;
                n2 = n4;
                n = n3;
                string2 = string6;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                PaymentMethod.Card.Networks networks2 = new NetworksJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string6 = string2;
                n3 = n;
                n4 = n2;
                string7 = string3;
                string8 = string4;
                string9 = string5;
                threeDSecureUsage = threeDSecureUsage2;
                wallet = wallet2;
                networks = networks2;
            } else {
                networks = null;
            }
            String string10 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DISPLAY_BRAND);
            PaymentMethod.Card.Networks networks3 = networks;
            Wallet wallet3 = wallet;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage3 = threeDSecureUsage;
            String string11 = string9;
            String string12 = string8;
            String string13 = string7;
            Integer n5 = n4;
            Integer n6 = n3;
            String string14 = string6;
            PaymentMethod.Card.Checks checks3 = checks2;
            CardBrand cardBrand3 = cardBrand2;
            return new PaymentMethod.Card(cardBrand3, checks3, string14, n6, n5, string13, string12, string11, threeDSecureUsage3, wallet3, networks3, string10);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Checks;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        @StabilityInferred(parameters=1)
        public static final class ChecksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Checks> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            public static final int $stable;
            @NotNull
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            @NotNull
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            @NotNull
            private static final String FIELD_CVC_CHECK = "cvc_check";

            @NotNull
            public PaymentMethod.Card.Checks parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.Checks(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ADDRESS_LINE1_CHECK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ADDRESS_POSTAL_CODE_CHECK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CVC_CHECK));
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser$Companion;", "", "<init>", "()V", "FIELD_ADDRESS_LINE1_CHECK", "", "FIELD_ADDRESS_POSTAL_CODE_CHECK", "FIELD_CVC_CHECK", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$Companion;", "", "<init>", "()V", "FIELD_BRAND", "", "FIELD_CHECKS", "FIELD_COUNTRY", "FIELD_EXP_MONTH", "FIELD_EXP_YEAR", "FIELD_FINGERPRINT", "FIELD_FUNDING", "FIELD_LAST4", "FIELD_THREE_D_SECURE_USAGE", "FIELD_WALLET", "FIELD_DISPLAY_BRAND", "FIELD_NETWORKS", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Networks;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        @StabilityInferred(parameters=1)
        @SourceDebugExtension(value={"SMAP\nPaymentMethodJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodJsonParser.kt\ncom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1557#2:392\n1628#2,3:393\n*S KotlinDebug\n*F\n+ 1 PaymentMethodJsonParser.kt\ncom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser\n*L\n189#1:392\n189#1:393,3\n*E\n"})
        public static final class NetworksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Networks> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            public static final int $stable;
            @NotNull
            private static final String FIELD_AVAIABLE = "available";
            @NotNull
            private static final String FIELD_SELECTION_MANDATORY = "selection_mandatory";
            @NotNull
            private static final String FIELD_PREFERRED = "preferred";

            /*
             * WARNING - void declaration
             */
            @NotNull
            public PaymentMethod.Card.Networks parse(@NotNull JSONObject json) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                List list = StripeJsonUtils.INSTANCE.jsonArrayToList(json.optJSONArray(FIELD_AVAIABLE));
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                Set available = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                return new PaymentMethod.Card.Networks(available, StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_SELECTION_MANDATORY), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PREFERRED));
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser$Companion;", "", "<init>", "()V", "FIELD_AVAIABLE", "", "FIELD_SELECTION_MANDATORY", "FIELD_PREFERRED", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$ThreeDSecureUsage;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        @StabilityInferred(parameters=1)
        public static final class ThreeDSecureUsageJsonParser
        implements ModelJsonParser<PaymentMethod.Card.ThreeDSecureUsage> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            public static final int $stable;
            @NotNull
            private static final String FIELD_IS_SUPPORTED = "supported";

            @NotNull
            public PaymentMethod.Card.ThreeDSecureUsage parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.ThreeDSecureUsage(StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_IS_SUPPORTED));
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser$Companion;", "", "<init>", "()V", "FIELD_IS_SUPPORTED", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$Companion;", "", "<init>", "()V", "FIELD_ID", "", "FIELD_BILLING_DETAILS", "FIELD_CREATED", "FIELD_CUSTOMER", "FIELD_LIVEMODE", "FIELD_ALLOW_REDISPLAY", "FIELD_TYPE", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Fpx;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class FpxJsonParser
    implements ModelJsonParser<PaymentMethod.Fpx> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        @NotNull
        private static final String FIELD_BANK = "bank";

        @NotNull
        public PaymentMethod.Fpx parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Fpx(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_HOLDER_TYPE));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser$Companion;", "", "<init>", "()V", "FIELD_ACCOUNT_HOLDER_TYPE", "", "FIELD_BANK", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Ideal;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class IdealJsonParser
    implements ModelJsonParser<PaymentMethod.Ideal> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_BANK = "bank";
        @NotNull
        private static final String FIELD_BIC = "bic";

        @NotNull
        public PaymentMethod.Ideal parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Ideal(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BIC));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser$Companion;", "", "<init>", "()V", "FIELD_BANK", "", "FIELD_BIC", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$NetbankingJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Netbanking;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class NetbankingJsonParser
    implements ModelJsonParser<PaymentMethod.Netbanking> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_BANK = "bank";

        @NotNull
        public PaymentMethod.Netbanking parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Netbanking(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$NetbankingJsonParser$Companion;", "", "<init>", "()V", "FIELD_BANK", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$SepaDebit;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class SepaDebitJsonParser
    implements ModelJsonParser<PaymentMethod.SepaDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_BANK_CODE = "bank_code";
        @NotNull
        private static final String FIELD_BRANCH_CODE = "branch_code";
        @NotNull
        private static final String FIELD_COUNTRY = "country";
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @NotNull
        private static final String FIELD_LAST4 = "last4";

        @NotNull
        public PaymentMethod.SepaDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.SepaDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK_CODE), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BRANCH_CODE), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser$Companion;", "", "<init>", "()V", "FIELD_BANK_CODE", "", "FIELD_BRANCH_CODE", "FIELD_COUNTRY", "FIELD_FINGERPRINT", "FIELD_LAST4", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Sofort;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class SofortJsonParser
    implements ModelJsonParser<PaymentMethod.Sofort> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_COUNTRY = "country";

        @NotNull
        public PaymentMethod.Sofort parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Sofort(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser$Companion;", "", "<init>", "()V", "FIELD_COUNTRY", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$USBankAccount;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nPaymentMethodJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodJsonParser.kt\ncom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1557#2:392\n1628#2,3:393\n*S KotlinDebug\n*F\n+ 1 PaymentMethodJsonParser.kt\ncom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser\n*L\n282#1:392\n282#1:393,3\n*E\n"})
    public static final class USBankAccountJsonParser
    implements ModelJsonParser<PaymentMethod.USBankAccount> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        @NotNull
        private static final String FIELD_ACCOUNT_TYPE = "account_type";
        @NotNull
        private static final String FIELD_BANK_NAME = "bank_name";
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @NotNull
        private static final String FIELD_FINANCIAL_CONNECTIONS_ACCOUNT = "financial_connections_account";
        @NotNull
        private static final String FIELD_NETWORKS = "networks";
        @NotNull
        private static final String FIELD_NETWORKS_PREFERRED = "preferred";
        @NotNull
        private static final String FIELD_NETWORKS_SUPPORTED = "supported";
        @NotNull
        private static final String FIELD_ROUTING_NUMBER = "routing_number";

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PaymentMethod.USBankAccount parse(@NotNull JSONObject json) {
            PaymentMethod.USBankAccount.USBankNetworks uSBankNetworks;
            Object v2;
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType;
            Iterable iterable;
            block9: {
                PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType2;
                Object v0;
                Enum it;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    iterable = (Iterable)PaymentMethod.USBankAccount.USBankAccountHolderType.getEntries();
                    for (Object t : iterable) {
                        it = (PaymentMethod.USBankAccount.USBankAccountHolderType)((Object)t);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_HOLDER_TYPE), (Object)((PaymentMethod.USBankAccount.USBankAccountHolderType)it).getValue())) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                if ((uSBankAccountHolderType2 = (PaymentMethod.USBankAccount.USBankAccountHolderType)v0) == null) {
                    uSBankAccountHolderType2 = PaymentMethod.USBankAccount.USBankAccountHolderType.UNKNOWN;
                }
                Iterable iterable2 = (Iterable)PaymentMethod.USBankAccount.USBankAccountType.getEntries();
                uSBankAccountHolderType = uSBankAccountHolderType2;
                iterable = iterable2;
                for (Object t : iterable) {
                    it = (PaymentMethod.USBankAccount.USBankAccountType)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_TYPE), (Object)((PaymentMethod.USBankAccount.USBankAccountType)it).getValue())) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType3 = uSBankAccountHolderType;
            PaymentMethod.USBankAccount.USBankAccountType uSBankAccountType = v2;
            if (uSBankAccountType == null) {
                uSBankAccountType = PaymentMethod.USBankAccount.USBankAccountType.UNKNOWN;
            }
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK_NAME);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINANCIAL_CONNECTIONS_ACCOUNT);
            if (json.has(FIELD_NETWORKS)) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string6 = StripeJsonUtils.optString((JSONObject)json.optJSONObject(FIELD_NETWORKS), (String)FIELD_NETWORKS_PREFERRED);
                JSONObject jSONObject = json.optJSONObject(FIELD_NETWORKS);
                List list = StripeJsonUtils.INSTANCE.jsonArrayToList((JSONArray)(jSONObject != null ? jSONObject.getJSONArray(FIELD_NETWORKS_SUPPORTED) : null));
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable iterable3 = list;
                String string7 = string6;
                String string8 = string5;
                String string9 = string4;
                String string10 = string3;
                String string11 = string2;
                PaymentMethod.USBankAccount.USBankAccountType uSBankAccountType2 = uSBankAccountType;
                uSBankAccountHolderType = uSBankAccountHolderType3;
                boolean $i$f$map = false;
                iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                collection = (List)destination$iv$iv;
                uSBankAccountHolderType3 = uSBankAccountHolderType;
                uSBankAccountType = uSBankAccountType2;
                string2 = string11;
                string3 = string10;
                string4 = string9;
                string5 = string8;
                Collection<String> collection2 = collection;
                String string12 = string7;
                uSBankNetworks = new PaymentMethod.USBankAccount.USBankNetworks(string12, (List<String>)collection2);
            } else {
                uSBankNetworks = null;
            }
            String string13 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ROUTING_NUMBER);
            PaymentMethod.USBankAccount.USBankNetworks uSBankNetworks2 = uSBankNetworks;
            String string14 = string5;
            String string15 = string4;
            String string16 = string3;
            String string17 = string2;
            PaymentMethod.USBankAccount.USBankAccountType uSBankAccountType3 = uSBankAccountType;
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType4 = uSBankAccountHolderType3;
            return new PaymentMethod.USBankAccount(uSBankAccountHolderType4, uSBankAccountType3, string17, string16, string15, string14, uSBankNetworks2, string13);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser$Companion;", "", "<init>", "()V", "FIELD_ACCOUNT_HOLDER_TYPE", "", "FIELD_ACCOUNT_TYPE", "FIELD_BANK_NAME", "FIELD_FINGERPRINT", "FIELD_LAST4", "FIELD_FINANCIAL_CONNECTIONS_ACCOUNT", "FIELD_NETWORKS", "FIELD_NETWORKS_PREFERRED", "FIELD_NETWORKS_SUPPORTED", "FIELD_ROUTING_NUMBER", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$UpiJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Upi;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class UpiJsonParser
    implements ModelJsonParser<PaymentMethod.Upi> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_VPA = "vpa";

        @NotNull
        public PaymentMethod.Upi parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Upi(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_VPA));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$UpiJsonParser$Companion;", "", "<init>", "()V", "FIELD_VPA", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.CardPresent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Ideal.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Fpx.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.AuBecsDebit.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.BacsDebit.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Sofort.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Upi.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Netbanking.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

