/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.uicore.format.CurrencyFormatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/PayWithGoogleUtils;", "", "<init>", "()V", "getPriceString", "", "price", "", "currency", "Ljava/util/Currency;", "", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class PayWithGoogleUtils {
    @NotNull
    public static final PayWithGoogleUtils INSTANCE = new PayWithGoogleUtils();
    public static final int $stable;

    private PayWithGoogleUtils() {
    }

    @Deprecated(message="Use getPriceString(Long, Currency) instead.", replaceWith=@ReplaceWith(expression="getPriceString(price.toLong(), currency)", imports={}))
    @JvmStatic
    @NotNull
    public static final String getPriceString(int price, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return PayWithGoogleUtils.getPriceString((long)price, currency);
    }

    @JvmStatic
    @NotNull
    public static final String getPriceString(long price, @NotNull Currency currency) {
        int i;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        int fractionDigits = CurrencyFormatter.INSTANCE.getDefaultDecimalDigits(currency);
        int totalLength = String.valueOf(price).length();
        StringBuilder builder = new StringBuilder();
        if (fractionDigits == 0) {
            for (int i2 = 0; i2 < totalLength; ++i2) {
                builder.append('#');
            }
            DecimalFormat noDecimalCurrencyFormat = new DecimalFormat(builder.toString(), DecimalFormatSymbols.getInstance(Locale.ROOT));
            noDecimalCurrencyFormat.setCurrency(currency);
            noDecimalCurrencyFormat.setGroupingUsed(false);
            String string = noDecimalCurrencyFormat.format(price);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        int beforeDecimal = totalLength - fractionDigits;
        for (i = 0; i < beforeDecimal; ++i) {
            builder.append('#');
        }
        if (totalLength <= fractionDigits) {
            builder.append('0');
        }
        builder.append('.');
        for (i = 0; i < fractionDigits; ++i) {
            builder.append('0');
        }
        double modBreak = Math.pow(10.0, fractionDigits);
        double decimalPrice = (double)price / modBreak;
        DecimalFormatSymbols symbolOverride = DecimalFormatSymbols.getInstance(Locale.ROOT);
        DecimalFormat decimalFormat = new DecimalFormat(builder.toString(), symbolOverride);
        decimalFormat.setCurrency(currency);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(decimalPrice);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

