/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.model.parsers.EphemeralKeyJsonParser;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\b\u0001\u0018\u0000 *2\u00020\u0001:\u0004'()*BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0012\b\u0002\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001a\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0017\u0010%\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/stripe/android/EphemeralKeyManager;", "", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "listener", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "shouldPrefetchEphemeralKey", "", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "timeBufferInSeconds", "<init>", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;Lcom/stripe/android/OperationIdFactory;ZLkotlin/jvm/functions/Function0;J)V", "apiVersion", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "getEphemeralKey$payments_core_release", "()Lcom/stripe/android/EphemeralKey;", "setEphemeralKey$payments_core_release", "(Lcom/stripe/android/EphemeralKey;)V", "retrieveEphemeralKey", "", "operation", "Lcom/stripe/android/EphemeralOperation;", "retrieveEphemeralKey$payments_core_release", "updateKey", "key", "updateKeyError", "operationId", "errorCode", "", "errorMessage", "shouldRefreshKey", "shouldRefreshKey$payments_core_release", "KeyManagerListener", "ClientKeyUpdateListener", "Factory", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEphemeralKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EphemeralKeyManager.kt\ncom/stripe/android/EphemeralKeyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class EphemeralKeyManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final EphemeralKeyProvider ephemeralKeyProvider;
    @NotNull
    private final KeyManagerListener listener;
    @NotNull
    private final Function0<Long> timeSupplier;
    private final long timeBufferInSeconds;
    @NotNull
    private final String apiVersion;
    private /* synthetic */ EphemeralKey ephemeralKey;
    public static final int $stable = 8;
    private static final long REFRESH_BUFFER_IN_SECONDS = 30L;

    public EphemeralKeyManager(@NotNull EphemeralKeyProvider ephemeralKeyProvider, @NotNull KeyManagerListener listener, @NotNull OperationIdFactory operationIdFactory, boolean shouldPrefetchEphemeralKey, @NotNull Function0<Long> timeSupplier, long timeBufferInSeconds) {
        Intrinsics.checkNotNullParameter((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
        this.ephemeralKeyProvider = ephemeralKeyProvider;
        this.listener = listener;
        this.timeSupplier = timeSupplier;
        this.timeBufferInSeconds = timeBufferInSeconds;
        this.apiVersion = ApiVersion.Companion.get().getCode();
        if (shouldPrefetchEphemeralKey) {
            this.retrieveEphemeralKey$payments_core_release(new EphemeralOperation.RetrieveKey(operationIdFactory.create(), SetsKt.emptySet()));
        }
    }

    public /* synthetic */ EphemeralKeyManager(EphemeralKeyProvider ephemeralKeyProvider, KeyManagerListener keyManagerListener, OperationIdFactory operationIdFactory, boolean bl, Function0 function0, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            function0 = EphemeralKeyManager::_init_$lambda$0;
        }
        if ((n & 0x20) != 0) {
            l = 30L;
        }
        this(ephemeralKeyProvider, keyManagerListener, operationIdFactory, bl, (Function0<Long>)function0, l);
    }

    @Nullable
    public final EphemeralKey getEphemeralKey$payments_core_release() {
        return this.ephemeralKey;
    }

    public final void setEphemeralKey$payments_core_release(@Nullable EphemeralKey ephemeralKey) {
        this.ephemeralKey = ephemeralKey;
    }

    public final /* synthetic */ void retrieveEphemeralKey$payments_core_release(EphemeralOperation operation) {
        EphemeralKey ephemeralKey;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        EphemeralKey it = ephemeralKey = this.ephemeralKey;
        boolean bl = false;
        EphemeralKey ephemeralKey2 = !(it == null || this.shouldRefreshKey$payments_core_release(it)) ? ephemeralKey : null;
        if (ephemeralKey2 != null) {
            EphemeralKey ephemeralKey3 = ephemeralKey2;
            boolean bl2 = false;
            this.listener.onKeyUpdate(ephemeralKey3, operation);
        } else {
            this.ephemeralKeyProvider.createEphemeralKey(this.apiVersion, new ClientKeyUpdateListener(this, operation));
        }
    }

    private final void updateKey(EphemeralOperation operation, String key) {
        Object $this$updateKey_u24lambda_u244;
        if (key == null) {
            String message = "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value";
            this.listener.onKeyError(operation.getId$payments_core_release(), 500, message, new IllegalArgumentException(message));
            return;
        }
        Object object = this;
        try {
            EphemeralKey ephemeralKey;
            $this$updateKey_u24lambda_u244 = object;
            boolean bl = false;
            EphemeralKey it = ephemeralKey = new EphemeralKeyJsonParser().parse(new JSONObject(key));
            boolean bl2 = false;
            ((EphemeralKeyManager)$this$updateKey_u24lambda_u244).ephemeralKey = it;
            $this$updateKey_u24lambda_u244 = Result.constructor-impl((Object)ephemeralKey);
        }
        catch (Throwable bl) {
            $this$updateKey_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$updateKey_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            EphemeralKey ephemeralKey = (EphemeralKey)object;
            boolean bl = false;
            this.listener.onKeyUpdate(ephemeralKey, operation);
        } else {
            Throwable it = throwable;
            boolean bl = false;
            String errorMessage = it instanceof JSONException ? StringsKt.trimIndent((String)("\n                        Received an ephemeral key that could not be parsed. See https://stripe.com/docs/mobile/android/basic for more details.\n                        \n                        " + it.getMessage() + "\n                        ")) : StringsKt.trimIndent((String)("\n                        Received an invalid ephemeral key. See https://stripe.com/docs/mobile/android/basic for more details.\n                        \n                        " + it.getMessage() + "\n                        "));
            this.listener.onKeyError(operation.getId$payments_core_release(), 500, errorMessage, it);
        }
    }

    private final void updateKeyError(String operationId, int errorCode, String errorMessage) {
        this.ephemeralKey = null;
        this.listener.onKeyError(operationId, errorCode, errorMessage, new Exception(errorMessage));
    }

    public final boolean shouldRefreshKey$payments_core_release(@Nullable EphemeralKey ephemeralKey) {
        if (ephemeralKey == null) {
            return true;
        }
        long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(((Number)this.timeSupplier.invoke()).longValue());
        long nowPlusBuffer = nowInSeconds + this.timeBufferInSeconds;
        return ephemeralKey.getExpires$payments_core_release() < nowPlusBuffer;
    }

    private static final long _init_$lambda$0() {
        return Calendar.getInstance().getTimeInMillis();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/EphemeralKeyManager$ClientKeyUpdateListener;", "Lcom/stripe/android/EphemeralKeyUpdateListener;", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "operation", "Lcom/stripe/android/EphemeralOperation;", "<init>", "(Lcom/stripe/android/EphemeralKeyManager;Lcom/stripe/android/EphemeralOperation;)V", "onKeyUpdate", "", "stripeResponseJson", "", "onKeyUpdateFailure", "responseCode", "", "message", "payments-core_release"})
    private static final class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        @NotNull
        private final EphemeralKeyManager ephemeralKeyManager;
        @NotNull
        private final EphemeralOperation operation;

        public ClientKeyUpdateListener(@NotNull EphemeralKeyManager ephemeralKeyManager2, @NotNull EphemeralOperation operation) {
            Intrinsics.checkNotNullParameter((Object)ephemeralKeyManager2, (String)"ephemeralKeyManager");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.ephemeralKeyManager = ephemeralKeyManager2;
            this.operation = operation;
        }

        @Override
        public void onKeyUpdate(@NotNull String stripeResponseJson) {
            Intrinsics.checkNotNullParameter((Object)stripeResponseJson, (String)"stripeResponseJson");
            this.ephemeralKeyManager.updateKey(this.operation, stripeResponseJson);
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.ephemeralKeyManager.updateKeyError(this.operation.getId$payments_core_release(), responseCode, message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Companion;", "", "<init>", "()V", "REFRESH_BUFFER_IN_SECONDS", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Factory;", "", "create", "Lcom/stripe/android/EphemeralKeyManager;", "arg", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "Default", "payments-core_release"})
    public static interface Factory {
        @NotNull
        public EphemeralKeyManager create(@NotNull KeyManagerListener var1);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Factory$Default;", "Lcom/stripe/android/EphemeralKeyManager$Factory;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "shouldPrefetchEphemeralKey", "", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "<init>", "(Lcom/stripe/android/EphemeralKeyProvider;ZLcom/stripe/android/OperationIdFactory;Lkotlin/jvm/functions/Function0;)V", "create", "Lcom/stripe/android/EphemeralKeyManager;", "arg", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "payments-core_release"})
        @StabilityInferred(parameters=1)
        public static final class Default
        implements Factory {
            @NotNull
            private final EphemeralKeyProvider keyProvider;
            private final boolean shouldPrefetchEphemeralKey;
            @NotNull
            private final OperationIdFactory operationIdFactory;
            @NotNull
            private final Function0<Long> timeSupplier;
            public static final int $stable;

            public Default(@NotNull EphemeralKeyProvider keyProvider, boolean shouldPrefetchEphemeralKey, @NotNull OperationIdFactory operationIdFactory, @NotNull Function0<Long> timeSupplier) {
                Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
                Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
                Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
                this.keyProvider = keyProvider;
                this.shouldPrefetchEphemeralKey = shouldPrefetchEphemeralKey;
                this.operationIdFactory = operationIdFactory;
                this.timeSupplier = timeSupplier;
            }

            public /* synthetic */ Default(EphemeralKeyProvider ephemeralKeyProvider, boolean bl, OperationIdFactory operationIdFactory, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    operationIdFactory = new StripeOperationIdFactory();
                }
                if ((n & 8) != 0) {
                    function0 = Default::_init_$lambda$0;
                }
                this(ephemeralKeyProvider, bl, operationIdFactory, (Function0<Long>)function0);
            }

            @Override
            public /* synthetic */ EphemeralKeyManager create(KeyManagerListener arg) {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                return new EphemeralKeyManager(this.keyProvider, arg, this.operationIdFactory, this.shouldPrefetchEphemeralKey, this.timeSupplier, 0L, 32, null);
            }

            private static final long _init_$lambda$0() {
                return Calendar.getInstance().getTimeInMillis();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J(\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "", "onKeyUpdate", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation;", "onKeyError", "operationId", "", "errorCode", "", "errorMessage", "throwable", "", "payments-core_release"})
    public static interface KeyManagerListener {
        public void onKeyUpdate(@NotNull EphemeralKey var1, @NotNull EphemeralOperation var2);

        public void onKeyError(@NotNull String var1, int var2, @NotNull String var3, @NotNull Throwable var4);
    }
}

