/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.account.LinkStore;
import com.stripe.android.link.analytics.LinkAnalyticsHelper;
import com.stripe.android.link.injection.LinkAnalyticsComponent;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016J\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016J\u0006\u0010\u001a\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/link/LinkPaymentLauncher;", "", "linkAnalyticsComponentBuilder", "Lcom/stripe/android/link/injection/LinkAnalyticsComponent$Builder;", "linkActivityContract", "Lcom/stripe/android/link/LinkActivityContract;", "linkStore", "Lcom/stripe/android/link/account/LinkStore;", "(Lcom/stripe/android/link/injection/LinkAnalyticsComponent$Builder;Lcom/stripe/android/link/LinkActivityContract;Lcom/stripe/android/link/account/LinkStore;)V", "analyticsHelper", "Lcom/stripe/android/link/analytics/LinkAnalyticsHelper;", "linkActivityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "present", "", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "register", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/link/LinkActivityResult;", "activityResultRegistry", "Landroidx/activity/result/ActivityResultRegistry;", "unregister", "link_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class LinkPaymentLauncher {
    @NotNull
    private final LinkActivityContract linkActivityContract;
    @NotNull
    private final LinkStore linkStore;
    @NotNull
    private final LinkAnalyticsHelper analyticsHelper;
    @Nullable
    private ActivityResultLauncher<LinkActivityContract.Args> linkActivityResultLauncher;
    public static final int $stable = 8;

    @Inject
    public LinkPaymentLauncher(@NotNull LinkAnalyticsComponent.Builder linkAnalyticsComponentBuilder, @NotNull LinkActivityContract linkActivityContract, @NotNull LinkStore linkStore) {
        Intrinsics.checkNotNullParameter((Object)linkAnalyticsComponentBuilder, (String)"linkAnalyticsComponentBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)linkActivityContract), (String)"linkActivityContract");
        Intrinsics.checkNotNullParameter((Object)linkStore, (String)"linkStore");
        this.linkActivityContract = linkActivityContract;
        this.linkStore = linkStore;
        this.analyticsHelper = linkAnalyticsComponentBuilder.build().getLinkAnalyticsHelper();
    }

    public final void register(@NotNull ActivityResultRegistry activityResultRegistry, @NotNull Function1<? super LinkActivityResult, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistry, (String)"activityResultRegistry");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.linkActivityResultLauncher = activityResultRegistry.register("LinkPaymentLauncher", (ActivityResultContract)this.linkActivityContract, arg_0 -> LinkPaymentLauncher.register$lambda$0(this, callback, arg_0));
    }

    public final void register(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super LinkActivityResult, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.linkActivityResultLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)this.linkActivityContract, arg_0 -> LinkPaymentLauncher.register$lambda$1(this, callback, arg_0));
    }

    public final void unregister() {
        ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher = this.linkActivityResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
        this.linkActivityResultLauncher = null;
    }

    public final void present(@NotNull LinkConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        LinkActivityContract.Args args = new LinkActivityContract.Args(configuration);
        ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher = this.linkActivityResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.launch((Object)args);
        }
        this.analyticsHelper.onLinkLaunched();
    }

    private static final void register$lambda$0(LinkPaymentLauncher this$0, Function1 $callback, LinkActivityResult linkActivityResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        LinkAnalyticsHelper linkAnalyticsHelper = this$0.analyticsHelper;
        Intrinsics.checkNotNull((Object)linkActivityResult);
        linkAnalyticsHelper.onLinkResult(linkActivityResult);
        if (linkActivityResult instanceof LinkActivityResult.Completed) {
            this$0.linkStore.markLinkAsUsed();
        }
        $callback.invoke((Object)linkActivityResult);
    }

    private static final void register$lambda$1(LinkPaymentLauncher this$0, Function1 $callback, LinkActivityResult linkActivityResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        LinkAnalyticsHelper linkAnalyticsHelper = this$0.analyticsHelper;
        Intrinsics.checkNotNull((Object)linkActivityResult);
        linkAnalyticsHelper.onLinkResult(linkActivityResult);
        if (linkActivityResult instanceof LinkActivityResult.Completed) {
            this$0.linkStore.markLinkAsUsed();
        }
        $callback.invoke((Object)linkActivityResult);
    }
}

