/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha;

import androidx.annotation.RestrictTo;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0087\u0081\u0002\u0018\u0000 \u00192\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0019B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u001a"}, d2={"Lcom/stripe/hcaptcha/HCaptchaError;", "Ljava/io/Serializable;", "", "errorId", "", "message", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getErrorId", "()I", "getMessage", "()Ljava/lang/String;", "NETWORK_ERROR", "INVALID_DATA", "CHALLENGE_ERROR", "INTERNAL_ERROR", "SESSION_TIMEOUT", "TOKEN_TIMEOUT", "CHALLENGE_CLOSED", "RATE_LIMITED", "INVALID_CUSTOM_THEME", "INSECURE_HTTP_REQUEST_ERROR", "ERROR", "toString", "Companion", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HCaptchaError
extends Enum<HCaptchaError>
implements Serializable {
    @NotNull
    public static final Companion Companion;
    private final int errorId;
    @NotNull
    private final String message;
    public static final /* enum */ HCaptchaError NETWORK_ERROR;
    public static final /* enum */ HCaptchaError INVALID_DATA;
    public static final /* enum */ HCaptchaError CHALLENGE_ERROR;
    public static final /* enum */ HCaptchaError INTERNAL_ERROR;
    public static final /* enum */ HCaptchaError SESSION_TIMEOUT;
    public static final /* enum */ HCaptchaError TOKEN_TIMEOUT;
    public static final /* enum */ HCaptchaError CHALLENGE_CLOSED;
    public static final /* enum */ HCaptchaError RATE_LIMITED;
    public static final /* enum */ HCaptchaError INVALID_CUSTOM_THEME;
    public static final /* enum */ HCaptchaError INSECURE_HTTP_REQUEST_ERROR;
    public static final /* enum */ HCaptchaError ERROR;
    private static final /* synthetic */ HCaptchaError[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private HCaptchaError(int errorId, String message) {
        this.errorId = errorId;
        this.message = message;
    }

    public final int getErrorId() {
        return this.errorId;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public String toString() {
        return this.message;
    }

    public static HCaptchaError[] values() {
        return (HCaptchaError[])$VALUES.clone();
    }

    public static HCaptchaError valueOf(String value) {
        return Enum.valueOf(HCaptchaError.class, value);
    }

    @NotNull
    public static EnumEntries<HCaptchaError> getEntries() {
        return $ENTRIES;
    }

    static {
        NETWORK_ERROR = new HCaptchaError(7, "No internet connection");
        INVALID_DATA = new HCaptchaError(8, "Invalid data is not accepted by endpoints");
        CHALLENGE_ERROR = new HCaptchaError(9, "Challenge encountered error on setup");
        INTERNAL_ERROR = new HCaptchaError(10, "hCaptcha client encountered an internal error");
        SESSION_TIMEOUT = new HCaptchaError(15, "Session Timeout");
        TOKEN_TIMEOUT = new HCaptchaError(16, "Token Timeout");
        CHALLENGE_CLOSED = new HCaptchaError(30, "Challenge Closed");
        RATE_LIMITED = new HCaptchaError(31, "Rate Limited");
        INVALID_CUSTOM_THEME = new HCaptchaError(32, "Invalid custom theme");
        INSECURE_HTTP_REQUEST_ERROR = new HCaptchaError(33, "Insecure resource requested");
        ERROR = new HCaptchaError(29, "Unknown error");
        $VALUES = hCaptchaErrorArray = new HCaptchaError[]{HCaptchaError.NETWORK_ERROR, HCaptchaError.INVALID_DATA, HCaptchaError.CHALLENGE_ERROR, HCaptchaError.INTERNAL_ERROR, HCaptchaError.SESSION_TIMEOUT, HCaptchaError.TOKEN_TIMEOUT, HCaptchaError.CHALLENGE_CLOSED, HCaptchaError.RATE_LIMITED, HCaptchaError.INVALID_CUSTOM_THEME, HCaptchaError.INSECURE_HTTP_REQUEST_ERROR, HCaptchaError.ERROR};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/hcaptcha/HCaptchaError$Companion;", "", "<init>", "()V", "fromId", "Lcom/stripe/hcaptcha/HCaptchaError;", "errorId", "", "hcaptcha_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HCaptchaError fromId(int errorId) {
            for (HCaptchaError error : HCaptchaError.getEntries()) {
                if (error.getErrorId() != errorId) continue;
                return error;
            }
            throw new RuntimeException("Unsupported error id: " + errorId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

