/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha;

import android.app.Activity;
import android.util.AndroidRuntimeException;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import com.stripe.hcaptcha.HCaptchaDialogFragment;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.HCaptchaStateListener;
import com.stripe.hcaptcha.HCaptchaTokenResponse;
import com.stripe.hcaptcha.IHCaptcha;
import com.stripe.hcaptcha.IHCaptchaVerifier;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.config.HCaptchaInternalConfig;
import com.stripe.hcaptcha.config.HCaptchaSize;
import com.stripe.hcaptcha.task.Task;
import com.stripe.hcaptcha.webview.HCaptchaHeadlessWebView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/hcaptcha/HCaptcha;", "Lcom/stripe/hcaptcha/task/Task;", "Lcom/stripe/hcaptcha/HCaptchaTokenResponse;", "Lcom/stripe/hcaptcha/IHCaptcha;", "activity", "Landroidx/fragment/app/FragmentActivity;", "internalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "<init>", "(Landroidx/fragment/app/FragmentActivity;Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;)V", "captchaVerifier", "Lcom/stripe/hcaptcha/IHCaptchaVerifier;", "setup", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "verifyWithHCaptcha", "reset", "", "Companion", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HCaptcha
extends Task<HCaptchaTokenResponse>
implements IHCaptcha {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FragmentActivity activity;
    @NotNull
    private final HCaptchaInternalConfig internalConfig;
    @Nullable
    private IHCaptchaVerifier captchaVerifier;

    private HCaptcha(FragmentActivity activity, HCaptchaInternalConfig internalConfig) {
        this.activity = activity;
        this.internalConfig = internalConfig;
    }

    @Override
    @NotNull
    public HCaptcha setup(@NotNull HCaptchaConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HCaptchaStateListener listener = new HCaptchaStateListener((Function0<Unit>)((Function0)() -> HCaptcha.setup$lambda$0(this)), (Function1<? super String, Unit>)((Function1)arg_0 -> HCaptcha.setup$lambda$1(this, config, arg_0)), (Function1<? super HCaptchaException, Unit>)((Function1)arg_0 -> HCaptcha.setup$lambda$2(this, arg_0)));
        try {
            IHCaptchaVerifier iHCaptchaVerifier;
            if (config.getHideDialog()) {
                HCaptchaSize hCaptchaSize = HCaptchaSize.INVISIBLE;
                iHCaptchaVerifier = new HCaptchaHeadlessWebView((Activity)this.activity, HCaptchaConfig.copy-ZIzw2bI$default(config, null, false, false, false, null, null, null, null, null, null, null, hCaptchaSize, null, null, null, null, null, 0L, false, 522235, null), this.internalConfig, listener);
            } else {
                iHCaptchaVerifier = HCaptchaDialogFragment.Companion.newInstance(config, this.internalConfig, listener);
            }
            this.captchaVerifier = iHCaptchaVerifier;
        }
        catch (AndroidRuntimeException e) {
            listener.getOnFailure().invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
        }
        return this;
    }

    @Override
    @NotNull
    public HCaptcha verifyWithHCaptcha() {
        IHCaptchaVerifier iHCaptchaVerifier = this.captchaVerifier;
        if (iHCaptchaVerifier == null) {
            throw new IllegalStateException("verifyWithHCaptcha must not be called before setup.");
        }
        IHCaptchaVerifier captchaVerifier = iHCaptchaVerifier;
        this.getHandler().removeCallbacksAndMessages(null);
        captchaVerifier.startVerification(this.activity);
        return this;
    }

    @Override
    public void reset() {
        block0: {
            IHCaptchaVerifier iHCaptchaVerifier = this.captchaVerifier;
            if (iHCaptchaVerifier == null) break block0;
            IHCaptchaVerifier it = iHCaptchaVerifier;
            boolean bl = false;
            it.reset();
            this.captchaVerifier = null;
        }
    }

    private static final Unit setup$lambda$0(HCaptcha this$0) {
        this$0.captchaOpened();
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$1(HCaptcha this$0, HCaptchaConfig $config, String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this$0.scheduleCaptchaExpired-LRDsOJo($config.getTokenExpiration-UwyO8pc());
        this$0.setResult(new HCaptchaTokenResponse(token, this$0.getHandler()));
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$2(HCaptcha this$0, HCaptchaException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.setException(exception);
        return Unit.INSTANCE;
    }

    public /* synthetic */ HCaptcha(FragmentActivity activity, HCaptchaInternalConfig internalConfig, DefaultConstructorMarker $constructor_marker) {
        this(activity, internalConfig);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/hcaptcha/HCaptcha$Companion;", "", "<init>", "()V", "getClient", "Lcom/stripe/hcaptcha/HCaptcha;", "activity", "Landroidx/fragment/app/FragmentActivity;", "internalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "hcaptcha_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HCaptcha getClient(@NotNull FragmentActivity activity, @NotNull HCaptchaInternalConfig internalConfig) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
            return new HCaptcha(activity, internalConfig, null);
        }

        public static /* synthetic */ HCaptcha getClient$default(Companion companion, FragmentActivity fragmentActivity, HCaptchaInternalConfig hCaptchaInternalConfig, int n, Object object) {
            if ((n & 2) != 0) {
                hCaptchaInternalConfig = new HCaptchaInternalConfig(null, 1, null);
            }
            return companion.getClient(fragmentActivity, hCaptchaInternalConfig);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

