/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha;

import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.core.os.BundleCompat;
import com.stripe.hcaptcha.HCaptchaStateListener;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.config.HCaptchaInternalConfig;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ9\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/hcaptcha/HCaptchaCompat;", "", "()V", "KEY_CONFIG", "", "KEY_INTERNAL_CONFIG", "KEY_LISTENER", "getConfig", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "bundle", "Landroid/os/Bundle;", "getInternalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "getSerializable", "T", "Ljava/io/Serializable;", "key", "clazz", "Ljava/lang/Class;", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/Class;)Ljava/io/Serializable;", "getStateListener", "Lcom/stripe/hcaptcha/HCaptchaStateListener;", "storeValues", "config", "internalConfig", "listener", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HCaptchaCompat {
    @NotNull
    public static final HCaptchaCompat INSTANCE = new HCaptchaCompat();
    @NotNull
    private static final String KEY_CONFIG = "hCaptchaConfig";
    @NotNull
    private static final String KEY_INTERNAL_CONFIG = "hCaptchaInternalConfig";
    @NotNull
    private static final String KEY_LISTENER = "hCaptchaDialogListener";

    private HCaptchaCompat() {
    }

    @NotNull
    public final Bundle storeValues(@NotNull HCaptchaConfig config2, @NotNull HCaptchaInternalConfig internalConfig, @NotNull HCaptchaStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Bundle args = new Bundle();
        args.putSerializable(KEY_CONFIG, (Serializable)config2);
        args.putSerializable(KEY_INTERNAL_CONFIG, (Serializable)internalConfig);
        args.putParcelable(KEY_LISTENER, (Parcelable)listener2);
        return args;
    }

    @Nullable
    public final HCaptchaConfig getConfig(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        return this.getSerializable(bundle, KEY_CONFIG, HCaptchaConfig.class);
    }

    @Nullable
    public final HCaptchaInternalConfig getInternalConfig(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        return this.getSerializable(bundle, KEY_INTERNAL_CONFIG, HCaptchaInternalConfig.class);
    }

    @Nullable
    public final HCaptchaStateListener getStateListener(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        return (HCaptchaStateListener)BundleCompat.getParcelable((Bundle)bundle, (String)KEY_LISTENER, HCaptchaStateListener.class);
    }

    private final <T extends Serializable> T getSerializable(Bundle bundle, String key, Class<T> clazz) {
        return (T)(Build.VERSION.SDK_INT >= 33 ? bundle.getSerializable(key, clazz) : bundle.getSerializable(key));
    }
}

