/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.attestation;

import androidx.annotation.RestrictTo;
import com.google.android.play.core.integrity.StandardIntegrityException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0007\u0018\u0000 \u000e2\u00060\u0001j\u0002`\u0002:\u0002\r\u000eB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/stripe/attestation/AttestationError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorType", "Lcom/stripe/attestation/AttestationError$ErrorType;", "message", "", "cause", "", "<init>", "(Lcom/stripe/attestation/AttestationError$ErrorType;Ljava/lang/String;Ljava/lang/Throwable;)V", "getErrorType", "()Lcom/stripe/attestation/AttestationError$ErrorType;", "ErrorType", "Companion", "stripe-attestation_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AttestationError
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ErrorType errorType;
    @NotNull
    private static final Map<Integer, ErrorType> errorCodeToErrorTypeMap;

    public AttestationError(@NotNull ErrorType errorType, @NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorType), (String)"errorType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, cause);
        this.errorType = errorType;
    }

    public /* synthetic */ AttestationError(ErrorType errorType, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(errorType, string, throwable);
    }

    @NotNull
    public final ErrorType getErrorType() {
        return this.errorType;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)-1, (Object)((Object)ErrorType.API_NOT_AVAILABLE)), TuplesKt.to((Object)-5, (Object)((Object)ErrorType.APP_NOT_INSTALLED)), TuplesKt.to((Object)-7, (Object)((Object)ErrorType.APP_UID_MISMATCH)), TuplesKt.to((Object)-9, (Object)((Object)ErrorType.CANNOT_BIND_TO_SERVICE)), TuplesKt.to((Object)-18, (Object)((Object)ErrorType.CLIENT_TRANSIENT_ERROR)), TuplesKt.to((Object)-16, (Object)((Object)ErrorType.CLOUD_PROJECT_NUMBER_IS_INVALID)), TuplesKt.to((Object)-12, (Object)((Object)ErrorType.GOOGLE_SERVER_UNAVAILABLE)), TuplesKt.to((Object)-19, (Object)((Object)ErrorType.INTEGRITY_TOKEN_PROVIDER_INVALID)), TuplesKt.to((Object)-100, (Object)((Object)ErrorType.INTERNAL_ERROR)), TuplesKt.to((Object)-3, (Object)((Object)ErrorType.NETWORK_ERROR)), TuplesKt.to((Object)0, (Object)((Object)ErrorType.NO_ERROR)), TuplesKt.to((Object)-6, (Object)((Object)ErrorType.PLAY_SERVICES_NOT_FOUND)), TuplesKt.to((Object)-15, (Object)((Object)ErrorType.PLAY_SERVICES_VERSION_OUTDATED)), TuplesKt.to((Object)-2, (Object)((Object)ErrorType.PLAY_STORE_NOT_FOUND)), TuplesKt.to((Object)-14, (Object)((Object)ErrorType.PLAY_STORE_VERSION_OUTDATED)), TuplesKt.to((Object)-17, (Object)((Object)ErrorType.REQUEST_HASH_TOO_LONG)), TuplesKt.to((Object)-8, (Object)((Object)ErrorType.TOO_MANY_REQUESTS))};
        errorCodeToErrorTypeMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/attestation/AttestationError$Companion;", "", "<init>", "()V", "fromException", "Lcom/stripe/attestation/AttestationError;", "exception", "", "errorCodeToErrorTypeMap", "", "", "Lcom/stripe/attestation/AttestationError$ErrorType;", "stripe-attestation_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttestationError fromException(@NotNull Throwable exception) {
            AttestationError attestationError;
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            if (exception instanceof StandardIntegrityException) {
                String string;
                ErrorType errorType = (ErrorType)((Object)errorCodeToErrorTypeMap.get(((StandardIntegrityException)exception).getErrorCode()));
                if (errorType == null) {
                    errorType = ErrorType.UNKNOWN;
                }
                if ((string = exception.getMessage()) == null) {
                    string = "Integrity error occurred";
                }
                attestationError = new AttestationError(errorType, string, exception);
            } else {
                attestationError = new AttestationError(ErrorType.UNKNOWN, "An unknown error occurred", exception);
            }
            return attestationError;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/stripe/attestation/AttestationError$ErrorType;", "", "isRetriable", "", "<init>", "(Ljava/lang/String;IZ)V", "()Z", "API_NOT_AVAILABLE", "APP_NOT_INSTALLED", "APP_UID_MISMATCH", "CANNOT_BIND_TO_SERVICE", "CLIENT_TRANSIENT_ERROR", "CLOUD_PROJECT_NUMBER_IS_INVALID", "GOOGLE_SERVER_UNAVAILABLE", "INTEGRITY_TOKEN_PROVIDER_INVALID", "INTERNAL_ERROR", "NO_ERROR", "NETWORK_ERROR", "PLAY_SERVICES_NOT_FOUND", "PLAY_SERVICES_VERSION_OUTDATED", "PLAY_STORE_NOT_FOUND", "PLAY_STORE_VERSION_OUTDATED", "REQUEST_HASH_TOO_LONG", "TOO_MANY_REQUESTS", "BACKEND_VERDICT_FAILED", "UNKNOWN", "stripe-attestation_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class ErrorType
    extends Enum<ErrorType> {
        private final boolean isRetriable;
        public static final /* enum */ ErrorType API_NOT_AVAILABLE = new ErrorType(false);
        public static final /* enum */ ErrorType APP_NOT_INSTALLED = new ErrorType(false);
        public static final /* enum */ ErrorType APP_UID_MISMATCH = new ErrorType(false);
        public static final /* enum */ ErrorType CANNOT_BIND_TO_SERVICE = new ErrorType(true);
        public static final /* enum */ ErrorType CLIENT_TRANSIENT_ERROR = new ErrorType(true);
        public static final /* enum */ ErrorType CLOUD_PROJECT_NUMBER_IS_INVALID = new ErrorType(false);
        public static final /* enum */ ErrorType GOOGLE_SERVER_UNAVAILABLE = new ErrorType(true);
        public static final /* enum */ ErrorType INTEGRITY_TOKEN_PROVIDER_INVALID = new ErrorType(false);
        public static final /* enum */ ErrorType INTERNAL_ERROR = new ErrorType(true);
        public static final /* enum */ ErrorType NO_ERROR = new ErrorType(false);
        public static final /* enum */ ErrorType NETWORK_ERROR = new ErrorType(true);
        public static final /* enum */ ErrorType PLAY_SERVICES_NOT_FOUND = new ErrorType(false);
        public static final /* enum */ ErrorType PLAY_SERVICES_VERSION_OUTDATED = new ErrorType(false);
        public static final /* enum */ ErrorType PLAY_STORE_NOT_FOUND = new ErrorType(true);
        public static final /* enum */ ErrorType PLAY_STORE_VERSION_OUTDATED = new ErrorType(false);
        public static final /* enum */ ErrorType REQUEST_HASH_TOO_LONG = new ErrorType(false);
        public static final /* enum */ ErrorType TOO_MANY_REQUESTS = new ErrorType(true);
        public static final /* enum */ ErrorType BACKEND_VERDICT_FAILED = new ErrorType(false);
        public static final /* enum */ ErrorType UNKNOWN = new ErrorType(false);
        private static final /* synthetic */ ErrorType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ErrorType(boolean isRetriable) {
            this.isRetriable = isRetriable;
        }

        public final boolean isRetriable() {
            return this.isRetriable;
        }

        public static ErrorType[] values() {
            return (ErrorType[])$VALUES.clone();
        }

        public static ErrorType valueOf(String value) {
            return Enum.valueOf(ErrorType.class, value);
        }

        @NotNull
        public static EnumEntries<ErrorType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = errorTypeArray = new ErrorType[]{ErrorType.API_NOT_AVAILABLE, ErrorType.APP_NOT_INSTALLED, ErrorType.APP_UID_MISMATCH, ErrorType.CANNOT_BIND_TO_SERVICE, ErrorType.CLIENT_TRANSIENT_ERROR, ErrorType.CLOUD_PROJECT_NUMBER_IS_INVALID, ErrorType.GOOGLE_SERVER_UNAVAILABLE, ErrorType.INTEGRITY_TOKEN_PROVIDER_INVALID, ErrorType.INTERNAL_ERROR, ErrorType.NO_ERROR, ErrorType.NETWORK_ERROR, ErrorType.PLAY_SERVICES_NOT_FOUND, ErrorType.PLAY_SERVICES_VERSION_OUTDATED, ErrorType.PLAY_STORE_NOT_FOUND, ErrorType.PLAY_STORE_VERSION_OUTDATED, ErrorType.REQUEST_HASH_TOO_LONG, ErrorType.TOO_MANY_REQUESTS, ErrorType.BACKEND_VERDICT_FAILED, ErrorType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

