/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.AwsS3Service;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.SocketAccess;

class InternalAwsS3Service
extends AbstractLifecycleComponent
implements AwsS3Service {
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private final Map<String, S3ClientSettings> clientsSettings;
    private final Map<String, AmazonS3Client> clientsCache = new HashMap<String, AmazonS3Client>();

    InternalAwsS3Service(Settings settings, Map<String, S3ClientSettings> clientsSettings) {
        super(settings);
        this.clientsSettings = clientsSettings;
    }

    @Override
    public synchronized AmazonS3 client(Settings repositorySettings) {
        String clientName = (String)CLIENT_NAME.get(repositorySettings);
        AmazonS3Client client = this.clientsCache.get(clientName);
        if (client != null) {
            return client;
        }
        S3ClientSettings clientSettings = this.clientsSettings.get(clientName);
        if (clientSettings == null) {
            throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientsSettings.keySet(), (String)","));
        }
        this.logger.debug("creating S3 client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)clientSettings.endpoint);
        AWSCredentialsProvider credentials = InternalAwsS3Service.buildCredentials(this.logger, this.deprecationLogger, clientSettings, repositorySettings);
        ClientConfiguration configuration = InternalAwsS3Service.buildConfiguration(clientSettings, repositorySettings);
        client = new AmazonS3Client(credentials, configuration);
        if (Strings.hasText((String)clientSettings.endpoint)) {
            client.setEndpoint(clientSettings.endpoint);
        }
        this.clientsCache.put(clientName, client);
        return client;
    }

    static ClientConfiguration buildConfiguration(S3ClientSettings clientSettings, Settings repositorySettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, DeprecationLogger deprecationLogger, S3ClientSettings clientSettings, Settings repositorySettings) {
        BasicAWSCredentials credentials = clientSettings.credentials;
        if (S3Repository.ACCESS_KEY_SETTING.exists(repositorySettings)) {
            if (!S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
                throw new IllegalArgumentException("Repository setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + "]");
            }
            try (SecureString key = (SecureString)S3Repository.ACCESS_KEY_SETTING.get(repositorySettings);
                 SecureString secret = (SecureString)S3Repository.SECRET_KEY_SETTING.get(repositorySettings);){
                credentials = new BasicAWSCredentials(key.toString(), secret.toString());
            }
            deprecationLogger.deprecated("Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
        } else if (S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
            throw new IllegalArgumentException("Repository setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + "]");
        }
        if (credentials == null) {
            logger.debug("Using instance profile credentials");
            return new PrivilegedInstanceProfileCredentialsProvider();
        }
        logger.debug("Using basic key/secret credentials");
        return new StaticCredentialsProvider((AWSCredentials)credentials);
    }

    private static <T> T getRepoValue(Settings repositorySettings, Setting<T> repositorySetting, T fallback) {
        if (repositorySetting.exists(repositorySettings)) {
            return (T)repositorySetting.get(repositorySettings);
        }
        return fallback;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clientsCache.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AWSCredentialsProvider {
        private final InstanceProfileCredentialsProvider credentials = new InstanceProfileCredentialsProvider();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return SocketAccess.doPrivileged(() -> ((InstanceProfileCredentialsProvider)this.credentials).getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> ((InstanceProfileCredentialsProvider)this.credentials).refresh());
        }
    }
}

