/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.providers;

import com.stormpath.sdk.Stormpath;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.models.SocialProviderConfiguration;
import com.stormpath.sdk.models.SocialProviderConfigurationSingleton;
import com.stormpath.sdk.models.StormpathError;
import com.stormpath.sdk.providers.BaseLoginProvider;
import com.stormpath.sdk.providers.LoginProvider;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleLoginProvider
extends BaseLoginProvider
implements LoginProvider {
    @Override
    public void getResponseFromCallbackURL(String url, final StormpathCallback<String> callback) {
        if (url.contains("error")) {
            callback.onFailure(new StormpathError("Unknown Error", new IllegalStateException("no code or access_token was not found, did you forget to login? See debug logs for details.")));
        }
        Map<String, List<String>> mMap = null;
        try {
            mMap = this.dictionaryFromFormEncodedString(url);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (!mMap.containsKey(SocialProviderConfigurationSingleton.getInstance().urlScheme + ":/oauth2callback" + "?code")) {
            callback.onFailure(new StormpathError("Unknown Error", new IllegalStateException("no code or access_token was not found, did you forget to login? See debug logs for details.")));
        } else {
            String authorizationCode = mMap.get(SocialProviderConfigurationSingleton.getInstance().urlScheme + ":/oauth2callback" + "?code").get(0);
            Stormpath.socialGoogleCodeAuth(authorizationCode, SocialProviderConfigurationSingleton.getInstance(), new StormpathCallback<String>(){

                @Override
                public void onSuccess(String response) {
                    JSONObject responseJson = null;
                    String accessToken = null;
                    try {
                        responseJson = new JSONObject(response);
                        accessToken = responseJson.getString("access_token");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    callback.onSuccess(accessToken);
                }

                @Override
                public void onFailure(StormpathError error) {
                    callback.onFailure(error);
                }
            });
        }
    }

    @Override
    public String authenticationRequestURL(SocialProviderConfiguration application) {
        SocialProviderConfigurationSingleton.getInstance().appId = application.appId;
        SocialProviderConfigurationSingleton.getInstance().urlScheme = application.urlScheme;
        SocialProviderConfigurationSingleton.getInstance().scopes = application.scopes;
        Random state = new Random(10000000L);
        String scopes = application.scopes != null ? application.scopes : "email profile";
        StringTokenizer multiTokenizer = new StringTokenizer(application.appId, ".");
        int tokens = multiTokenizer.countTokens();
        ArrayList<String> tokenArray = new ArrayList<String>();
        while (multiTokenizer.hasMoreTokens()) {
            tokenArray.add(multiTokenizer.nextToken());
        }
        String clientId = "";
        for (int i = tokenArray.size() - 1; i > -1; --i) {
            clientId = i != tokenArray.size() - 1 ? clientId + "." + (String)tokenArray.get(i) : clientId + (String)tokenArray.get(i);
        }
        String queryString = "response_type=code&scope=" + scopes + "&redirect_uri=" + application.urlScheme + ":/oauth2callback&client_id=" + clientId + "&verifier=" + Math.abs(state.nextInt());
        return "https://accounts.google.com/o/oauth2/auth?" + queryString;
    }
}

