/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.android;

import android.content.ComponentName;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsServiceConnection;
import com.stormpath.sdk.android.ServiceConnectionCallback;
import java.lang.ref.WeakReference;

public class ServiceConnection
extends CustomTabsServiceConnection {
    private WeakReference<ServiceConnectionCallback> mConnectionCallback;

    public ServiceConnection(ServiceConnectionCallback connectionCallback) {
        this.mConnectionCallback = new WeakReference<ServiceConnectionCallback>(connectionCallback);
    }

    public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
        ServiceConnectionCallback connectionCallback = (ServiceConnectionCallback)this.mConnectionCallback.get();
        if (connectionCallback != null) {
            connectionCallback.onServiceConnected(client);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        ServiceConnectionCallback connectionCallback = (ServiceConnectionCallback)this.mConnectionCallback.get();
        if (connectionCallback != null) {
            connectionCallback.onServiceDisconnected();
        }
    }
}

