/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

public class StormpathConfiguration {
    private String baseUrl;
    private String oauthPath;
    private String registerPath;
    private String verifyEmailPath;
    private String passwordResetPath;
    private String logoutPath;
    private String userProfilePath;

    StormpathConfiguration(Builder builder) {
        this.baseUrl = StormpathConfiguration.normalizeUrl(builder.baseUrl);
        this.oauthPath = StormpathConfiguration.normalizePath(builder.oauthPath);
        this.registerPath = StormpathConfiguration.normalizePath(builder.registerPath);
        this.verifyEmailPath = StormpathConfiguration.normalizePath(builder.verifyEmailPath);
        this.passwordResetPath = StormpathConfiguration.normalizePath(builder.passwordResetPath);
        this.logoutPath = StormpathConfiguration.normalizePath(builder.logoutPath);
        this.userProfilePath = StormpathConfiguration.normalizePath(builder.userProfilePath);
    }

    String baseUrl() {
        return this.baseUrl;
    }

    String oauthPath() {
        return this.oauthPath;
    }

    String registerPath() {
        return this.registerPath;
    }

    String verifyEmailPath() {
        return this.verifyEmailPath;
    }

    String passwordResetPath() {
        return this.passwordResetPath;
    }

    String logoutPath() {
        return this.logoutPath;
    }

    String userProfilePath() {
        return this.userProfilePath;
    }

    String oauthUrl() {
        return this.baseUrl + this.oauthPath;
    }

    String registerUrl() {
        return this.baseUrl + this.registerPath;
    }

    String verifyEmailUrl() {
        return this.baseUrl + this.verifyEmailPath;
    }

    String passwordResetUrl() {
        return this.baseUrl + this.passwordResetPath;
    }

    String logoutUrl() {
        return this.baseUrl + this.logoutPath;
    }

    String userProfileUrl() {
        return this.baseUrl + this.userProfilePath;
    }

    private static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String normalizeUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static class Builder {
        String baseUrl;
        String oauthPath = "/oauth/token";
        String registerPath = "/register";
        String verifyEmailPath = "/verify";
        String passwordResetPath = "/forgot";
        String logoutPath = "/logout";
        String userProfilePath = "/me";

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder oauthPath(String oauthPath) {
            this.oauthPath = oauthPath;
            return this;
        }

        public Builder registerPath(String registerPath) {
            this.registerPath = registerPath;
            return this;
        }

        public Builder verifyEmailPath(String verifyEmailPath) {
            this.verifyEmailPath = verifyEmailPath;
            return this;
        }

        public Builder passwordResetPath(String passwordResetPath) {
            this.passwordResetPath = passwordResetPath;
            return this;
        }

        public Builder logoutPath(String logoutPath) {
            this.logoutPath = logoutPath;
            return this;
        }

        public Builder userProfilePath(String userProfilePath) {
            this.userProfilePath = userProfilePath;
            return this;
        }

        public StormpathConfiguration build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("baseUrl == null");
            }
            if (this.oauthPath == null) {
                throw new IllegalStateException("oauthPath == null");
            }
            if (this.registerPath == null) {
                throw new IllegalStateException("registerPath == null");
            }
            if (this.verifyEmailPath == null) {
                throw new IllegalStateException("verifyEmailPath == null");
            }
            if (this.passwordResetPath == null) {
                throw new IllegalStateException("passwordResetPath == null");
            }
            if (this.logoutPath == null) {
                throw new IllegalStateException("logoutPath == null");
            }
            if (this.userProfilePath == null) {
                throw new IllegalStateException("userProfilePath == null");
            }
            return new StormpathConfiguration(this);
        }
    }
}

