/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stormpath.sdk.ApiManager;
import com.stormpath.sdk.Platform;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.StormpathConfiguration;
import com.stormpath.sdk.StormpathLogger;
import com.stormpath.sdk.android.AndroidPlatform;
import com.stormpath.sdk.models.RegisterParams;
import com.stormpath.sdk.models.UserProfile;

public class Stormpath {
    static StormpathConfiguration config;
    static Platform platform;
    static ApiManager apiManager;
    static int logLevel;

    private Stormpath() {
    }

    public static void init(@NonNull Context context, @NonNull StormpathConfiguration config) {
        Stormpath.init(new AndroidPlatform(context), config);
    }

    static void init(@NonNull Platform platform, @NonNull StormpathConfiguration configuration) {
        if (config != null && Stormpath.platform != null && apiManager != null) {
            throw new IllegalStateException("You may only initialize Stormpath once!");
        }
        Stormpath.platform = platform;
        Stormpath.platform.logger().setLogLevel(logLevel);
        config = configuration;
        apiManager = new ApiManager(config, platform);
        Stormpath.logger().v("Initialized Stormpath SDK with baseUrl: " + config.baseUrl(), new Object[0]);
    }

    static void reset() {
        platform = null;
        config = null;
        apiManager = null;
        logLevel = 100;
    }

    public static void login(String username, String password, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.login(username, password, callback);
    }

    public static void register(RegisterParams registerParams, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.register(registerParams, callback);
    }

    public static void refreshAccessToken(StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.refreshAccessToken(callback);
    }

    public static void getUserProfile(StormpathCallback<UserProfile> callback) {
        Stormpath.ensureConfigured();
        apiManager.getUserProfile(callback);
    }

    public static void resetPassword(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resetPassword(email, callback);
    }

    public static void verifyEmail(String sptoken, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.verifyEmail(sptoken, callback);
    }

    public static void resendVerificationEmail(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resendVerificationEmail(email, callback);
    }

    public static void logout() {
        Stormpath.ensureConfigured();
        apiManager.logout();
    }

    @Nullable
    public static String accessToken() {
        Stormpath.ensureConfigured();
        return platform.preferenceStore().getAccessToken();
    }

    public static void setLogLevel(int logLevel) {
        Stormpath.logLevel = logLevel;
        if (platform != null) {
            platform.logger().setLogLevel(Stormpath.logLevel);
        }
    }

    static void ensureConfigured() {
        if (config == null || platform == null || apiManager == null) {
            throw new IllegalStateException("You need to initialize Stormpath before using it. To do that call Stormpath.init() with a valid configuration.");
        }
    }

    static StormpathLogger logger() {
        Stormpath.ensureConfigured();
        return platform.logger();
    }

    static {
        logLevel = 100;
    }
}

