/*
 * Decompiled with CFR 0.152.
 */
package com.steve.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.steve.view.DocUtils;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DocView
extends ImageView {
    static final int NONE = 0;
    static final int DRAG = 1;
    static final int ZOOM = 2;
    static final int CLICK = 3;
    private static final String TAG = DocView.class.getSimpleName();
    private static Executor executor = Executors.newSingleThreadExecutor();
    protected float origWidth;
    protected float origHeight;
    Matrix matrix;
    int mode = 0;
    PointF last = new PointF();
    PointF start = new PointF();
    float minScale = 1.0f;
    float maxScale = 3.0f;
    float[] m;
    int viewWidth;
    int viewHeight;
    float saveScale = 1.0f;
    int oldMeasuredWidth;
    int oldMeasuredHeight;
    ScaleGestureDetector mScaleDetector;

    public DocView(Context context) {
        this(context, null);
    }

    public DocView(Context context, AttributeSet attr) {
        this(context, attr, 0);
    }

    public DocView(Context context, AttributeSet attr, int defStyle) {
        super(context, attr, defStyle);
        super.setClickable(true);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.matrix = new Matrix();
        this.m = new float[9];
        this.setImageMatrix(this.matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                DocView.this.mScaleDetector.onTouchEvent(event);
                PointF curr = new PointF(event.getX(), event.getY());
                switch (event.getAction()) {
                    case 0: {
                        DocView.this.last.set(curr);
                        DocView.this.start.set(DocView.this.last);
                        DocView.this.mode = 1;
                        break;
                    }
                    case 2: {
                        if (DocView.this.mode != 1) break;
                        float deltaX = curr.x - DocView.this.last.x;
                        float deltaY = curr.y - DocView.this.last.y;
                        float fixTransX = DocView.this.getFixDragTrans(deltaX, DocView.this.viewWidth, DocView.this.origWidth * DocView.this.saveScale);
                        float fixTransY = DocView.this.getFixDragTrans(deltaY, DocView.this.viewHeight, DocView.this.origHeight * DocView.this.saveScale);
                        DocView.this.matrix.postTranslate(fixTransX, fixTransY);
                        DocView.this.fixTrans();
                        DocView.this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: {
                        DocView.this.mode = 0;
                        int xDiff = (int)Math.abs(curr.x - DocView.this.start.x);
                        int yDiff = (int)Math.abs(curr.y - DocView.this.start.y);
                        if (xDiff >= 3 || yDiff >= 3) break;
                        DocView.this.performClick();
                        break;
                    }
                    case 6: {
                        DocView.this.mode = 0;
                    }
                }
                DocView.this.setImageMatrix(DocView.this.matrix);
                DocView.this.invalidate();
                return true;
            }
        });
    }

    void fixTrans() {
        this.matrix.getValues(this.m);
        float transX = this.m[2];
        float transY = this.m[5];
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.origWidth * this.saveScale);
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.origHeight * this.saveScale);
        if (fixTransX != 0.0f || fixTransY != 0.0f) {
            this.matrix.postTranslate(fixTransX, fixTransY);
        }
    }

    float getFixTrans(float trans, float viewSize, float contentSize) {
        float maxTrans;
        float minTrans;
        if (contentSize <= viewSize) {
            minTrans = 0.0f;
            maxTrans = viewSize - contentSize;
        } else {
            minTrans = viewSize - contentSize;
            maxTrans = 0.0f;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        if (trans > maxTrans) {
            return -trans + maxTrans;
        }
        return 0.0f;
    }

    public void setDocument(final File pdfFile) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Bitmap bitmap = DocUtils.getBitmapFromPdf(pdfFile.getAbsolutePath(), 0, false);
                    if (bitmap != null) {
                        DocView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                DocView.this.setImageBitmap(bitmap);
                                DocView.this.invalidate();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("run: " + pdfFile.getAbsolutePath()), (Throwable)e);
                }
            }
        });
    }

    float getFixDragTrans(float delta, float viewSize, float contentSize) {
        if (contentSize <= viewSize) {
            return 0.0f;
        }
        return delta;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.oldMeasuredHeight == this.viewWidth && this.oldMeasuredHeight == this.viewHeight || this.viewWidth == 0 || this.viewHeight == 0) {
            return;
        }
        this.oldMeasuredHeight = this.viewHeight;
        this.oldMeasuredWidth = this.viewWidth;
        if (this.saveScale == 1.0f) {
            Drawable drawable = this.getDrawable();
            if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
                return;
            }
            int bmWidth = drawable.getIntrinsicWidth();
            int bmHeight = drawable.getIntrinsicHeight();
            Log.d((String)"bmSize", (String)("bmWidth: " + bmWidth + " bmHeight : " + bmHeight));
            float scaleX = (float)this.viewWidth / (float)bmWidth;
            float scaleY = (float)this.viewHeight / (float)bmHeight;
            float scale = Math.min(scaleX, scaleY);
            this.matrix.setScale(scale, scale);
            float redundantYSpace = (float)this.viewHeight - scale * (float)bmHeight;
            float redundantXSpace = (float)this.viewWidth - scale * (float)bmWidth;
            this.matrix.postTranslate(redundantXSpace /= 2.0f, redundantYSpace /= 2.0f);
            this.origWidth = (float)this.viewWidth - 2.0f * redundantXSpace;
            this.origHeight = (float)this.viewHeight - 2.0f * redundantYSpace;
            this.setImageMatrix(this.matrix);
        }
        this.fixTrans();
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            DocView.this.mode = 2;
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mScaleFactor = detector.getScaleFactor();
            float origScale = DocView.this.saveScale;
            DocView.this.saveScale *= mScaleFactor;
            if (DocView.this.saveScale > DocView.this.maxScale) {
                DocView.this.saveScale = DocView.this.maxScale;
                mScaleFactor = DocView.this.maxScale / origScale;
            } else if (DocView.this.saveScale < DocView.this.minScale) {
                DocView.this.saveScale = DocView.this.minScale;
                mScaleFactor = DocView.this.minScale / origScale;
            }
            if (DocView.this.origWidth * DocView.this.saveScale <= (float)DocView.this.viewWidth || DocView.this.origHeight * DocView.this.saveScale <= (float)DocView.this.viewHeight) {
                DocView.this.matrix.postScale(mScaleFactor, mScaleFactor, (float)(DocView.this.viewWidth / 2), (float)(DocView.this.viewHeight / 2));
            } else {
                DocView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), detector.getFocusY());
            }
            DocView.this.fixTrans();
            return true;
        }
    }
}

