/*
 * Decompiled with CFR 0.152.
 */
package com.steve.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.pdf.PdfRenderer;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import java.io.File;

public class DocUtils {
    static Bitmap getBitmapFromPdf(String path, int page, boolean preview) throws Exception {
        if (Build.VERSION.SDK_INT >= 21) {
            ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)new File(path), (int)0x10000000);
            PdfRenderer renderer = new PdfRenderer(descriptor);
            PdfRenderer.Page p = renderer.openPage(page);
            int width = preview ? 320 : p.getWidth();
            int height = preview ? 240 : p.getHeight();
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            p.render(bitmap, null, null, 2);
            p.close();
            renderer.close();
            descriptor.close();
            return bitmap;
        }
        return Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static Bitmap getBitmapPreview(File file) throws Exception {
        return DocUtils.getBitmapFromPdf(file.getAbsolutePath(), 0, true);
    }
}

