/*
 * Decompiled with CFR 0.152.
 */
package com.steve.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import com.steve.view.R;

public class CircleProgressView
extends View {
    public static final String PERCENT = "%";
    private static final int DEFAULT_BACKGROUND_COLOR = -3355444;
    private static final int DEFAULT_FOREGROUND_COLOR = -12303292;
    private static final int DEFAULT_PROGRESS = 30;
    private static final int DEFAULT_PROGRESS_MAX = 100;
    private static final int DEFAULT_STROKE_WIDTH = 4;
    private static final int DEFAULT_TEXT_SIZE = 30;
    private int foregroundColor;
    private int backgroundColor;
    private int textColor;
    private int percentColor;
    private float mStrokeWidth;
    private float mTextSize;
    private boolean showText;
    private boolean fillBackground;
    private Paint mBackgroundPaint;
    private Paint mForegroundPaint;
    private TextPaint mTextPaint;
    private TextPaint mPercentPaint;
    private int mProgress;
    private int mMax;
    private RectF rectF;
    Rect r = new Rect();

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        this.backgroundColor = a.getColor(R.styleable.CircleProgressView_backgroundProgressColor, -3355444);
        this.foregroundColor = a.getColor(R.styleable.CircleProgressView_foregroundProgressColor, -12303292);
        this.textColor = a.getColor(R.styleable.CircleProgressView_textColor, this.foregroundColor);
        this.percentColor = a.getColor(R.styleable.CircleProgressView_percentColor, this.textColor);
        this.mProgress = a.getInteger(R.styleable.CircleProgressView_progress, 30);
        this.mMax = a.getInteger(R.styleable.CircleProgressView_max, 100);
        this.mTextSize = a.getDimension(R.styleable.CircleProgressView_textSize, 30.0f);
        this.mStrokeWidth = a.getInt(R.styleable.CircleProgressView_strokeWidth, 4);
        this.mStrokeWidth = this.convertDpToPixel(this.mStrokeWidth, context);
        this.showText = a.getBoolean(R.styleable.CircleProgressView_showText, false);
        this.fillBackground = a.getBoolean(R.styleable.CircleProgressView_fillBackground, false);
        a.recycle();
        this.rectF = new RectF();
        this.initPaints();
    }

    private float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        Log.e((String)"Utils", (String)("convertDpToPixel: " + metrics.density));
        Log.e((String)"Utils", (String)("convertDpToPixel: " + metrics.densityDpi));
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    private void initPaints() {
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(this.backgroundColor);
        this.mBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBackgroundPaint.setStrokeWidth(this.mStrokeWidth);
        this.mBackgroundPaint.setStyle(this.fillBackground ? Paint.Style.FILL_AND_STROKE : Paint.Style.STROKE);
        this.mForegroundPaint = new Paint(1);
        this.mForegroundPaint.setStyle(Paint.Style.STROKE);
        this.mForegroundPaint.setColor(this.foregroundColor);
        this.mForegroundPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mForegroundPaint.setStrokeWidth(this.mStrokeWidth);
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setStrokeWidth(1.0f);
        this.mTextPaint.setTypeface(Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)"fonts/Roboto-Thin.ttf"));
        this.mPercentPaint = new TextPaint(1);
        this.mPercentPaint.setStyle(Paint.Style.FILL);
        this.mPercentPaint.setStrokeWidth(1.0f);
        this.mPercentPaint.setTextSize(this.mTextSize / 3.0f);
        this.mPercentPaint.setColor(this.percentColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int defaultWidth = 100;
        int defaultHeight = 100;
        int widthSpec = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpec = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSpec : (widthMode == Integer.MIN_VALUE ? Math.min(widthSpec, defaultWidth) : defaultWidth);
        int height = heightMode == 0x40000000 ? heightSpec : (heightMode == Integer.MIN_VALUE ? Math.min(heightSpec, defaultHeight) : defaultHeight);
        int size = Math.min(width, height);
        this.setMeasuredDimension(size, size);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int middleStroke = (int)(this.mBackgroundPaint.getStrokeWidth() / 2.0f);
        this.rectF.set((float)middleStroke, (float)middleStroke, (float)(this.getWidth() - middleStroke), (float)(this.getHeight() - middleStroke));
        canvas.drawOval(this.rectF, this.mBackgroundPaint);
        float angle = 360 * this.mProgress / this.mMax;
        float startAngle = -90.0f;
        canvas.drawArc(this.rectF, startAngle, angle, false, this.mForegroundPaint);
        if (this.showText) {
            this.drawText(canvas, String.valueOf(this.mProgress));
        }
    }

    private void drawText(Canvas canvas, String text) {
        canvas.getClipBounds(this.r);
        int cHeight = this.r.height();
        int cWidth = this.r.width();
        this.mTextPaint.getTextBounds(text, 0, text.length(), this.r);
        float x = (float)cWidth / 2.0f - (float)this.r.width() / 2.0f - (float)this.r.left;
        int textHeight = this.r.height();
        float y = (float)cHeight / 2.0f + (float)textHeight / 2.0f - (float)this.r.bottom;
        canvas.drawText(text, x, y, (Paint)this.mTextPaint);
        this.mPercentPaint.getTextBounds(PERCENT, 0, PERCENT.length(), this.r);
        x = (float)cWidth / 2.0f - (float)this.r.width() / 2.0f - (float)this.r.left;
        y = (float)cHeight / 2.0f + (float)(textHeight / 2) + this.convertDpToPixel(20.0f, this.getContext());
        canvas.drawText(PERCENT, x, y, (Paint)this.mPercentPaint);
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(int foregroundColor) {
        if (this.foregroundColor == foregroundColor) {
            return;
        }
        this.foregroundColor = foregroundColor;
        this.invalidate();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor == this.backgroundColor) {
            return;
        }
        this.backgroundColor = backgroundColor;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        if (this.textColor == textColor) {
            return;
        }
        this.textColor = textColor;
        this.invalidate();
    }

    public int getPercentColor() {
        return this.percentColor;
    }

    public void setPercentColor(int percentColor) {
        if (this.percentColor == percentColor) {
            return;
        }
        this.percentColor = percentColor;
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(float mStrokeWidth) {
        if (this.mStrokeWidth == mStrokeWidth) {
            return;
        }
        this.mStrokeWidth = mStrokeWidth;
        this.invalidate();
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float mTextSize) {
        if (this.mTextSize == mTextSize) {
            return;
        }
        this.mTextSize = mTextSize;
        this.invalidate();
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int mProgress) {
        if (this.mProgress == mProgress) {
            return;
        }
        this.mProgress = mProgress;
        this.invalidate();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int mMax) {
        if (this.mMax == mMax) {
            return;
        }
        this.mMax = mMax;
        this.invalidate();
    }
}

