/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.Nullable;
import java.io.FileDescriptor;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.MediaList;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.HWDecoderUtil;
import org.videolan.libvlc.util.VLCUtil;

public class Media
extends VLCObject<Event> {
    private static final String TAG = "LibVLC/Media";
    private static final int PARSE_STATUS_INIT = 0;
    private static final int PARSE_STATUS_PARSING = 1;
    private static final int PARSE_STATUS_PARSED = 2;
    private final String[] mNativeMetas = new String[25];
    private Uri mUri = null;
    private MediaList mSubItems = null;
    private int mParseStatus = 0;
    private Track[] mNativeTracks = null;
    private long mDuration = -1L;
    private int mState = -1;
    private int mType = -1;
    private boolean mCodecOptionSet = false;
    private boolean mFileCachingSet = false;
    private boolean mNetworkCachingSet = false;

    public Media(LibVLC libVLC, String path) {
        super(libVLC);
        this.nativeNewFromPath(libVLC, path);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    public Media(LibVLC libVLC, Uri uri) {
        super(libVLC);
        this.nativeNewFromLocation(libVLC, VLCUtil.encodeVLCUri(uri));
        this.mUri = uri;
    }

    public Media(LibVLC libVLC, FileDescriptor fd) {
        super(libVLC);
        this.nativeNewFromFd(libVLC, fd);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    public Media(LibVLC libVLC, AssetFileDescriptor afd) {
        super(libVLC);
        long offset = afd.getStartOffset();
        long length = afd.getLength();
        this.nativeNewFromFdWithOffsetLength(libVLC, afd.getFileDescriptor(), offset, length);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    protected Media(MediaList ml, int index) {
        super(ml);
        if (ml == null || ml.isReleased()) {
            throw new IllegalArgumentException("MediaList is null or released");
        }
        if (!ml.isLocked()) {
            throw new IllegalStateException("MediaList should be locked");
        }
        this.nativeNewFromMediaList(ml, index);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    private static Track createAudioTrackFromNative(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, int channels, int rate) {
        return new AudioTrack(codec, originalCodec, id, profile, level, bitrate, language, description, channels, rate);
    }

    private static Track createVideoTrackFromNative(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, int height, int width, int sarNum, int sarDen, int frameRateNum, int frameRateDen, int orientation, int projection) {
        return new VideoTrack(codec, originalCodec, id, profile, level, bitrate, language, description, height, width, sarNum, sarDen, frameRateNum, frameRateDen, orientation, projection);
    }

    private static Track createSubtitleTrackFromNative(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, String encoding) {
        return new SubtitleTrack(codec, originalCodec, id, profile, level, bitrate, language, description, encoding);
    }

    private static Track createUnknownTrackFromNative(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description) {
        return new UnknownTrack(codec, originalCodec, id, profile, level, bitrate, language, description);
    }

    private static Slave createSlaveFromNative(int type, int priority, String uri) {
        return new Slave(type, priority, uri);
    }

    private static Stats createStatsFromNative(int readBytes, float inputBitrate, int demuxReadBytes, float demuxBitrates, int demuxCorrupted, int demuxDiscontinuity, int decodedVideo, int decodedAudio, int displayedPictures, int lostPictures, int playedAbuffers, int lostAbuffers, int sentPackets, int sentBytes, float sendBitrate) {
        return new Stats(readBytes, inputBitrate, demuxReadBytes, demuxBitrates, demuxCorrupted, demuxDiscontinuity, decodedVideo, decodedAudio, displayedPictures, lostPictures, playedAbuffers, lostAbuffers, sentPackets, sentBytes, sendBitrate);
    }

    private static String getMediaCodecModule() {
        return AndroidUtil.isLolliPopOrLater ? "mediacodec_ndk" : "mediacodec_jni";
    }

    public void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected synchronized Event onEventNative(int eventType, long arg1, long arg2, float argf1) {
        switch (eventType) {
            case 0: {
                int id = (int)arg1;
                if (id >= 0 && id < 25) {
                    this.mNativeMetas[id] = null;
                }
                return new Event(eventType, arg1);
            }
            case 2: {
                this.mDuration = -1L;
                break;
            }
            case 3: {
                this.postParse();
                return new Event(eventType, arg1);
            }
            case 5: {
                this.mState = -1;
            }
        }
        return new Event(eventType);
    }

    public synchronized Uri getUri() {
        return this.mUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Media media = this;
        synchronized (media) {
            if (this.mDuration != -1L) {
                return this.mDuration;
            }
            if (this.isReleased()) {
                return 0L;
            }
        }
        long duration = this.nativeGetDuration();
        Media media2 = this;
        synchronized (media2) {
            this.mDuration = duration;
            return this.mDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Media media = this;
        synchronized (media) {
            if (this.mState != -1) {
                return this.mState;
            }
            if (this.isReleased()) {
                return 7;
            }
        }
        int state = this.nativeGetState();
        Media media2 = this;
        synchronized (media2) {
            this.mState = state;
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaList subItems() {
        Media media = this;
        synchronized (media) {
            if (this.mSubItems != null) {
                this.mSubItems.retain();
                return this.mSubItems;
            }
        }
        MediaList subItems = new MediaList(this);
        Media media2 = this;
        synchronized (media2) {
            this.mSubItems = subItems;
            this.mSubItems.retain();
            return this.mSubItems;
        }
    }

    private synchronized void postParse() {
        if ((this.mParseStatus & 2) != 0) {
            return;
        }
        this.mParseStatus &= 0xFFFFFFFE;
        this.mParseStatus |= 2;
        this.mNativeTracks = null;
        this.mDuration = -1L;
        this.mState = -1;
        this.mType = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(int flags) {
        boolean parse = false;
        Media media = this;
        synchronized (media) {
            if ((this.mParseStatus & 3) == 0) {
                this.mParseStatus |= 1;
                parse = true;
            }
        }
        if (parse && this.nativeParse(flags)) {
            this.postParse();
            return true;
        }
        return false;
    }

    public boolean parse() {
        return this.parse(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseAsync(int flags, int timeout) {
        boolean parse = false;
        Media media = this;
        synchronized (media) {
            if ((this.mParseStatus & 3) == 0) {
                this.mParseStatus |= 1;
                parse = true;
            }
        }
        return parse && this.nativeParseAsync(flags, timeout);
    }

    public boolean parseAsync(int flags) {
        return this.parseAsync(flags, -1);
    }

    public boolean parseAsync() {
        return this.parseAsync(2);
    }

    public synchronized boolean isParsed() {
        return (this.mParseStatus & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() {
        Media media = this;
        synchronized (media) {
            if (this.mType != -1) {
                return this.mType;
            }
            if (this.isReleased()) {
                return 0;
            }
        }
        int type = this.nativeGetType();
        Media media2 = this;
        synchronized (media2) {
            this.mType = type;
            return this.mType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Track[] getTracks() {
        Media media = this;
        synchronized (media) {
            if (this.mNativeTracks != null) {
                return this.mNativeTracks;
            }
            if (this.isReleased()) {
                return null;
            }
        }
        Track[] tracks = this.nativeGetTracks();
        Media media2 = this;
        synchronized (media2) {
            this.mNativeTracks = tracks;
            return this.mNativeTracks;
        }
    }

    public int getTrackCount() {
        Track[] tracks = this.getTracks();
        return tracks != null ? tracks.length : 0;
    }

    public Track getTrack(int idx) {
        Track[] tracks = this.getTracks();
        if (tracks == null || idx < 0 || idx >= tracks.length) {
            return null;
        }
        return tracks[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMeta(int id) {
        if (id < 0 || id >= 25) {
            return null;
        }
        Media media = this;
        synchronized (media) {
            if (this.mNativeMetas[id] != null) {
                return this.mNativeMetas[id];
            }
            if (this.isReleased()) {
                return null;
            }
        }
        String meta = this.nativeGetMeta(id);
        Media media2 = this;
        synchronized (media2) {
            this.mNativeMetas[id] = meta;
            return meta;
        }
    }

    public void setHWDecoderEnabled(boolean enabled, boolean force) {
        HWDecoderUtil.Decoder decoder;
        HWDecoderUtil.Decoder decoder2 = decoder = enabled ? HWDecoderUtil.getDecoderFromDevice() : HWDecoderUtil.Decoder.NONE;
        if (decoder == HWDecoderUtil.Decoder.UNKNOWN && force) {
            decoder = HWDecoderUtil.Decoder.ALL;
        }
        if (decoder == HWDecoderUtil.Decoder.NONE || decoder == HWDecoderUtil.Decoder.UNKNOWN) {
            this.addOption(":codec=all");
            return;
        }
        if (!this.mFileCachingSet) {
            this.addOption(":file-caching=1500");
        }
        if (!this.mNetworkCachingSet) {
            this.addOption(":network-caching=1500");
        }
        StringBuilder sb = new StringBuilder(":codec=");
        if (decoder == HWDecoderUtil.Decoder.MEDIACODEC || decoder == HWDecoderUtil.Decoder.ALL) {
            sb.append(Media.getMediaCodecModule()).append(",");
        }
        if (force && (decoder == HWDecoderUtil.Decoder.OMX || decoder == HWDecoderUtil.Decoder.ALL)) {
            sb.append("iomx,");
        }
        sb.append("all");
        this.addOption(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultMediaPlayerOptions() {
        boolean codecOptionSet;
        Media media = this;
        synchronized (media) {
            codecOptionSet = this.mCodecOptionSet;
            this.mCodecOptionSet = true;
        }
        if (!codecOptionSet) {
            this.setHWDecoderEnabled(true, false);
        }
        if (this.mUri != null && this.mUri.getScheme() != null && !this.mUri.getScheme().equalsIgnoreCase("file") && this.mUri.getLastPathSegment() != null && this.mUri.getLastPathSegment().toLowerCase().endsWith(".iso")) {
            this.addOption(":demux=dvdnav,any");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(String option) {
        Media media = this;
        synchronized (media) {
            if (!this.mCodecOptionSet && option.startsWith(":codec=")) {
                this.mCodecOptionSet = true;
            }
            if (!this.mNetworkCachingSet && option.startsWith(":network-caching=")) {
                this.mNetworkCachingSet = true;
            }
            if (!this.mFileCachingSet && option.startsWith(":file-caching=")) {
                this.mFileCachingSet = true;
            }
        }
        this.nativeAddOption(option);
    }

    public void addSlave(Slave slave) {
        this.nativeAddSlave(slave.type, slave.priority, slave.uri);
    }

    public void clearSlaves() {
        this.nativeClearSlaves();
    }

    @Nullable
    public Slave[] getSlaves() {
        return this.nativeGetSlaves();
    }

    @Nullable
    public Stats getStats() {
        return this.nativeGetStats();
    }

    @Override
    protected void onReleaseNative() {
        if (this.mSubItems != null) {
            this.mSubItems.release();
        }
        this.nativeRelease();
    }

    private native void nativeNewFromPath(LibVLC var1, String var2);

    private native void nativeNewFromLocation(LibVLC var1, String var2);

    private native void nativeNewFromFd(LibVLC var1, FileDescriptor var2);

    private native void nativeNewFromFdWithOffsetLength(LibVLC var1, FileDescriptor var2, long var3, long var5);

    private native void nativeNewFromMediaList(MediaList var1, int var2);

    private native void nativeRelease();

    private native boolean nativeParseAsync(int var1, int var2);

    private native boolean nativeParse(int var1);

    private native String nativeGetMrl();

    private native int nativeGetState();

    private native String nativeGetMeta(int var1);

    private native Track[] nativeGetTracks();

    private native long nativeGetDuration();

    private native int nativeGetType();

    private native void nativeAddOption(String var1);

    private native void nativeAddSlave(int var1, int var2, String var3);

    private native void nativeClearSlaves();

    private native Slave[] nativeGetSlaves();

    private native Stats nativeGetStats();

    public static class Stats {
        public final int readBytes;
        public final float inputBitrate;
        public final int demuxReadBytes;
        public final float demuxBitrate;
        public final int demuxCorrupted;
        public final int demuxDiscontinuity;
        public final int decodedVideo;
        public final int decodedAudio;
        public final int displayedPictures;
        public final int lostPictures;
        public final int playedAbuffers;
        public final int lostAbuffers;
        public final int sentPackets;
        public final int sentBytes;
        public final float sendBitrate;

        public Stats(int readBytes, float inputBitrate, int demuxReadBytes, float demuxBitrate, int demuxCorrupted, int demuxDiscontinuity, int decodedVideo, int decodedAudio, int displayedPictures, int lostPictures, int playedAbuffers, int lostAbuffers, int sentPackets, int sentBytes, float sendBitrate) {
            this.readBytes = readBytes;
            this.inputBitrate = inputBitrate;
            this.demuxReadBytes = demuxReadBytes;
            this.demuxBitrate = demuxBitrate;
            this.demuxCorrupted = demuxCorrupted;
            this.demuxDiscontinuity = demuxDiscontinuity;
            this.decodedVideo = decodedVideo;
            this.decodedAudio = decodedAudio;
            this.displayedPictures = displayedPictures;
            this.lostPictures = lostPictures;
            this.playedAbuffers = playedAbuffers;
            this.lostAbuffers = lostAbuffers;
            this.sentPackets = sentPackets;
            this.sentBytes = sentBytes;
            this.sendBitrate = sendBitrate;
        }
    }

    public static class Slave {
        public final int type;
        public final int priority;
        public final String uri;

        public Slave(int type, int priority, String uri) {
            this.type = type;
            this.priority = priority;
            this.uri = uri;
        }

        public static class Type {
            public static final int Subtitle = 0;
            public static final int Audio = 1;
        }
    }

    public static class UnknownTrack
    extends Track {
        private UnknownTrack(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description) {
            super(-1, codec, originalCodec, id, profile, level, bitrate, language, description);
        }
    }

    public static class SubtitleTrack
    extends Track {
        public final String encoding;

        private SubtitleTrack(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, String encoding) {
            super(2, codec, originalCodec, id, profile, level, bitrate, language, description);
            this.encoding = encoding;
        }
    }

    public static class VideoTrack
    extends Track {
        public final int height;
        public final int width;
        public final int sarNum;
        public final int sarDen;
        public final int frameRateNum;
        public final int frameRateDen;
        public final int orientation;
        public final int projection;

        private VideoTrack(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, int height, int width, int sarNum, int sarDen, int frameRateNum, int frameRateDen, int orientation, int projection) {
            super(1, codec, originalCodec, id, profile, level, bitrate, language, description);
            this.height = height;
            this.width = width;
            this.sarNum = sarNum;
            this.sarDen = sarDen;
            this.frameRateNum = frameRateNum;
            this.frameRateDen = frameRateDen;
            this.orientation = orientation;
            this.projection = projection;
        }

        public static final class Projection {
            public static final int Rectangular = 0;
            public static final int EquiRectangular = 1;
            public static final int CubemapLayoutStandard = 256;
        }

        public static final class Orientation {
            public static final int TopLeft = 0;
            public static final int TopRight = 1;
            public static final int BottomLeft = 2;
            public static final int BottomRight = 3;
            public static final int LeftTop = 4;
            public static final int LeftBottom = 5;
            public static final int RightTop = 6;
            public static final int RightBottom = 7;
        }
    }

    public static class AudioTrack
    extends Track {
        public final int channels;
        public final int rate;

        private AudioTrack(String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description, int channels, int rate) {
            super(0, codec, originalCodec, id, profile, level, bitrate, language, description);
            this.channels = channels;
            this.rate = rate;
        }
    }

    public static abstract class Track {
        public final int type;
        public final String codec;
        public final String originalCodec;
        public final int id;
        public final int profile;
        public final int level;
        public final int bitrate;
        public final String language;
        public final String description;

        private Track(int type, String codec, String originalCodec, int id, int profile, int level, int bitrate, String language, String description) {
            this.type = type;
            this.codec = codec;
            this.originalCodec = originalCodec;
            this.id = id;
            this.profile = profile;
            this.level = level;
            this.bitrate = bitrate;
            this.language = language;
            this.description = description;
        }

        public static class Type {
            public static final int Unknown = -1;
            public static final int Audio = 0;
            public static final int Video = 1;
            public static final int Text = 2;
        }
    }

    public static class ParsedStatus {
        public static final int Skipped = 1;
        public static final int Failed = 2;
        public static final int Timeout = 3;
        public static final int Done = 4;
    }

    public static class Parse {
        public static final int ParseLocal = 0;
        public static final int ParseNetwork = 1;
        public static final int FetchLocal = 2;
        public static final int FetchNetwork = 4;
        public static final int DoInteract = 8;
    }

    public static class State {
        public static final int NothingSpecial = 0;
        public static final int Opening = 1;
        public static final int Playing = 3;
        public static final int Paused = 4;
        public static final int Stopped = 5;
        public static final int Ended = 6;
        public static final int Error = 7;
        public static final int MAX = 8;
    }

    public static class Meta {
        public static final int Title = 0;
        public static final int Artist = 1;
        public static final int Genre = 2;
        public static final int Copyright = 3;
        public static final int Album = 4;
        public static final int TrackNumber = 5;
        public static final int Description = 6;
        public static final int Rating = 7;
        public static final int Date = 8;
        public static final int Setting = 9;
        public static final int URL = 10;
        public static final int Language = 11;
        public static final int NowPlaying = 12;
        public static final int Publisher = 13;
        public static final int EncodedBy = 14;
        public static final int ArtworkURL = 15;
        public static final int TrackID = 16;
        public static final int TrackTotal = 17;
        public static final int Director = 18;
        public static final int Season = 19;
        public static final int Episode = 20;
        public static final int ShowName = 21;
        public static final int Actors = 22;
        public static final int AlbumArtist = 23;
        public static final int DiscNumber = 24;
        public static final int MAX = 25;
    }

    public static class Type {
        public static final int Unknown = 0;
        public static final int File = 1;
        public static final int Directory = 2;
        public static final int Disc = 3;
        public static final int Stream = 4;
        public static final int Playlist = 5;
    }

    public static class Event
    extends VLCEvent {
        public static final int MetaChanged = 0;
        public static final int SubItemAdded = 1;
        public static final int DurationChanged = 2;
        public static final int ParsedChanged = 3;
        public static final int StateChanged = 5;
        public static final int SubItemTreeAdded = 6;

        protected Event(int type) {
            super(type);
        }

        protected Event(int type, long arg1) {
            super(type, arg1);
        }

        public int getMetaId() {
            return (int)this.arg1;
        }

        public int getParsedStatus() {
            return (int)this.arg1;
        }
    }

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }
}

