/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.HWDecoderUtil;

public class LibVLC
extends VLCObject<Event> {
    private static final String TAG = "VLC/LibVLC";
    private static boolean sLoaded = false;
    final Context mAppContext;

    public LibVLC(Context context, ArrayList<String> options) {
        this.mAppContext = context.getApplicationContext();
        LibVLC.loadLibraries();
        if (options == null) {
            options = new ArrayList();
        }
        boolean setAout = true;
        boolean setChroma = true;
        for (String option : options) {
            if (option.startsWith("--aout=")) {
                setAout = false;
            }
            if (option.startsWith("--android-display-chroma")) {
                setChroma = false;
            }
            if (setAout || setChroma) continue;
            break;
        }
        if (setAout || setChroma) {
            if (setAout) {
                HWDecoderUtil.AudioOutput hwAout = HWDecoderUtil.getAudioOutputFromDevice();
                if (hwAout == HWDecoderUtil.AudioOutput.OPENSLES) {
                    options.add("--aout=opensles");
                } else {
                    options.add("--aout=android_audiotrack");
                }
            }
            if (setChroma) {
                options.add("--android-display-chroma");
                options.add("RV16");
            }
        }
        if (!AndroidUtil.isHoneycombOrLater) {
            boolean setVout = true;
            for (String option : options) {
                if (!option.startsWith("--vout")) continue;
                setVout = false;
                break;
            }
            if (setVout) {
                options.add("--vout=android_display,none");
            }
        }
        this.nativeNew(options.toArray(new String[options.size()]), context.getDir("vlc", 0).getAbsolutePath());
    }

    public LibVLC(Context context) {
        this(context, null);
    }

    static synchronized void loadLibraries() {
        block26: {
            if (sLoaded) {
                return;
            }
            sLoaded = true;
            System.loadLibrary("c++_shared");
            if (Build.VERSION.SDK_INT >= 10 && Build.VERSION.SDK_INT < 23) {
                try {
                    if (Build.VERSION.SDK_INT <= 12) {
                        System.loadLibrary("anw.10");
                    } else if (Build.VERSION.SDK_INT <= 13) {
                        System.loadLibrary("anw.13");
                    } else if (Build.VERSION.SDK_INT <= 17) {
                        System.loadLibrary("anw.14");
                    } else if (Build.VERSION.SDK_INT <= 20) {
                        System.loadLibrary("anw.18");
                    } else {
                        System.loadLibrary("anw.21");
                    }
                }
                catch (Throwable t) {
                    Log.d((String)TAG, (String)"anw library not loaded");
                }
                try {
                    if (Build.VERSION.SDK_INT <= 10) {
                        System.loadLibrary("iomx.10");
                    } else if (Build.VERSION.SDK_INT <= 13) {
                        System.loadLibrary("iomx.13");
                    } else if (Build.VERSION.SDK_INT <= 17) {
                        System.loadLibrary("iomx.14");
                    } else if (Build.VERSION.SDK_INT <= 18) {
                        System.loadLibrary("iomx.18");
                    } else if (Build.VERSION.SDK_INT <= 19) {
                        System.loadLibrary("iomx.19");
                    }
                }
                catch (Throwable t) {
                    if (Build.VERSION.SDK_INT > 15) break block26;
                    Log.w((String)TAG, (String)("Unable to load the iomx library: " + t));
                }
            }
        }
        try {
            System.loadLibrary("vlc");
            System.loadLibrary("vlcjni");
        }
        catch (UnsatisfiedLinkError ule) {
            Log.e((String)TAG, (String)("Can't load vlcjni library: " + ule));
            System.exit(1);
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)("Encountered a security issue when loading vlcjni library: " + se));
            System.exit(1);
        }
    }

    public native String version();

    public native String compiler();

    public native String changeset();

    @Override
    protected Event onEventNative(int eventType, long arg1, long arg2, float argf1) {
        return null;
    }

    @Override
    protected void onReleaseNative() {
        this.nativeRelease();
    }

    public void setUserAgent(String name, String http) {
        this.nativeSetUserAgent(name, http);
    }

    private native void nativeNew(String[] var1, String var2);

    private native void nativeRelease();

    private native void nativeSetUserAgent(String var1, String var2);

    public static class Event
    extends VLCEvent {
        protected Event(int type) {
            super(type);
        }
    }
}

