/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.util.AndroidUtil;

public class VLCUtil {
    public static final String TAG = "VLC/LibVLC/Util";
    private static String errorMsg = null;
    private static boolean isCompatible = false;
    private static MachineSpecs machineSpecs = null;
    private static final int EM_386 = 3;
    private static final int EM_MIPS = 8;
    private static final int EM_ARM = 40;
    private static final int EM_X86_64 = 62;
    private static final int EM_AARCH64 = 183;
    private static final int ELF_HEADER_SIZE = 52;
    private static final int SECTION_HEADER_SIZE = 40;
    private static final int SHT_ARM_ATTRIBUTES = 0x70000003;
    private static final String[] CPU_archs = new String[]{"*Pre-v4", "*v4", "*v4T", "v5T", "v5TE", "v5TEJ", "v6", "v6KZ", "v6T2", "v6K", "v7", "*v6-M", "*v6S-M", "*v7E-M", "*v8"};

    public static String getErrorMsg() {
        return errorMsg;
    }

    @TargetApi(value=21)
    public static String[] getABIList21() {
        String[] abis = Build.SUPPORTED_ABIS;
        if (abis == null || abis.length == 0) {
            return VLCUtil.getABIList();
        }
        return abis;
    }

    @TargetApi(value=8)
    public static String[] getABIList() {
        boolean hasABI2 = Build.VERSION.SDK_INT >= 8;
        String[] abis = new String[hasABI2 ? 2 : 1];
        abis[0] = Build.CPU_ABI;
        if (hasABI2) {
            abis[1] = Build.CPU_ABI2;
        }
        return abis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCompatibleCPU(Context context) {
        if (errorMsg != null || isCompatible) {
            return isCompatible;
        }
        File lib = VLCUtil.searchLibrary(context.getApplicationInfo());
        if (lib == null) {
            return true;
        }
        ElfData elf = VLCUtil.readLib(lib);
        if (elf == null) {
            Log.e((String)TAG, (String)"WARNING: Unable to read libvlcjni.so; cannot check device ABI!");
            Log.e((String)TAG, (String)"WARNING: Cannot guarantee correct ABI for this build (may crash)!");
            return true;
        }
        String[] abis = Build.VERSION.SDK_INT >= 21 ? VLCUtil.getABIList21() : VLCUtil.getABIList();
        boolean elfHasX86 = elf.e_machine == 3 || elf.e_machine == 62;
        boolean elfHasArm = elf.e_machine == 40 || elf.e_machine == 183;
        boolean elfHasMips = elf.e_machine == 8;
        boolean elfIs64bits = elf.is64bits;
        Log.i((String)TAG, (String)("ELF ABI = " + (elfHasArm ? "arm" : (elfHasX86 ? "x86" : "mips")) + ", " + (elfIs64bits ? "64bits" : "32bits")));
        Log.i((String)TAG, (String)("ELF arch = " + elf.att_arch));
        Log.i((String)TAG, (String)("ELF fpu = " + elf.att_fpu));
        boolean hasNeon = false;
        boolean hasFpu = false;
        boolean hasArmV6 = false;
        boolean hasArmV7 = false;
        boolean hasMips = false;
        boolean hasX86 = false;
        boolean is64bits = false;
        float bogoMIPS = -1.0f;
        int processors = 0;
        for (String abi : abis) {
            if (abi.equals("x86")) {
                Log.e((String)TAG, (String)"is X86");
                hasX86 = true;
                continue;
            }
            if (abi.equals("x86_64")) {
                hasX86 = true;
                is64bits = true;
                continue;
            }
            if (abi.equals("armeabi-v7a")) {
                Log.e((String)TAG, (String)"is ARMV7");
                hasArmV7 = true;
                hasArmV6 = true;
                continue;
            }
            if (abi.equals("armeabi")) {
                hasArmV6 = true;
                continue;
            }
            if (!abi.equals("arm64-v8a")) continue;
            hasNeon = true;
            hasArmV6 = true;
            hasArmV7 = true;
            is64bits = true;
        }
        FileReader fileReader = null;
        BufferedReader br = null;
        try {
            String line;
            fileReader = new FileReader("/proc/cpuinfo");
            br = new BufferedReader(fileReader);
            while ((line = br.readLine()) != null) {
                if (!hasArmV7 && line.contains("AArch64")) {
                    hasArmV7 = true;
                    hasArmV6 = true;
                }
                if (!hasArmV7 && line.contains("ARMv7")) {
                    hasArmV7 = true;
                    hasArmV6 = true;
                }
                if (!hasArmV7 && !hasArmV6 && line.contains("ARMv6")) {
                    hasArmV6 = true;
                }
                if (line.contains("clflush size")) {
                    hasX86 = true;
                }
                if (line.contains("GenuineIntel")) {
                    hasX86 = true;
                }
                if (line.contains("microsecond timers")) {
                    hasMips = true;
                }
                if (!hasNeon && (line.contains("neon") || line.contains("asimd"))) {
                    hasNeon = true;
                }
                if (!hasFpu && (line.contains("vfp") || line.contains("Features") && line.contains("fp"))) {
                    hasFpu = true;
                }
                if (line.startsWith("processor")) {
                    ++processors;
                }
                if (!(bogoMIPS < 0.0f) || !line.toLowerCase(Locale.ENGLISH).contains("bogomips")) continue;
                String[] bogo_parts = line.split(":");
                try {
                    bogoMIPS = Float.parseFloat(bogo_parts[1].trim());
                }
                catch (NumberFormatException e) {
                    bogoMIPS = -1.0f;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            errorMsg = "IOException whilst reading cpuinfo flags";
            isCompatible = false;
            boolean bogo_parts = false;
            return bogo_parts;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
        if (processors == 0) {
            processors = 1;
        }
        if (elfHasX86 && !hasX86) {
            errorMsg = "x86 build on non-x86 device";
            isCompatible = false;
            return false;
        }
        if (elfHasArm && !hasArmV6) {
            errorMsg = "ARM build on non ARM device";
            isCompatible = false;
            return false;
        }
        if (elfHasMips && !hasMips) {
            errorMsg = "MIPS build on non-MIPS device";
            isCompatible = false;
            return false;
        }
        if (elfHasArm && hasMips) {
            errorMsg = "ARM build on MIPS device";
            isCompatible = false;
            return false;
        }
        if (elf.e_machine == 40 && elf.att_arch.startsWith("v7") && !hasArmV7) {
            errorMsg = "ARMv7 build on non-ARMv7 device";
            isCompatible = false;
            return false;
        }
        if (elf.e_machine == 40) {
            if (elf.att_arch.startsWith("v6") && !hasArmV6) {
                errorMsg = "ARMv6 build on non-ARMv6 device";
                isCompatible = false;
                return false;
            }
            if (elf.att_fpu && !hasFpu) {
                errorMsg = "FPU-enabled build on non-FPU device";
                isCompatible = false;
                return false;
            }
        }
        if (elfIs64bits && !is64bits) {
            errorMsg = "64bits build on 32bits device";
            isCompatible = false;
        }
        float frequency = -1.0f;
        fileReader = null;
        br = null;
        String line = "";
        try {
            fileReader = new FileReader("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq");
            br = new BufferedReader(fileReader);
            line = br.readLine();
            if (line != null) {
                frequency = Float.parseFloat(line) / 1000.0f;
            }
        }
        catch (IOException ex) {
            Log.w((String)TAG, (String)"Could not find maximum CPU frequency!");
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)"Could not parse maximum CPU frequency!");
            Log.w((String)TAG, (String)("Failed to parse: " + line));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ex) {}
            }
        }
        errorMsg = null;
        isCompatible = true;
        machineSpecs = new MachineSpecs();
        VLCUtil.machineSpecs.hasArmV6 = hasArmV6;
        VLCUtil.machineSpecs.hasArmV7 = hasArmV7;
        VLCUtil.machineSpecs.hasFpu = hasFpu;
        VLCUtil.machineSpecs.hasMips = hasMips;
        VLCUtil.machineSpecs.hasNeon = hasNeon;
        VLCUtil.machineSpecs.hasX86 = hasX86;
        VLCUtil.machineSpecs.is64bits = is64bits;
        VLCUtil.machineSpecs.bogoMIPS = bogoMIPS;
        VLCUtil.machineSpecs.processors = processors;
        VLCUtil.machineSpecs.frequency = frequency;
        return true;
    }

    public static MachineSpecs getMachineSpecs() {
        return machineSpecs;
    }

    @TargetApi(value=9)
    private static File searchLibrary(ApplicationInfo applicationInfo) {
        String[] libraryPaths;
        if ((applicationInfo.flags & 1) != 0) {
            String property = System.getProperty("java.library.path");
            libraryPaths = property.split(":");
        } else {
            libraryPaths = new String[]{AndroidUtil.isGingerbreadOrLater() ? applicationInfo.nativeLibraryDir : applicationInfo.dataDir + "/lib"};
        }
        if (libraryPaths[0] == null) {
            Log.e((String)TAG, (String)"can't find library path");
            return null;
        }
        for (String libraryPath : libraryPaths) {
            File lib = new File(libraryPath, "libvlcjni.so");
            if (!lib.exists() || !lib.canRead()) continue;
            return lib;
        }
        Log.e((String)TAG, (String)"WARNING: Can't find shared library");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ElfData readLib(File file) {
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(file, "r");
            ElfData elf = new ElfData();
            if (!VLCUtil.readHeader(in, elf)) {
                ElfData elfData = null;
                return elfData;
            }
            switch (elf.e_machine) {
                case 3: 
                case 8: 
                case 62: 
                case 183: {
                    ElfData elfData = elf;
                    return elfData;
                }
                case 40: {
                    in.close();
                    in = new RandomAccessFile(file, "r");
                    if (!VLCUtil.readSection(in, elf)) {
                        ElfData elfData = null;
                        return elfData;
                    }
                    in.close();
                    in = new RandomAccessFile(file, "r");
                    if (VLCUtil.readArmAttributes(in, elf)) break;
                    ElfData elfData = null;
                    return elfData;
                }
                default: {
                    ElfData elfData = null;
                    return elfData;
                }
            }
            ElfData elfData = elf;
            return elfData;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static boolean readHeader(RandomAccessFile in, ElfData elf) throws IOException {
        byte[] bytes = new byte[52];
        in.readFully(bytes);
        if (bytes[0] != 127 || bytes[1] != 69 || bytes[2] != 76 || bytes[3] != 70 || bytes[4] != 1 && bytes[4] != 2) {
            Log.e((String)TAG, (String)"ELF header invalid");
            return false;
        }
        elf.is64bits = bytes[4] == 2;
        elf.order = bytes[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(elf.order);
        elf.e_machine = buffer.getShort(18);
        elf.e_shoff = buffer.getInt(32);
        elf.e_shnum = buffer.getShort(48);
        return true;
    }

    private static boolean readSection(RandomAccessFile in, ElfData elf) throws IOException {
        byte[] bytes = new byte[40];
        in.seek(elf.e_shoff);
        for (int i = 0; i < elf.e_shnum; ++i) {
            in.readFully(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(elf.order);
            int sh_type = buffer.getInt(4);
            if (sh_type != 0x70000003) continue;
            elf.sh_offset = buffer.getInt(16);
            elf.sh_size = buffer.getInt(20);
            return true;
        }
        return false;
    }

    private static boolean readArmAttributes(RandomAccessFile in, ElfData elf) throws IOException {
        byte[] bytes = new byte[elf.sh_size];
        in.seek(elf.sh_offset);
        in.readFully(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(elf.order);
        if (buffer.get() != 65) {
            return false;
        }
        while (buffer.remaining() > 0) {
            int start_section = buffer.position();
            int length = buffer.getInt();
            String vendor = VLCUtil.getString(buffer);
            if (!vendor.equals("aeabi")) continue;
            while (buffer.position() < start_section + length) {
                int start = buffer.position();
                int tag = buffer.get();
                int size = buffer.getInt();
                if (tag != 1) {
                    buffer.position(start + size);
                    continue;
                }
                while (buffer.position() < start + size) {
                    tag = VLCUtil.getUleb128(buffer);
                    if (tag == 6) {
                        int arch = VLCUtil.getUleb128(buffer);
                        elf.att_arch = CPU_archs[arch];
                        continue;
                    }
                    if (tag == 27) {
                        VLCUtil.getUleb128(buffer);
                        elf.att_fpu = true;
                        continue;
                    }
                    if ((tag %= 128) == 4 || tag == 5 || tag == 32 || tag > 32 && (tag & 1) != 0) {
                        VLCUtil.getString(buffer);
                        continue;
                    }
                    VLCUtil.getUleb128(buffer);
                }
            }
            break block0;
        }
        return true;
    }

    private static String getString(ByteBuffer buffer) {
        char c;
        StringBuilder sb = new StringBuilder(buffer.limit());
        while (buffer.remaining() > 0 && (c = (char)buffer.get()) != '\u0000') {
            sb.append(c);
        }
        return sb.toString();
    }

    private static int getUleb128(ByteBuffer buffer) {
        byte c;
        int ret = 0;
        do {
            ret <<= 7;
            c = buffer.get();
            ret |= c & 0x7F;
        } while ((c & 0x80) > 0);
        return ret;
    }

    public static byte[] getThumbnail(LibVLC libVLC, Uri uri, int i_width, int i_height) {
        if (uri.getLastPathSegment().endsWith(".iso")) {
            uri = Uri.parse((String)("dvdsimple://" + uri.getEncodedPath()));
        }
        Media media = new Media(libVLC, uri);
        byte[] bytes = VLCUtil.getThumbnail(media, i_width, i_height);
        media.release();
        return bytes;
    }

    public static byte[] getThumbnail(Media media, int i_width, int i_height) {
        media.addOption(":no-audio");
        media.addOption(":no-spu");
        media.addOption(":no-osd");
        media.addOption(":input-fast-seek");
        return VLCUtil.nativeGetThumbnail(media, i_width, i_height);
    }

    private static native byte[] nativeGetThumbnail(Media var0, int var1, int var2);

    private static class ElfData {
        ByteOrder order;
        boolean is64bits;
        int e_machine;
        int e_shoff;
        int e_shnum;
        int sh_offset;
        int sh_size;
        String att_arch;
        boolean att_fpu;

        private ElfData() {
        }
    }

    public static class MachineSpecs {
        public boolean hasNeon;
        public boolean hasFpu;
        public boolean hasArmV6;
        public boolean hasArmV7;
        public boolean hasMips;
        public boolean hasX86;
        public boolean is64bits;
        public float bogoMIPS;
        public int processors;
        public float frequency;
    }
}

