/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.net.Uri;
import java.io.File;
import org.videolan.libvlc.AWindow;
import org.videolan.libvlc.AWindowNativeHandler;
import org.videolan.libvlc.IVLCVout;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;

public class MediaPlayer
extends VLCObject<Event> {
    private Media mMedia = null;
    private boolean mPlaying = false;
    private boolean mPlayRequested = false;
    private int mVoutCount = 0;
    private boolean mAudioReset = false;
    private String mAudioOutput = null;
    private String mAudioOutputDevice = null;
    private final AWindow mWindow = new AWindow(new AWindow.SurfaceCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesCreated(AWindow vout) {
            boolean play = false;
            boolean enableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (!MediaPlayer.this.mPlaying && MediaPlayer.this.mPlayRequested) {
                    play = true;
                } else if (MediaPlayer.this.mVoutCount == 0) {
                    enableVideo = true;
                }
            }
            if (play) {
                MediaPlayer.this.play();
            } else if (enableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesDestroyed(AWindow vout) {
            boolean disableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (MediaPlayer.this.mVoutCount > 0) {
                    disableVideo = true;
                }
            }
            if (disableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(false);
            }
        }
    });

    private static Title createTitleFromNative(long duration, String name, int flags) {
        return new Title(duration, name, flags);
    }

    private static Chapter createChapterFromNative(long timeOffset, long duration, String name) {
        return new Chapter(timeOffset, duration, name);
    }

    private static TrackDescription createTrackDescriptionFromNative(int id, String name) {
        return new TrackDescription(id, name);
    }

    public MediaPlayer(LibVLC libVLC) {
        this.nativeNewFromLibVlc(libVLC, this.mWindow.getNativeHandler());
    }

    public MediaPlayer(Media media) {
        if (media == null || media.isReleased()) {
            throw new IllegalArgumentException("Media is null or released");
        }
        this.mMedia = media;
        this.mMedia.retain();
        this.nativeNewFromMedia(this.mMedia, this.mWindow.getNativeHandler());
    }

    public IVLCVout getVLCVout() {
        return this.mWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedia(Media media) {
        if (media != null) {
            if (media.isReleased()) {
                throw new IllegalArgumentException("Media is released");
            }
            media.setDefaultMediaPlayerOptions();
        }
        this.nativeSetMedia(media);
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mMedia != null) {
                this.mMedia.release();
            }
            if (media != null) {
                media.retain();
            }
            this.mMedia = media;
        }
    }

    public synchronized Media getMedia() {
        if (this.mMedia != null) {
            this.mMedia.retain();
        }
        return this.mMedia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (!this.mPlaying) {
                if (this.mAudioReset) {
                    if (this.mAudioOutput != null) {
                        this.nativeSetAudioOutput(this.mAudioOutput);
                    }
                    if (this.mAudioOutputDevice != null) {
                        this.nativeSetAudioOutputDevice(this.mAudioOutputDevice);
                    }
                    this.mAudioReset = false;
                }
                this.mPlayRequested = true;
                if (this.mWindow.areSurfacesWaiting()) {
                    return;
                }
            }
            this.mPlaying = true;
        }
        this.nativePlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mPlayRequested = false;
            this.mPlaying = false;
            this.mAudioReset = true;
        }
        this.nativeStop();
    }

    public void setVideoTitleDisplay(int position, int timeout) {
        this.nativeSetVideoTitleDisplay(position, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAudioOutput(String aout) {
        boolean ret = this.nativeSetAudioOutput(aout);
        if (ret) {
            MediaPlayer mediaPlayer = this;
            synchronized (mediaPlayer) {
                this.mAudioOutput = aout;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAudioOutputDevice(String id) {
        boolean ret = this.nativeSetAudioOutputDevice(id);
        if (ret) {
            MediaPlayer mediaPlayer = this;
            synchronized (mediaPlayer) {
                this.mAudioOutputDevice = id;
            }
        }
        return ret;
    }

    public Title[] getTitles() {
        return this.nativeGetTitles();
    }

    public Chapter[] getChapters(int title) {
        return this.nativeGetChapters(title);
    }

    public int getVideoTracksCount() {
        return this.nativeGetVideoTracksCount();
    }

    public TrackDescription[] getVideoTracks() {
        return this.nativeGetVideoTracks();
    }

    public int getVideoTrack() {
        return this.nativeGetVideoTrack();
    }

    public boolean setVideoTrack(int index) {
        if (index == -1 || this.mWindow.areViewsAttached() && !this.mWindow.areSurfacesWaiting()) {
            return this.nativeSetVideoTrack(index);
        }
        return false;
    }

    public void setVideoTrackEnabled(boolean enabled) {
        TrackDescription[] tracks;
        if (!enabled) {
            this.setVideoTrack(-1);
        } else if (this.getVideoTrack() == -1 && (tracks = this.getVideoTracks()) != null) {
            for (TrackDescription track : tracks) {
                if (track.id == -1) continue;
                this.setVideoTrack(track.id);
                break;
            }
        }
    }

    public int getAudioTracksCount() {
        return this.nativeGetAudioTracksCount();
    }

    public TrackDescription[] getAudioTracks() {
        return this.nativeGetAudioTracks();
    }

    public int getAudioTrack() {
        return this.nativeGetAudioTrack();
    }

    public boolean setAudioTrack(int index) {
        return this.nativeSetAudioTrack(index);
    }

    public long getAudioDelay() {
        return this.nativeGetAudioDelay();
    }

    public boolean setAudioDelay(long delay) {
        return this.nativeSetAudioDelay(delay);
    }

    public int getSpuTracksCount() {
        return this.nativeGetSpuTracksCount();
    }

    public TrackDescription[] getSpuTracks() {
        return this.nativeGetSpuTracks();
    }

    public int getSpuTrack() {
        return this.nativeGetSpuTrack();
    }

    public boolean setSpuTrack(int index) {
        return this.nativeSetSpuTrack(index);
    }

    public long getSpuDelay() {
        return this.nativeGetSpuDelay();
    }

    public boolean setSpuDelay(long delay) {
        return this.nativeSetSpuDelay(delay);
    }

    public boolean setEqualizer(Equalizer equalizer) {
        return this.nativeSetEqualizer(equalizer);
    }

    public boolean addSlave(int type, Uri uri, boolean select) {
        return this.nativeAddSlave(type, Media.locationFromUri(uri), select);
    }

    public boolean addSlave(int type, String path, boolean select) {
        return this.addSlave(type, Uri.fromFile((File)new File(path)), select);
    }

    public native void setRate(float var1);

    public native float getRate();

    public native boolean isPlaying();

    public native boolean isSeekable();

    public native void pause();

    public native int getPlayerState();

    public native int getVolume();

    public native int setVolume(int var1);

    public native long getTime();

    public native long setTime(long var1);

    public native float getPosition();

    public native void setPosition(float var1);

    public native long getLength();

    public native int getTitle();

    public native void setTitle(int var1);

    public native int getChapter();

    public native int previousChapter();

    public native int nextChapter();

    public native void setChapter(int var1);

    public native void navigate(int var1);

    public synchronized void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected synchronized Event onEventNative(int eventType, long arg1, float arg2) {
        switch (eventType) {
            case 256: 
            case 262: 
            case 265: 
            case 266: {
                this.mVoutCount = 0;
                this.notify();
            }
            case 258: 
            case 259: {
                return new Event(eventType, arg2);
            }
            case 260: 
            case 261: {
                return new Event(eventType);
            }
            case 267: {
                return new Event(eventType, arg1);
            }
            case 268: {
                return new Event(eventType, arg2);
            }
            case 274: {
                this.mVoutCount = (int)arg1;
                this.notify();
                return new Event(eventType, arg1);
            }
            case 269: 
            case 270: 
            case 276: 
            case 277: {
                return new Event(eventType, arg1);
            }
        }
        return null;
    }

    @Override
    protected void onReleaseNative() {
        if (this.mMedia != null) {
            this.mMedia.release();
        }
        this.nativeRelease();
    }

    private native void nativeNewFromLibVlc(LibVLC var1, AWindowNativeHandler var2);

    private native void nativeNewFromMedia(Media var1, AWindowNativeHandler var2);

    private native void nativeRelease();

    private native void nativeSetMedia(Media var1);

    private native void nativePlay();

    private native void nativeStop();

    private native void nativeSetVideoTitleDisplay(int var1, int var2);

    private native boolean nativeSetAudioOutput(String var1);

    private native boolean nativeSetAudioOutputDevice(String var1);

    private native Title[] nativeGetTitles();

    private native Chapter[] nativeGetChapters(int var1);

    private native int nativeGetVideoTracksCount();

    private native TrackDescription[] nativeGetVideoTracks();

    private native int nativeGetVideoTrack();

    private native boolean nativeSetVideoTrack(int var1);

    private native int nativeGetAudioTracksCount();

    private native TrackDescription[] nativeGetAudioTracks();

    private native int nativeGetAudioTrack();

    private native boolean nativeSetAudioTrack(int var1);

    private native long nativeGetAudioDelay();

    private native boolean nativeSetAudioDelay(long var1);

    private native int nativeGetSpuTracksCount();

    private native TrackDescription[] nativeGetSpuTracks();

    private native int nativeGetSpuTrack();

    private native boolean nativeSetSpuTrack(int var1);

    private native long nativeGetSpuDelay();

    private native boolean nativeSetSpuDelay(long var1);

    private native boolean nativeAddSlave(int var1, String var2, boolean var3);

    private native boolean nativeSetEqualizer(Equalizer var1);

    public static class Equalizer {
        private long mInstance;

        private Equalizer() {
            this.nativeNew();
        }

        private Equalizer(int index) {
            this.nativeNewFromPreset(index);
        }

        protected void finalize() throws Throwable {
            try {
                this.nativeRelease();
            }
            finally {
                super.finalize();
            }
        }

        public static Equalizer create() {
            return new Equalizer();
        }

        public static Equalizer createFromPreset(int index) {
            return new Equalizer(index);
        }

        public static int getPresetCount() {
            return Equalizer.nativeGetPresetCount();
        }

        public static String getPresetName(int index) {
            return Equalizer.nativeGetPresetName(index);
        }

        public static int getBandCount() {
            return Equalizer.nativeGetBandCount();
        }

        public static float getBandFrequency(int index) {
            return Equalizer.nativeGetBandFrequency(index);
        }

        public float getPreAmp() {
            return this.nativeGetPreAmp();
        }

        public boolean setPreAmp(float preamp) {
            return this.nativeSetPreAmp(preamp);
        }

        public float getAmp(int index) {
            return this.nativeGetAmp(index);
        }

        public boolean setAmp(int index, float amp) {
            return this.nativeSetAmp(index, amp);
        }

        private static native int nativeGetPresetCount();

        private static native String nativeGetPresetName(int var0);

        private static native int nativeGetBandCount();

        private static native float nativeGetBandFrequency(int var0);

        private native void nativeNew();

        private native void nativeNewFromPreset(int var1);

        private native void nativeRelease();

        private native float nativeGetPreAmp();

        private native boolean nativeSetPreAmp(float var1);

        private native float nativeGetAmp(int var1);

        private native boolean nativeSetAmp(int var1, float var2);
    }

    public static class TrackDescription {
        public final int id;
        public final String name;

        private TrackDescription(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Chapter {
        public final long timeOffset;
        public final long duration;
        public final String name;

        private Chapter(long timeOffset, long duration, String name) {
            this.timeOffset = timeOffset;
            this.duration = duration;
            this.name = name;
        }
    }

    public static class Title {
        public final long duration;
        public final String name;
        private final int flags;

        public Title(long duration, String name, int flags) {
            this.duration = duration;
            this.name = name;
            this.flags = flags;
        }

        public boolean isMenu() {
            return (this.flags & 1) != 0;
        }

        public boolean isInteractive() {
            return (this.flags & 2) != 0;
        }

        private static class Flags {
            public static final int MENU = 1;
            public static final int INTERACTIVE = 2;

            private Flags() {
            }
        }
    }

    public static class Navigate {
        public static final int Activate = 0;
        public static final int Up = 1;
        public static final int Down = 2;
        public static final int Left = 3;
        public static final int Right = 4;
    }

    public static class Position {
        public static final int Disable = -1;
        public static final int Center = 0;
        public static final int Left = 1;
        public static final int Right = 2;
        public static final int Top = 3;
        public static final int TopLeft = 4;
        public static final int TopRight = 5;
        public static final int Bottom = 6;
        public static final int BottomLeft = 7;
        public static final int BottomRight = 8;
    }

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }

    public static class Event
    extends VLCEvent {
        public static final int MediaChanged = 256;
        public static final int Opening = 258;
        public static final int Buffering = 259;
        public static final int Playing = 260;
        public static final int Paused = 261;
        public static final int Stopped = 262;
        public static final int EndReached = 265;
        public static final int EncounteredError = 266;
        public static final int TimeChanged = 267;
        public static final int PositionChanged = 268;
        public static final int SeekableChanged = 269;
        public static final int PausableChanged = 270;
        public static final int Vout = 274;
        public static final int ESAdded = 276;
        public static final int ESDeleted = 277;

        protected Event(int type) {
            super(type);
        }

        protected Event(int type, long arg1) {
            super(type, arg1);
        }

        protected Event(int type, float arg2) {
            super(type, arg2);
        }

        public long getTimeChanged() {
            return this.arg1;
        }

        public float getPositionChanged() {
            return this.arg2;
        }

        public int getVoutCount() {
            return (int)this.arg1;
        }

        public int getEsChangedType() {
            return (int)this.arg1;
        }

        public boolean getPausable() {
            return this.arg1 != 0L;
        }

        public boolean getSeekable() {
            return this.arg1 != 0L;
        }

        public float getBuffering() {
            return this.arg2;
        }
    }
}

