/*
 * Decompiled with CFR 0.152.
 */
package com.starcut.starflight_client_android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StarFlightBroadcastReceiver
extends BroadcastReceiver {
    private static final String UUID_KEY = "uuid";

    public void onReceive(Context context, Intent data) {
        Log.e((String)"StarFlight Push Client", (String)("Received broadcast: " + data));
        Bundle extras = data.getExtras();
        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)context);
        String messageType = gcm.getMessageType(data);
        if (!extras.isEmpty() && extras.containsKey(UUID_KEY) && "gcm".equals(messageType)) {
            JSONObject options = new JSONObject();
            for (String key : extras.keySet()) {
                if (key.equals("text") || key.equals("url") || key.equals(UUID_KEY)) continue;
                try {
                    options.put(key, extras.get(key));
                }
                catch (JSONException e) {
                    Log.w((String)"StarFlight Push Client", (String)("Failed to serialize extra as JSON: " + extras.get(key)), (Throwable)e);
                }
            }
            String url = extras.containsKey("url") ? extras.getString("url") : null;
            UUID messageUuid = UUID.fromString(extras.getString(UUID_KEY));
            this.onReceive(context, extras.getString("text"), url, messageUuid, options);
        }
    }

    public abstract void onReceive(Context var1, String var2, String var3, UUID var4, JSONObject var5);
}

