/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.x509;

import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateKey;
import com.sshtools.common.ssh.x509.SshX509DsaPublicKey;
import com.sshtools.common.ssh.x509.SshX509DsaPublicKeyRfc6187;
import com.sshtools.common.ssh.x509.SshX509Rsa2048Sha256Rfc6187;
import com.sshtools.common.ssh.x509.SshX509RsaPublicKey;
import com.sshtools.common.ssh.x509.SshX509RsaPublicKeyRfc6187;
import com.sshtools.common.ssh.x509.SshX509RsaSha1PublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class X509Helper {
    public SshKeyPair[] loadKeystore(InputStream in, String alias, String storePassphrase, String keyPassphrase) throws IOException {
        return this.loadKeystore(in, alias, storePassphrase, keyPassphrase, "PKCS12");
    }

    public SshKeyPair[] loadKeystore(InputStream in, String alias, String storePassphrase, String keyPassphrase, String storeType) throws IOException {
        try {
            KeyStore keystore = KeyStore.getInstance(storeType);
            keystore.load(in, storePassphrase.toCharArray());
            Key prv = keystore.getKey(alias, keyPassphrase.toCharArray());
            X509Certificate x509 = (X509Certificate)keystore.getCertificate(alias);
            Certificate[] chain = keystore.getCertificateChain(alias);
            String algorithm = prv.getAlgorithm();
            SshKeyPair pair = new SshKeyPair();
            if (algorithm.equals("RSA")) {
                if (x509.getSigAlgName().equalsIgnoreCase("SHA1WithRSA")) {
                    pair.setPublicKey((SshPublicKey)new SshX509RsaSha1PublicKey(x509));
                    pair.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateKey((RSAPrivateKey)prv));
                    SshKeyPair pair2 = new SshKeyPair();
                    pair2.setPublicKey((SshPublicKey)new SshX509RsaPublicKey(x509));
                    pair2.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateKey((RSAPrivateKey)prv));
                    SshKeyPair pair3 = new SshKeyPair();
                    pair3.setPublicKey((SshPublicKey)new SshX509RsaPublicKeyRfc6187(chain));
                    pair3.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateKey((RSAPrivateKey)prv));
                    return new SshKeyPair[]{pair, pair2, pair3};
                }
                if (x509.getSigAlgName().equalsIgnoreCase("SHA256WithRSA") && ((RSAPublicKey)x509.getPublicKey()).getModulus().bitLength() >= 2048) {
                    pair.setPublicKey((SshPublicKey)new SshX509Rsa2048Sha256Rfc6187(chain));
                    pair.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateKey((RSAPrivateKey)prv));
                    if (Boolean.getBoolean("maverick.backwardCompatibleSHA2")) {
                        SshKeyPair pair2 = new SshKeyPair();
                        pair2.setPublicKey((SshPublicKey)new SshX509RsaPublicKey(x509));
                        pair2.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateKey((RSAPrivateKey)prv));
                        return new SshKeyPair[]{pair, pair2};
                    }
                    return new SshKeyPair[]{pair};
                }
            } else if (algorithm.equals("DSA")) {
                pair.setPublicKey((SshPublicKey)new SshX509DsaPublicKey(x509));
                pair.setPrivateKey((SshPrivateKey)new Ssh2DsaPrivateKey((DSAPrivateKey)prv, (DSAPublicKey)x509.getPublicKey()));
                SshKeyPair pair2 = new SshKeyPair();
                pair2.setPublicKey((SshPublicKey)new SshX509DsaPublicKeyRfc6187(chain));
                pair2.setPrivateKey((SshPrivateKey)new Ssh2DsaPrivateKey((DSAPrivateKey)prv));
                return new SshKeyPair[]{pair, pair2};
            }
            throw new IOException(algorithm + " is an unsupported certificate type");
        }
        catch (Throwable ex) {
            throw new IOException("Could not load keystore from stream: " + ex.getMessage());
        }
    }

    public SshKeyPair[] loadKeystore(File keystoreFile, String alias, String storePassphrase, String keyPassphrase) throws IOException {
        return this.loadKeystore(keystoreFile, alias, storePassphrase, keyPassphrase, "PKCS12");
    }

    public SshKeyPair[] loadKeystore(File keystoreFile, String alias, String storePassphrase, String keyPassphrase, String storeType) throws IOException {
        return this.loadKeystore(new FileInputStream(keystoreFile), alias, storePassphrase, keyPassphrase, storeType);
    }
}

