/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.sshtools.common.util.IOUtils;
import com.sshtools.server.vsession.commands.os.CommandLocator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class ShellUtils {
    public static final String execAndCaptureWithException(String ... args) throws IOException {
        try {
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream();
            Process process = builder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
            int ret = process.waitFor();
            if (ret == 0) {
                return new String(out.toByteArray());
            }
            throw new IOException(new String(out.toByteArray()));
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("The process was interrupted!");
        }
    }

    public static final String execAndCapture(String ... args) throws IOException {
        try {
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream();
            Process process = builder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
            int ret = process.waitFor();
            if (ret == 0) {
                return new String(out.toByteArray());
            }
        }
        catch (Exception e) {
            throw new InterruptedIOException("The process was interrupted!");
        }
        return null;
    }

    public static String findInstalledCommand(String command) throws IOException {
        File cwd = new File(".").getCanonicalFile();
        File cwdCommand = new File(cwd, CommandLocator.getCommandPath(command).toString());
        if (cwdCommand.exists()) {
            return cwdCommand.getAbsolutePath();
        }
        throw new IllegalStateException(String.format("Cannot find %s installed in %s", command, cwdCommand.getAbsolutePath()));
    }

    public static String findCommand(String command, String ... places) throws IOException {
        File cwd = new File(".").getCanonicalFile();
        File cwdCommand = new File(cwd, command);
        if (cwdCommand.exists()) {
            return cwdCommand.getAbsolutePath();
        }
        String stdbuf = ShellUtils.execAndCapture("which", command);
        if (stdbuf == null) {
            for (String place : places) {
                File f = new File(place);
                if (!f.exists()) continue;
                stdbuf = f.getAbsolutePath();
                break;
            }
        }
        if (stdbuf != null) {
            while (stdbuf.endsWith("\n")) {
                stdbuf = stdbuf.substring(0, stdbuf.length() - 1);
            }
        }
        return stdbuf;
    }
}

