/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualSessionPolicy;
import com.sshtools.server.vsession.commands.os.AbstractOSCommand;
import com.sshtools.server.vsession.commands.os.ShellUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class Shell
extends AbstractOSCommand {
    public static final String USER_HOME = "HOME";
    String commandProgram = "$SYSTEMROOT\\System32\\cmd.exe";
    String powershellProgram = "$SYSTEMROOT\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";
    String powershellEncoding = "ISO-8859-1";
    String shellCommand = null;

    public Shell() {
        super("osshell", "System", "osshell", "Run a native shell");
        this.setDescription("The current operating systems shell.");
        this.setBuiltIn(false);
    }

    public Shell(String name) {
        super(name, "System", name, "Run a native shell");
        this.setDescription("The current operating systems shell.");
        this.setBuiltIn(false);
    }

    private String generateWindowsPath(String path) {
        return path.replace("$SYSTEMROOT", StringUtils.defaultIfBlank((CharSequence)System.getenv("SystemRoot"), (CharSequence)"C:\\Windows"));
    }

    @Override
    protected List<String> configureCommand(String cmd, List<String> cmdArgs, VirtualConsole console) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        this.beforeShellCommand(args, console);
        this.shellCommand = ((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellCommand();
        if (SystemUtils.IS_OS_WINDOWS) {
            if (StringUtils.isBlank((CharSequence)this.shellCommand)) {
                String path = this.generateWindowsPath(this.powershellProgram);
                if (Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
                    args.add(path);
                } else {
                    args.add(this.generateWindowsPath(this.commandProgram));
                }
            } else {
                args.add(this.shellCommand);
                args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
            }
        } else {
            if (SystemUtils.IS_OS_MAC_OSX) {
                if (StringUtils.isBlank((CharSequence)this.shellCommand)) {
                    this.shellCommand = ShellUtils.findCommand("/bin/zsh", "zsh", "bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh");
                    if (this.shellCommand == null) {
                        throw new IOException("Cannot find OSX shell.");
                    }
                }
            } else if (StringUtils.isBlank((CharSequence)this.shellCommand)) {
                this.shellCommand = ShellUtils.findCommand("bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh");
                if (this.shellCommand == null) {
                    throw new IOException("Cannot find shell.");
                }
            }
            args.add(this.shellCommand);
            args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
        }
        this.setEnv(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellEnvironment());
        this.setDirectory(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellDirectory());
        return args;
    }

    protected void beforeShellCommand(List<String> args, VirtualConsole console) throws IOException {
    }

    public String getShellCommand() {
        return this.shellCommand;
    }
}

