/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.tasks.CommandTask;
import com.sshtools.client.tasks.ShellTask;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualShellNG;
import com.sshtools.server.vsession.commands.sftp.SftpClientOptions;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.vsession.commands.ssh.AbstractSshClientCommand;
import com.sshtools.vsession.commands.ssh.CommandUtil;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientOptionsEvaluator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class SshClientCommand
extends AbstractSshClientCommand {
    public SshClientCommand() {
        super("ssh", "Shell", "", "Returns the ssh client shell");
        for (Option option : SftpClientOptions.getOptions()) {
            this.options.addOption(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCommand(SshClient sshClient, SshClientArguments arguments, VirtualConsole console) {
        console.getSessionChannel().enableRawMode();
        try {
            ShellTask task;
            Connection connection = sshClient.getConnection();
            WindowSizeChange listener = new WindowSizeChange();
            if (CommandUtil.isNotEmpty(arguments.getCommand())) {
                String command = arguments.getCommand();
                task = CommandTask.CommandTaskBuilder.create().withCommand(command).withTermType(console.getTerminal().getType()).withColumns(console.getTerminal().getWidth()).withRows(console.getTerminal().getHeight()).onBeforeExecute((t, session) -> {
                    listener.session = session;
                    ((VirtualShellNG)console.getSessionChannel()).addWindowSizeChangeListener(listener);
                }).onTask((t, session) -> {
                    connection.addTask((ConnectionAwareTask)Task.ofRunnable((SshConnection)connection, c -> IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream())));
                    IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
                }).onClose((t, session) -> ((VirtualShellNG)console.getSessionChannel()).removeWindowSizeChangeListener(listener)).build();
            } else {
                task = ((ShellTask.ShellTaskBuilder)ShellTask.ShellTaskBuilder.create().withConnection((SshConnection)connection)).withTermType(console.getTerminal().getType()).withColumns(console.getTerminal().getWidth()).withRows(console.getTerminal().getHeight()).onBeforeTask((t, session) -> {
                    listener.session = session;
                    ((VirtualShellNG)console.getSessionChannel()).addWindowSizeChangeListener(listener);
                }).onTask((t, session) -> {
                    connection.addTask((ConnectionAwareTask)Task.ofRunnable((SshConnection)connection, c -> IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream())));
                    IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
                }).onClose((t, session) -> ((VirtualShellNG)console.getSessionChannel()).removeWindowSizeChangeListener(listener)).build();
            }
            connection.addTask((ConnectionAwareTask)task);
            task.waitForever();
        }
        finally {
            console.getSessionChannel().disableRawMode();
            console.println();
        }
    }

    @Override
    protected SshClientArguments generateCommandArguments(CommandLine cli, String[] args) throws IOException, PermissionDeniedException {
        return SshClientOptionsEvaluator.evaluate(cli, args, this.console);
    }

    class WindowSizeChange
    implements VirtualShellNG.WindowSizeChangeListener {
        SessionChannelNG session;

        WindowSizeChange() {
        }

        @Override
        public void newSize(int rows, int cols) {
            if (this.session != null) {
                this.session.changeTerminalDimensions(cols, rows, 0, 0);
            }
        }
    }
}

