/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualSessionPolicy;
import com.sshtools.server.vsession.commands.os.AbstractOSCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class Shell
extends AbstractOSCommand {
    public Shell() {
        super("osshell", "System", "osshell", "Run a native shell");
        this.setDescription("The current operating systems shell");
        this.setBuiltIn(false);
    }

    @Override
    protected List<String> configureCommand(String cmd, List<String> cmdArgs, VirtualConsole console) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String shellCommand = ((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellCommand();
        if (SystemUtils.IS_OS_WINDOWS) {
            if (StringUtils.isBlank((CharSequence)shellCommand)) {
                args.add("C:\\Windows\\System32\\cmd.exe");
            } else {
                args.add(shellCommand);
                args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
            }
        } else {
            if (SystemUtils.IS_OS_MAC_OSX) {
                if (StringUtils.isBlank((CharSequence)shellCommand) && (shellCommand = this.findCommand("zsh", "/bin/zsh", "bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh")) == null) {
                    throw new IOException("Cannot find OSX shell.");
                }
            } else if (StringUtils.isBlank((CharSequence)shellCommand) && (shellCommand = this.findCommand("bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh")) == null) {
                throw new IOException("Cannot find shell.");
            }
            args.add(shellCommand);
            args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
        }
        this.setEnv(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellEnvironment());
        this.setDirectory(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellDirectory());
        return args;
    }
}

