/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.server.vsession.Command;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.ShellUtilities;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Help<T extends AbstractFile>
extends ShellCommand {
    public Help() {
        super("help", "Help", "help <command>", "Display information about the available commands.");
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        Set<String> cmds = console.getShell().getCommandFactory().getSupportedCommands();
        if (args.length == 2 && cmds.contains(args[1])) {
            ((ShellPolicy)console.getContext().getPolicy(ShellPolicy.class)).checkPermission(console.getConnection(), 8192, new String[]{args[1]});
            try {
                Command cmd = console.getShell().getCommandFactory().createCommand(args[1], console.getConnection());
                console.println(cmd.getUsage());
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            Map<String, Command> comandMap;
            HashMap subsystems = new HashMap();
            Iterator<String> it = cmds.iterator();
            while (it.hasNext()) {
                try {
                    Command cmd;
                    String cmdName = it.next();
                    if (!((ShellPolicy)console.getContext().getPolicy(ShellPolicy.class)).checkPermission(console.getConnection(), 8192, new String[]{cmdName}) || (cmd = console.getShell().getCommandFactory().createCommand(cmdName, console.getConnection())).isHidden()) continue;
                    if (!subsystems.containsKey(cmd.getSubsystem())) {
                        comandMap = new HashMap<String, Command>();
                        comandMap.put(cmd.getCommandName(), cmd);
                        subsystems.put(cmd.getSubsystem(), comandMap);
                        continue;
                    }
                    comandMap = (Map)subsystems.get(cmd.getSubsystem());
                    comandMap.put(cmd.getCommandName(), cmd);
                }
                catch (Exception cmdName) {}
            }
            console.println();
            console.println("The following commands are available:");
            console.println();
            for (Map.Entry entry : subsystems.entrySet()) {
                console.println((String)entry.getKey() + " commands:");
                comandMap = (HashMap<String, Command>)entry.getValue();
                ArrayList values = new ArrayList(comandMap.values());
                Collections.sort(values, new Comparator<Command>(){

                    @Override
                    public int compare(Command o1, Command o2) {
                        return o1.getCommandName().compareTo(o2.getCommandName());
                    }
                });
                for (Command shellCmd : values) {
                    console.println(ShellUtilities.padString("", 5) + ShellUtilities.padString(shellCmd.getCommandName(), 30) + shellCmd.getDescription());
                }
                console.println();
            }
            console.println(ShellUtilities.padString("", 5) + ShellUtilities.padString("help [command]", 15) + "Display command signature.");
        }
    }
}

