/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.sftp;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.SftpClient;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.CommandArgumentsParser;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.Msh;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.commands.sftp.Cd;
import com.sshtools.server.vsession.commands.sftp.Chgrp;
import com.sshtools.server.vsession.commands.sftp.Chmod;
import com.sshtools.server.vsession.commands.sftp.Chown;
import com.sshtools.server.vsession.commands.sftp.Get;
import com.sshtools.server.vsession.commands.sftp.Lcd;
import com.sshtools.server.vsession.commands.sftp.Lpwd;
import com.sshtools.server.vsession.commands.sftp.Ls;
import com.sshtools.server.vsession.commands.sftp.Mkdir;
import com.sshtools.server.vsession.commands.sftp.Put;
import com.sshtools.server.vsession.commands.sftp.Pwd;
import com.sshtools.server.vsession.commands.sftp.Quit;
import com.sshtools.server.vsession.commands.sftp.Rename;
import com.sshtools.server.vsession.commands.sftp.Rm;
import com.sshtools.server.vsession.commands.sftp.Rmdir;
import com.sshtools.server.vsession.commands.sftp.SftpClientOptions;
import com.sshtools.server.vsession.commands.sftp.SftpClientOptionsEvaluator;
import com.sshtools.server.vsession.commands.sftp.SftpCommand;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class SftpClientCommand
extends Msh {
    private Options options = new Options();

    public SftpClientCommand() {
        super("sftp", "Shell", "", "Returns the sftp client shell");
        for (Option option : SftpClientOptions.getOptions()) {
            this.options.addOption(option);
        }
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getUsage() {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), "sftp", "", this.getOptions(), formatter.getLeftPadding(), formatter.getDescPadding(), "");
        pw.flush();
        String result = out.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException {
        String[] argsCopy = new String[args.length];
        System.arraycopy(args, 0, argsCopy, 0, args.length);
        CommandLine commandLine = CommandArgumentsParser.parse(this.getOptions(), argsCopy, this.getUsage());
        SshClientArguments arguments = SftpClientOptionsEvaluator.evaluate(commandLine, console);
        try (SshClient sshClient = null;){
            sshClient = SshClientHelper.connectClient(arguments, console);
            Connection connection = sshClient.getConnection();
            SftpClient sftp = new SftpClient((SshConnection)connection, console.getFileFactory());
            String previousPrompt = console.getEnvironment().put("PROMPT", "sftp> ");
            this.setCommandFactory(new SftpCommandFactory(sftp));
            try {
                this.runShell(console);
            }
            finally {
                console.getEnvironment().put("PROMPT", previousPrompt);
            }
        }
    }

    class SftpCommandFactory
    extends CommandFactory<SftpCommand> {
        SftpClient sftpClient;

        SftpCommandFactory(SftpClient sftpClient) {
            this.sftpClient = sftpClient;
            this.installCommand(Quit.class);
            this.installCommand(Lpwd.class);
            this.installCommand(Pwd.class);
            this.installCommand(Cd.class);
            this.installCommand(Lcd.class);
            this.installCommand(Ls.class);
            this.installCommand(Put.class);
            this.installCommand(Get.class);
            this.installCommand(Chgrp.class);
            this.installCommand(Chmod.class);
            this.installCommand(Chown.class);
            this.installCommand(Mkdir.class);
            this.installCommand(Rename.class);
            this.installCommand(Rm.class);
            this.installCommand(Rmdir.class);
        }

        @Override
        protected void configureCommand(SftpCommand command, SshConnection con) throws IOException, PermissionDeniedException {
            command.setSftpClient(this.sftpClient);
        }
    }
}

