/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.AbstractSshOptionsEvaluator;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientOptionsExtractor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class SshClientOptionsEvaluator
extends AbstractSshOptionsEvaluator {
    public static SshClientArguments evaluate(CommandLine commandLine, String[] originalArguments, VirtualConsole console) throws IOException, PermissionDeniedException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"The argument list passed as {}", (Object[])new Object[]{commandLine.getArgList()});
            List optionList = Arrays.asList(commandLine.getOptions()).stream().map(option -> String.format("%s -> %s", option.getArgName(), option.getValue())).collect(Collectors.toList());
            Log.debug((String)"The option list passed as {}", (Object[])new Object[]{optionList});
        }
        SshClientArguments arguments = new SshClientArguments();
        SshClientOptionsEvaluator.parseCommand(originalArguments, arguments);
        SshClientOptionsEvaluator.parsePort(commandLine, arguments);
        SshClientOptionsEvaluator.parseLoginName(commandLine, arguments);
        SshClientOptionsEvaluator.parseIdentityFilename(commandLine, arguments, console);
        SshClientOptionsEvaluator.parseCiphers(commandLine, arguments);
        SshClientOptionsEvaluator.parseMacs(commandLine, arguments);
        SshClientOptionsEvaluator.parseSecurityLevel(commandLine, arguments);
        SshClientOptionsEvaluator.parseCompression(commandLine, arguments);
        SshClientOptionsEvaluator.parseDestination(commandLine, arguments);
        return arguments;
    }

    private static void parseCommand(String[] originalArguments, SshClientArguments arguments) {
        int indexTillSshClientCommandFound = SshClientOptionsExtractor.extractSshCommandLineFromExecuteCommand(originalArguments);
        if (originalArguments.length == indexTillSshClientCommandFound + 1) {
            return;
        }
        CharSequence[] executeCommand = Arrays.copyOfRange(originalArguments, indexTillSshClientCommandFound + 1, originalArguments.length);
        String command = String.join((CharSequence)" ", executeCommand);
        arguments.setCommand(command);
    }
}

